/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common;

import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gearman.client.GearmanIOEventListener;
import org.gearman.common.GearmanException;
import org.gearman.common.GearmanPacket;
import org.gearman.common.GearmanPacketMagic;
import org.gearman.common.GearmanServerResponseHandler;

public class GearmanTask
implements GearmanIOEventListener {
    static final String DESCRIPTION_PREFIX = "GearmanTask";
    private final String DESCRIPTION;
    private State state = null;
    private GearmanPacket requestPacket = null;
    private GearmanServerResponseHandler handler = null;
    private static final Logger LOG = Logger.getLogger("org.gearman.job.logger");

    public GearmanTask(GearmanPacket packet) {
        this(null, packet);
    }

    public GearmanTask(GearmanServerResponseHandler handler, GearmanPacket packet) {
        if (packet == null) {
            throw new IllegalArgumentException("The request can not be null");
        }
        if (!packet.getMagic().equals((Object)GearmanPacketMagic.REQ)) {
            throw new IllegalArgumentException("Invalid request. The packet is not a request packet");
        }
        this.state = State.NEW;
        UUID uuid = UUID.randomUUID();
        this.requestPacket = packet;
        this.handler = handler;
        this.DESCRIPTION = "GearmanTask:" + handler + ":" + uuid;
    }

    @Override
    public void handleGearmanIOEvent(GearmanPacket p) throws IllegalArgumentException {
        if (p == null) {
            throw new IllegalArgumentException("You can not add a null response packet");
        }
        boolean cont = true;
        block9: while (cont) {
            switch (this.state) {
                case NEW: {
                    if (p.getMagic().equals((Object)GearmanPacketMagic.REQ)) {
                        if (this.requestPacket.requiresResponse()) {
                            this.changeState(State.SUBMITTED);
                        } else {
                            this.changeState(State.FINISHED);
                        }
                    }
                    cont = false;
                    continue block9;
                }
                case SUBMITTED: {
                    if (p.getMagic().equals((Object)GearmanPacketMagic.RES)) {
                        this.changeState(State.RUNNING);
                        continue block9;
                    }
                    cont = false;
                    continue block9;
                }
                case RUNNING: {
                    if (p.getMagic().equals((Object)GearmanPacketMagic.RES)) {
                        if (this.handler == null) {
                            LOG.log(Level.WARNING, "ServerRequest requires response, but not response handler was provided for the request. Request = " + this);
                            this.changeState(State.EXCEPTION);
                            continue block9;
                        }
                        try {
                            this.handler.handleEvent(p);
                            if (this.handler.isDone()) {
                                this.changeState(State.FINISHED);
                                continue block9;
                            }
                            this.changeState(State.RUNNING);
                            cont = false;
                        }
                        catch (GearmanException ge) {
                            this.changeState(State.EXCEPTION);
                        }
                        continue block9;
                    }
                    cont = false;
                    continue block9;
                }
                case FINISHED: {
                    cont = false;
                    continue block9;
                }
                case EXCEPTION: {
                    throw new GearmanException("Encountered Fatal Exception while driving the following ServerRequest: " + this.requestPacket);
                }
            }
            throw new GearmanException("Unknown Request state " + (Object)((Object)this.state) + " for request " + this.requestPacket);
        }
    }

    public GearmanPacket getRequestPacket() {
        return this.requestPacket;
    }

    public GearmanServerResponseHandler getHandler() {
        return this.handler;
    }

    public String toString() {
        return this.DESCRIPTION;
    }

    public State getState() {
        return this.state;
    }

    private void changeState(State newState) {
        if (!newState.equals((Object)this.state)) {
            LOG.log(Level.FINE, "Request " + this + " is changing state" + " from " + (Object)((Object)this.state) + " to " + (Object)((Object)newState));
            this.state = newState;
        }
    }

    public static enum State {
        NEW,
        SUBMITTED,
        RUNNING,
        FINISHED,
        EXCEPTION;

    }
}

