/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.gearman.common.GearmanPacket;
import org.gearman.common.GearmanPacketHeader;
import org.gearman.common.GearmanPacketMagic;
import org.gearman.common.GearmanPacketType;
import org.gearman.util.ByteUtils;
import org.gearman.util.IOUtil;

public class GearmanPacketImpl
implements GearmanPacket {
    private final GearmanPacketMagic magic;
    private final GearmanPacketType type;
    private final byte[] data;

    public GearmanPacketImpl(GearmanPacketMagic magic, GearmanPacketType type, byte[] data) {
        this.magic = magic;
        this.type = type;
        this.data = ByteUtils.copy(data);
    }

    public GearmanPacketImpl(InputStream in) {
        byte[] bytes = new byte[12];
        this.blockUntilReadFully(in, bytes);
        GearmanPacketHeader header = new GearmanPacketHeader(bytes);
        byte[] inputData = new byte[header.getDataLength()];
        if (inputData.length > 0) {
            IOUtil.readFully(in, inputData);
        }
        this.magic = header.getMagic();
        this.type = header.getType();
        this.data = inputData;
    }

    @Override
    public byte[] getData() {
        return ByteUtils.copy(this.data);
    }

    public int getDataSize() {
        return this.data.length;
    }

    @Override
    public GearmanPacketType getPacketType() {
        return this.type;
    }

    @Override
    public GearmanPacketMagic getMagic() {
        return this.magic;
    }

    @Override
    public byte[] toBytes() {
        int totalSize = this.getDataSize() + 12;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(totalSize);
        this.write(baos);
        IOUtil.flush(baos);
        return baos.toByteArray();
    }

    ArrayList<byte[]> getDataComponents(int tokens) {
        int i;
        int curToken = 0;
        int curTokenStart = 0;
        byte[] curTokenData = null;
        ArrayList<byte[]> al = new ArrayList<byte[]>(tokens);
        if (tokens == 0) {
            return al;
        }
        for (i = 0; curToken < tokens - 1 && i < this.data.length; ++i) {
            if (this.data[i] != 0) continue;
            curTokenData = new byte[i - curTokenStart];
            System.arraycopy(this.data, curTokenStart, curTokenData, 0, i - curTokenStart);
            al.add(curTokenData);
            curTokenStart = i + 1;
            ++curToken;
        }
        curTokenData = new byte[this.data.length - i];
        System.arraycopy(this.data, curTokenStart, curTokenData, 0, this.data.length - i);
        al.add(curTokenData);
        return al;
    }

    public void write(OutputStream os) {
        new GearmanPacketHeader(this.magic, this.type, this.getDataSize()).write(os);
        IOUtil.write(os, this.data);
    }

    public GearmanPacketType getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer s = new StringBuffer((Object)((Object)this.magic) + ":" + (Object)((Object)this.type) + ":" + this.data.length);
        if (this.data.length > 0) {
            s.append(": [" + ByteUtils.toHex(this.data) + "]");
        }
        return s.toString();
    }

    @Override
    public boolean requiresResponse() {
        if (this.magic.equals((Object)GearmanPacketMagic.RES)) {
            return false;
        }
        return this.type.equals((Object)GearmanPacketType.PRE_SLEEP) || this.type.equals((Object)GearmanPacketType.GRAB_JOB) || this.type.equals((Object)GearmanPacketType.GRAB_JOB_UNIQ) || this.type.equals((Object)GearmanPacketType.GET_STATUS) || this.type.equals((Object)GearmanPacketType.ECHO_REQ) || this.type.equals((Object)GearmanPacketType.SUBMIT_JOB) || this.type.equals((Object)GearmanPacketType.SUBMIT_JOB_BG) || this.type.equals((Object)GearmanPacketType.SUBMIT_JOB_LOW) || this.type.equals((Object)GearmanPacketType.SUBMIT_JOB_LOW_BG) || this.type.equals((Object)GearmanPacketType.SUBMIT_JOB_HIGH) || this.type.equals((Object)GearmanPacketType.SUBMIT_JOB_HIGH_BG) || this.type.equals((Object)GearmanPacketType.OPTION_REQ);
    }

    @Override
    public byte[] getDataComponentValue(GearmanPacket.DataComponentName component) {
        HashMap<GearmanPacket.DataComponentName, byte[]> valuesMap = new HashMap<GearmanPacket.DataComponentName, byte[]>();
        ArrayList<byte[]> components = null;
        switch (this.type) {
            case ECHO_REQ: 
            case ECHO_RES: {
                components = this.getDataComponents(1);
                valuesMap.put(GearmanPacket.DataComponentName.DATA, components.get(0));
                break;
            }
            case ERROR: {
                components = this.getDataComponents(2);
                valuesMap.put(GearmanPacket.DataComponentName.ERROR_CODE, components.get(0));
                valuesMap.put(GearmanPacket.DataComponentName.ERROR_TEXT, components.get(1));
                break;
            }
            case SUBMIT_JOB: 
            case SUBMIT_JOB_BG: 
            case SUBMIT_JOB_LOW: 
            case SUBMIT_JOB_LOW_BG: 
            case SUBMIT_JOB_HIGH: 
            case SUBMIT_JOB_HIGH_BG: {
                components = this.getDataComponents(3);
                valuesMap.put(GearmanPacket.DataComponentName.FUNCTION_NAME, components.get(0));
                valuesMap.put(GearmanPacket.DataComponentName.UNIQUE_ID, components.get(1));
                valuesMap.put(GearmanPacket.DataComponentName.DATA, components.get(2));
                break;
            }
            case SUBMIT_JOB_SCHED: {
                components = this.getDataComponents(8);
                valuesMap.put(GearmanPacket.DataComponentName.FUNCTION_NAME, components.get(0));
                valuesMap.put(GearmanPacket.DataComponentName.UNIQUE_ID, components.get(1));
                valuesMap.put(GearmanPacket.DataComponentName.MINUTE, components.get(2));
                valuesMap.put(GearmanPacket.DataComponentName.HOUR, components.get(3));
                valuesMap.put(GearmanPacket.DataComponentName.DAY_OF_MONTH, components.get(4));
                valuesMap.put(GearmanPacket.DataComponentName.MONTH, components.get(5));
                valuesMap.put(GearmanPacket.DataComponentName.DAY_OF_WEEK, components.get(6));
                valuesMap.put(GearmanPacket.DataComponentName.DATA, components.get(7));
                break;
            }
            case SUBMIT_JOB_EPOCH: {
                components = this.getDataComponents(4);
                valuesMap.put(GearmanPacket.DataComponentName.FUNCTION_NAME, components.get(0));
                valuesMap.put(GearmanPacket.DataComponentName.UNIQUE_ID, components.get(1));
                valuesMap.put(GearmanPacket.DataComponentName.EPOCH, components.get(2));
                valuesMap.put(GearmanPacket.DataComponentName.DATA, components.get(3));
                break;
            }
            case GET_STATUS: 
            case JOB_CREATED: 
            case WORK_FAIL: {
                components = this.getDataComponents(1);
                valuesMap.put(GearmanPacket.DataComponentName.JOB_HANDLE, components.get(0));
                break;
            }
            case OPTION_REQ: 
            case OPTION_RES: {
                components = this.getDataComponents(1);
                valuesMap.put(GearmanPacket.DataComponentName.OPTION, components.get(0));
                break;
            }
            case CAN_DO: 
            case CANT_DO: {
                components = this.getDataComponents(1);
                valuesMap.put(GearmanPacket.DataComponentName.FUNCTION_NAME, components.get(0));
                break;
            }
            case CAN_DO_TIMEOUT: {
                components = this.getDataComponents(2);
                valuesMap.put(GearmanPacket.DataComponentName.FUNCTION_NAME, components.get(0));
                valuesMap.put(GearmanPacket.DataComponentName.TIME_OUT, components.get(1));
                break;
            }
            case WORK_DATA: 
            case WORK_WARNING: 
            case WORK_COMPLETE: 
            case WORK_EXCEPTION: {
                components = this.getDataComponents(2);
                valuesMap.put(GearmanPacket.DataComponentName.JOB_HANDLE, components.get(0));
                valuesMap.put(GearmanPacket.DataComponentName.DATA, components.get(1));
                break;
            }
            case WORK_STATUS: {
                components = this.getDataComponents(3);
                valuesMap.put(GearmanPacket.DataComponentName.JOB_HANDLE, components.get(0));
                valuesMap.put(GearmanPacket.DataComponentName.NUMERATOR, components.get(1));
                valuesMap.put(GearmanPacket.DataComponentName.DENOMINATOR, components.get(2));
                break;
            }
            case STATUS_RES: {
                components = this.getDataComponents(5);
                valuesMap.put(GearmanPacket.DataComponentName.JOB_HANDLE, components.get(0));
                valuesMap.put(GearmanPacket.DataComponentName.KNOWN_STATUS, components.get(1));
                valuesMap.put(GearmanPacket.DataComponentName.RUNNING_STATUS, components.get(2));
                valuesMap.put(GearmanPacket.DataComponentName.NUMERATOR, components.get(3));
                valuesMap.put(GearmanPacket.DataComponentName.DENOMINATOR, components.get(4));
                break;
            }
            case SET_CLIENT_ID: {
                components = this.getDataComponents(1);
                valuesMap.put(GearmanPacket.DataComponentName.CLIENT_ID, components.get(0));
                break;
            }
            case JOB_ASSIGN: {
                components = this.getDataComponents(3);
                valuesMap.put(GearmanPacket.DataComponentName.JOB_HANDLE, components.get(0));
                valuesMap.put(GearmanPacket.DataComponentName.FUNCTION_NAME, components.get(1));
                valuesMap.put(GearmanPacket.DataComponentName.DATA, components.get(2));
                break;
            }
            case JOB_ASSIGN_UNIQ: {
                components = this.getDataComponents(4);
                valuesMap.put(GearmanPacket.DataComponentName.JOB_HANDLE, components.get(0));
                valuesMap.put(GearmanPacket.DataComponentName.FUNCTION_NAME, components.get(1));
                valuesMap.put(GearmanPacket.DataComponentName.UNIQUE_ID, components.get(2));
                valuesMap.put(GearmanPacket.DataComponentName.DATA, components.get(3));
                break;
            }
            case RESET_ABILITIES: 
            case PRE_SLEEP: 
            case GRAB_JOB: 
            case GRAB_JOB_UNIQ: 
            case ALL_YOURS: 
            case NOOP: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown packet type " + (Object)((Object)this.type));
            }
        }
        byte[] rt = valuesMap.containsKey((Object)component) ? (byte[])valuesMap.get((Object)component) : new byte[]{};
        return rt;
    }

    public static byte[] generatePacketData(byte[] ... data) {
        int len = 0;
        int curPos = 0;
        for (byte[] curArray : data) {
            len += curArray.length + 1;
        }
        byte[] rdata = new byte[--len];
        for (byte[] curArray : data) {
            System.arraycopy(curArray, 0, rdata, curPos, curArray.length);
            if ((curPos += curArray.length) >= rdata.length) continue;
            rdata[curPos++] = 0;
        }
        return rdata;
    }

    /*
     * Exception decompiling
     */
    private void blockUntilReadFully(InputStream in, byte[] bytes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

