/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.ec.parameters;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Type;
import codec.asn1.ResolverException;
import de.flexiprovider.api.Registry;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.common.exceptions.NoSuchBasisException;
import de.flexiprovider.common.exceptions.PolynomialIsNotIrreducibleException;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.math.ellipticcurves.EllipticCurve;
import de.flexiprovider.common.math.ellipticcurves.EllipticCurveGF2n;
import de.flexiprovider.common.math.ellipticcurves.EllipticCurveGFP;
import de.flexiprovider.common.math.ellipticcurves.PointGF2n;
import de.flexiprovider.common.math.ellipticcurves.PointGFP;
import de.flexiprovider.common.math.finitefields.GF2Polynomial;
import de.flexiprovider.common.math.finitefields.GF2nElement;
import de.flexiprovider.common.math.finitefields.GF2nONBElement;
import de.flexiprovider.common.math.finitefields.GF2nONBField;
import de.flexiprovider.common.math.finitefields.GF2nPolynomialElement;
import de.flexiprovider.common.math.finitefields.GF2nPolynomialField;
import de.flexiprovider.common.math.finitefields.GFPElement;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.ec.asn1.CharacteristicTwoField;
import de.flexiprovider.ec.asn1.Curve;
import de.flexiprovider.ec.asn1.ECDomainParameters;
import de.flexiprovider.ec.asn1.FieldId;
import de.flexiprovider.ec.asn1.Parameters;
import de.flexiprovider.ec.asn1.PpBasis;
import de.flexiprovider.ec.asn1.PrimeField;
import de.flexiprovider.ec.parameters.CurveParams;
import java.io.IOException;

public class ECParameters
extends AlgorithmParameters {
    public static final String OID = "1.2.840.10045.4.1";
    private CurveParams curveParams;

    public void init(AlgorithmParameterSpec params) throws InvalidParameterSpecException {
        if (params == null || !(params instanceof CurveParams)) {
            throw new InvalidParameterSpecException("unsupported type");
        }
        this.curveParams = (CurveParams)params;
    }

    public void init(byte[] encParams) throws IOException {
        Parameters params = new Parameters();
        try {
            ASN1Tools.derDecode(encParams, (ASN1Type)params);
        }
        catch (ASN1Exception asn1e) {
            throw new IOException("ASN1Exception: " + asn1e.getMessage());
        }
        ASN1Type type = params.getInnerType();
        if (type instanceof ASN1ObjectIdentifier) {
            try {
                AlgorithmParameterSpec curveParams = Registry.getAlgParamSpec(((ASN1ObjectIdentifier)type).toString());
                this.init(curveParams);
            }
            catch (InvalidAlgorithmParameterException iape) {
                throw new IOException("InvalidAlgorithmParameterException: " + iape.getMessage());
            }
            catch (InvalidParameterSpecException e) {
                throw new RuntimeException("internal error");
            }
        }
        if (type instanceof ECDomainParameters) {
            ECDomainParameters asn1params = (ECDomainParameters)type;
            ASN1Type fieldParam = null;
            try {
                fieldParam = asn1params.getFieldId().getField().getInnerType();
            }
            catch (ResolverException re) {
                throw new IOException("ResolverException: " + re.getMessage());
            }
            FlexiBigInt r = asn1params.getR();
            int k = asn1params.getK();
            if (fieldParam instanceof PrimeField) {
                FlexiBigInt p = ((PrimeField)fieldParam).getQ();
                GFPElement a = new GFPElement(asn1params.getA(), p);
                GFPElement b = new GFPElement(asn1params.getB(), p);
                PointGFP g = new PointGFP(asn1params.getG(), new EllipticCurveGFP(a, b, p));
                this.curveParams = new CurveParams.CurveParamsGFP(g, r, k);
            } else if (fieldParam instanceof CharacteristicTwoField) {
                CharacteristicTwoField cFieldParams = (CharacteristicTwoField)fieldParam;
                int n = cFieldParams.getN();
                if (cFieldParams.isONB()) {
                    GF2nONBField onbField = new GF2nONBField(n);
                    GF2nONBElement a = new GF2nONBElement(onbField, asn1params.getA());
                    GF2nONBElement b = new GF2nONBElement(onbField, asn1params.getB());
                    EllipticCurveGF2n E = new EllipticCurveGF2n((GF2nElement)a, (GF2nElement)b, n);
                    PointGF2n g = new PointGF2n(asn1params.getG(), E);
                    this.curveParams = new CurveParams.CurveParamsGF2nONB(g, r, n, k);
                } else if (cFieldParams.isTrinomial()) {
                    int tc = cFieldParams.getTrinom().getTC();
                    int[] polBytes = new int[n + 31 >> 5];
                    polBytes[0] = 1;
                    int n2 = tc >> 5;
                    polBytes[n2] = polBytes[n2] | 1 << (tc & 0x1F);
                    int n3 = n >> 5;
                    polBytes[n3] = polBytes[n3] | 1 << (n & 0x1F);
                    GF2Polynomial fieldPoly = new GF2Polynomial(n + 1, polBytes);
                    GF2nPolynomialField polyField = null;
                    try {
                        polyField = new GF2nPolynomialField(n, fieldPoly);
                    }
                    catch (PolynomialIsNotIrreducibleException PINIExc) {
                        throw new NoSuchBasisException(PINIExc.getMessage());
                    }
                    GF2nPolynomialElement a = new GF2nPolynomialElement(polyField, asn1params.getA());
                    GF2nPolynomialElement b = new GF2nPolynomialElement(polyField, asn1params.getB());
                    EllipticCurveGF2n E = new EllipticCurveGF2n((GF2nElement)a, (GF2nElement)b, n);
                    PointGF2n g = new PointGF2n(asn1params.getG(), E);
                    this.curveParams = new CurveParams.CurveParamsGF2nTrinomial(g, r, n, k, tc);
                } else if (cFieldParams.isPentanomial()) {
                    PpBasis pBasis = cFieldParams.getPenta();
                    int pc1 = pBasis.getPC1();
                    int pc2 = pBasis.getPC2();
                    int pc3 = pBasis.getPC3();
                    int[] polBytes = new int[n + 31 >> 5];
                    polBytes[0] = 1;
                    int n4 = pc1 >> 5;
                    polBytes[n4] = polBytes[n4] | 1 << (pc1 & 0x1F);
                    int n5 = pc2 >> 5;
                    polBytes[n5] = polBytes[n5] | 1 << (pc2 & 0x1F);
                    int n6 = pc3 >> 5;
                    polBytes[n6] = polBytes[n6] | 1 << (pc3 & 0x1F);
                    int n7 = n >> 5;
                    polBytes[n7] = polBytes[n7] | 1 << (n & 0x1F);
                    GF2Polynomial fieldPoly = new GF2Polynomial(n + 1, polBytes);
                    GF2nPolynomialField polyField = null;
                    try {
                        polyField = new GF2nPolynomialField(n, fieldPoly);
                    }
                    catch (PolynomialIsNotIrreducibleException PINIExc) {
                        throw new NoSuchBasisException(PINIExc.getMessage());
                    }
                    GF2nPolynomialElement a = new GF2nPolynomialElement(polyField, asn1params.getA());
                    GF2nPolynomialElement b = new GF2nPolynomialElement(polyField, asn1params.getB());
                    EllipticCurveGF2n E = new EllipticCurveGF2n((GF2nElement)a, (GF2nElement)b, n);
                    PointGF2n g = new PointGF2n(asn1params.getG(), E);
                    this.curveParams = new CurveParams.CurveParamsGF2nPentanomial(g, r, n, k, pc1, pc2, pc3);
                }
            }
        } else {
            throw new IOException("invalid encoding");
        }
    }

    public void init(byte[] encParams, String format) throws IOException {
        if (!format.equals("ASN.1")) {
            throw new IOException("unsupported format");
        }
        this.init(encParams);
    }

    public byte[] getEncoded() {
        ASN1ObjectIdentifier oid = this.curveParams.getOID();
        if (oid != null) {
            return ASN1Tools.derEncode((ASN1Type)oid);
        }
        return ASN1Tools.derEncode((ASN1Type)this.getASN1Params());
    }

    public byte[] getEncoded(String format) throws IOException {
        if (!format.equals("ASN.1")) {
            throw new IOException("Unsupported encoding format.");
        }
        return this.getEncoded();
    }

    public AlgorithmParameterSpec getParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (paramSpec == null || !paramSpec.isAssignableFrom(this.curveParams.getClass())) {
            throw new InvalidParameterSpecException("unsupported type");
        }
        return this.curveParams;
    }

    public String toString() {
        return this.curveParams.toString();
    }

    public ECDomainParameters getASN1Params() {
        EllipticCurve E = this.curveParams.getE();
        Curve aE = new Curve(E.getA(), E.getB());
        byte[] gBytes = this.curveParams.getG().EC2OSP(0);
        ASN1OctetString aG = new ASN1OctetString(gBytes);
        ASN1Integer aR = new ASN1Integer(1, this.curveParams.getR().toByteArray());
        ASN1Integer aK = new ASN1Integer(this.curveParams.getK());
        FieldId aFieldID = null;
        if (this.curveParams instanceof CurveParams.CurveParamsGFP) {
            PrimeField aPF = new PrimeField(this.curveParams.getQ());
            aFieldID = new FieldId(aPF);
        } else if (this.curveParams instanceof CurveParams.CurveParamsGF2nONB) {
            CharacteristicTwoField aCF = new CharacteristicTwoField(((CurveParams.CurveParamsGF2n)this.curveParams).getN());
            aFieldID = new FieldId(aCF);
        } else if (this.curveParams instanceof CurveParams.CurveParamsGF2nTrinomial) {
            CurveParams.CurveParamsGF2nTrinomial trinomialParams = (CurveParams.CurveParamsGF2nTrinomial)this.curveParams;
            CharacteristicTwoField aCTF = new CharacteristicTwoField(trinomialParams.getN(), trinomialParams.getTC());
            aFieldID = new FieldId(aCTF);
        } else if (this.curveParams instanceof CurveParams.CurveParamsGF2nPentanomial) {
            CurveParams.CurveParamsGF2nPentanomial pentanomialParams = (CurveParams.CurveParamsGF2nPentanomial)this.curveParams;
            CharacteristicTwoField aCPF = new CharacteristicTwoField(pentanomialParams.getN(), pentanomialParams.getPC1(), pentanomialParams.getPC2(), pentanomialParams.getPC3());
            aFieldID = new FieldId(aCPF);
        } else {
            aFieldID = new FieldId();
        }
        return new ECDomainParameters(aFieldID, aE, aG, aR, aK);
    }
}

