/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.ec.keys;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.KeyPair;
import de.flexiprovider.api.keys.KeyPairGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.math.ellipticcurves.Point;
import de.flexiprovider.common.math.ellipticcurves.ScalarMult;
import de.flexiprovider.ec.keys.ECPrivateKey;
import de.flexiprovider.ec.keys.ECPublicKey;
import de.flexiprovider.ec.parameters.CurveParams;
import de.flexiprovider.ec.parameters.CurveRegistry;

public class ECKeyPairGenerator
extends KeyPairGenerator {
    public static final int DEFAULT_KEY_SIZE = 192;
    private CurveParams curveParams;
    private SecureRandom mRandom = null;
    private Point[] mOddPowers = null;
    private FlexiBigInt r;
    private int rLength;
    private boolean initialized;

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params == null) {
            this.initialize(192, random);
            return;
        }
        if (!(params instanceof CurveParams)) {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.curveParams = (CurveParams)params;
        this.r = this.curveParams.getR();
        this.rLength = this.r.bitLength();
        this.mOddPowers = ScalarMult.pre_oddpowers(this.curveParams.getG(), 4);
        this.mRandom = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void initialize(int keySize, SecureRandom random) {
        CurveParams params;
        try {
            String paramName = CurveRegistry.getDefaultCurveParams(keySize);
            params = (CurveParams)Registry.getAlgParamSpec(paramName);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e.getMessage());
        }
        try {
            this.initialize(params, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    private void initializeDefault() {
        this.initialize(192, Registry.getSecureRandom());
    }

    public KeyPair genKeyPair() {
        FlexiBigInt s;
        if (!this.initialized) {
            this.initializeDefault();
        }
        while ((s = new FlexiBigInt(this.rLength, this.mRandom)).compareTo(FlexiBigInt.ONE) < 0 || s.compareTo(this.r) >= 0) {
        }
        ECPrivateKey privKey = new ECPrivateKey(s, this.curveParams);
        ECPublicKey pubKey = new ECPublicKey(ScalarMult.eval_SquareMultiply(ScalarMult.determineNaf(s, 4), this.mOddPowers), this.curveParams);
        return new KeyPair(pubKey, privKey);
    }
}

