/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.ec;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.Signature;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidParameterException;
import de.flexiprovider.api.exceptions.SignatureException;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.math.ellipticcurves.Point;
import de.flexiprovider.common.math.ellipticcurves.PointGF2n;
import de.flexiprovider.common.math.ellipticcurves.PointGFP;
import de.flexiprovider.common.math.ellipticcurves.ScalarMult;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.common.util.FlexiBigIntUtils;
import de.flexiprovider.core.md.SHA1;
import de.flexiprovider.ec.keys.ECPrivateKey;
import de.flexiprovider.ec.keys.ECPublicKey;
import de.flexiprovider.ec.parameters.CurveParams;
import java.io.IOException;
import java.util.ArrayList;

public class ECNRSignature
extends Signature {
    private SecureRandom mSecureRandom;
    private MessageDigest md;
    private FlexiBigInt mS;
    private Point mW;
    private CurveParams mParams;
    private FlexiBigInt mR;
    private Point mG;
    private Point[] mOddPowers;
    private int rLength;
    private FlexiBigInt u = FlexiBigInt.ZERO;
    private Point V;

    public ECNRSignature() {
        this.md = new SHA1();
    }

    public void initSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyException("The given private Key is not an ECPrivateKey.");
        }
        ECPrivateKey privKey = (ECPrivateKey)privateKey;
        this.mS = privKey.getS();
        this.mParams = privKey.getParams();
        this.mR = this.mParams.getR();
        this.rLength = this.mR.bitLength();
        this.mG = this.mParams.getG();
        this.mOddPowers = ScalarMult.pre_oddpowers(this.mG, 4);
        this.md.reset();
        this.mSecureRandom = random != null ? random : Registry.getSecureRandom();
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyException("The given publicKey is not an ECPublicKey.");
        }
        ECPublicKey pubKey = (ECPublicKey)publicKey;
        this.mW = pubKey.getW();
        this.mParams = pubKey.getParams();
        this.mR = this.mParams.getR();
        this.mG = this.mParams.getG();
        this.md.reset();
    }

    public void setParameters(AlgorithmParameterSpec params) throws InvalidParameterException {
        if (!(params instanceof CurveParams)) {
            throw new InvalidParameterException("unsupported type");
        }
        this.mParams = (CurveParams)params;
    }

    public byte[] sign() {
        byte[] hash = this.md.digest();
        FlexiBigInt f = new FlexiBigInt(1, hash);
        if (f.compareTo(this.mR) >= 0) {
            f = f.mod(this.mR);
        }
        do {
            this.u = new FlexiBigInt(this.rLength, this.mSecureRandom);
        } while (this.u.compareTo(FlexiBigInt.ONE) < 0 || this.u.compareTo(this.mR) >= 0 || this.u.gcd(this.mR).compareTo(FlexiBigInt.ONE) != 0);
        this.V = ScalarMult.eval_SquareMultiply(ScalarMult.determineNaf(this.u, 4), this.mOddPowers);
        FlexiBigInt i = this.mG instanceof PointGF2n ? ((PointGF2n)this.V).getXAffin().toFlexiBigInt() : ((PointGFP)this.V).getXAffin().toFlexiBigInt();
        FlexiBigInt c = i.add(f).mod(this.mR);
        while (c.compareTo(FlexiBigInt.ZERO) == 0 || this.u.compareTo(FlexiBigInt.ZERO) == 0) {
            do {
                this.u = new FlexiBigInt(this.rLength, this.mSecureRandom);
            } while (this.u.compareTo(FlexiBigInt.ONE) < 0 || this.u.compareTo(this.mR) >= 0 || this.u.gcd(this.mR).compareTo(FlexiBigInt.ONE) != 0);
            this.V = ScalarMult.eval_SquareMultiply(ScalarMult.determineNaf(this.u, 4), this.mOddPowers);
            c = i.add(f).mod(this.mR);
        }
        FlexiBigInt d = this.u.subtract(this.mS.multiply(c)).mod(this.mR);
        ECNRASN1Signature ecnrSigVal = new ECNRASN1Signature(c, d);
        return ASN1Tools.derEncode((ASN1Type)ecnrSigVal);
    }

    public void update(byte b) {
        this.md.update(b);
    }

    public void update(byte[] b, int off, int len) {
        int l = len;
        if (l == -1) {
            l = 0;
        }
        this.md.update(b, off, l);
    }

    public boolean verify(byte[] sigBytes) throws SignatureException {
        ECNRASN1Signature eSigVal = new ECNRASN1Signature();
        try {
            ASN1Tools.derDecode(sigBytes, (ASN1Type)eSigVal);
        }
        catch (ASN1Exception ASN1Exc) {
            throw new SignatureException("ASN1Exception: " + ASN1Exc.getMessage());
        }
        catch (IOException IOExc) {
            throw new SignatureException("IOException: " + IOExc.getMessage());
        }
        FlexiBigInt c = eSigVal.getR();
        FlexiBigInt d = eSigVal.getS();
        if (c.compareTo(FlexiBigInt.ONE) < 0 || c.compareTo(this.mR) >= 0) {
            return false;
        }
        if (d.compareTo(FlexiBigInt.ONE) < 0 || d.compareTo(this.mR) >= 0) {
            return false;
        }
        FlexiBigInt[] dc = new FlexiBigInt[]{d, c};
        Point[] mW1 = new Point[]{this.mG, this.mW};
        Point P = ScalarMult.multiply(dc, mW1);
        if (P.isZero()) {
            return false;
        }
        FlexiBigInt i = P instanceof PointGF2n ? ((PointGF2n)P).getXAffin().toFlexiBigInt() : ((PointGFP)P).getXAffin().toFlexiBigInt();
        FlexiBigInt f = c.subtract(i).mod(this.mR);
        FlexiBigInt f1 = new FlexiBigInt(1, this.md.digest());
        f1 = f1.mod(this.mR);
        return f.compareTo(f1) == 0;
    }

    private static class ECNRASN1Signature
    extends ASN1Sequence {
        private ASN1Integer r;
        private ASN1Integer s;

        public ECNRASN1Signature() {
            super(2);
            this.r = new ASN1Integer();
            this.s = new ASN1Integer();
            ((ArrayList)((Object)this)).add(this.r);
            ((ArrayList)((Object)this)).add(this.s);
        }

        public ECNRASN1Signature(FlexiBigInt mR, FlexiBigInt mS) {
            super(2);
            this.r = new ASN1Integer(1, FlexiBigIntUtils.toMinimalByteArray(mR));
            this.s = new ASN1Integer(1, FlexiBigIntUtils.toMinimalByteArray(mS));
            ((ArrayList)((Object)this)).add(this.r);
            ((ArrayList)((Object)this)).add(this.s);
        }

        public FlexiBigInt getR() {
            return ASN1Tools.getFlexiBigInt(this.r);
        }

        public FlexiBigInt getS() {
            return ASN1Tools.getFlexiBigInt(this.s);
        }
    }
}

