/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.ec;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.Signature;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidParameterException;
import de.flexiprovider.api.exceptions.SignatureException;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.math.ellipticcurves.Point;
import de.flexiprovider.common.math.ellipticcurves.ScalarMult;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.common.util.FlexiBigIntUtils;
import de.flexiprovider.core.md.NullDigest;
import de.flexiprovider.ec.keys.ECPrivateKey;
import de.flexiprovider.ec.keys.ECPublicKey;
import de.flexiprovider.ec.parameters.CurveParams;
import java.io.IOException;
import java.util.ArrayList;

public abstract class ECDSASignature
extends Signature {
    private SecureRandom mSecureRandom;
    private MessageDigest md;
    private FlexiBigInt mS;
    private Point mW;
    private CurveParams mParams;
    private Point mG;
    private FlexiBigInt mR;
    private int rLength;
    private int w;
    private Point[] mOddPowers;
    private static final FlexiBigInt ONE = FlexiBigInt.ONE;

    protected ECDSASignature(MessageDigest md) {
        this.md = md;
    }

    public void initSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyException(privateKey + " is not an instance" + " of ECPrivateKey");
        }
        ECPrivateKey privKey = (ECPrivateKey)privateKey;
        this.mS = privKey.getS();
        this.mParams = privKey.getParams();
        this.mR = this.mParams.getR();
        this.rLength = this.mR.bitLength();
        this.mG = this.mParams.getG();
        this.w = 5;
        this.mOddPowers = ScalarMult.precomputationCMO(this.mG, this.w + 1, 0);
        this.md.reset();
        this.mSecureRandom = random != null ? random : Registry.getSecureRandom();
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyException(publicKey + " is not an instance" + " of ECPublicKey");
        }
        ECPublicKey pubKey = (ECPublicKey)publicKey;
        this.mW = pubKey.getW();
        this.mParams = pubKey.getParams();
        this.mR = this.mParams.getR();
        this.rLength = this.mR.bitLength();
        this.mG = this.mParams.getG();
        this.md.reset();
    }

    public void setParameters(AlgorithmParameterSpec params) throws InvalidParameterException {
        if (!(params instanceof CurveParams)) {
            throw new InvalidParameterException("params is not an instance of ECParameterSpec");
        }
        this.mParams = (CurveParams)params;
    }

    public void update(byte input) {
        this.md.update(input);
    }

    public void update(byte[] input, int offset, int length) {
        int l = length;
        if (l == -1) {
            l = 0;
        }
        this.md.update(input, offset, l);
    }

    public byte[] sign() {
        int[] uRec;
        Point V;
        FlexiBigInt u;
        while ((u = new FlexiBigInt(this.rLength, this.mSecureRandom)).compareTo(ONE) < 0 || u.compareTo(this.mR) >= 0 || u.gcd(this.mR).compareTo(ONE) != 0 || (V = ScalarMult.eval_SquareMultiply(uRec = ScalarMult.determineNaf(u, this.w), this.mOddPowers)).isZero()) {
        }
        FlexiBigInt invU = u.modInverse(this.mR);
        FlexiBigInt c = V.getXAffin().toFlexiBigInt().mod(this.mR);
        FlexiBigInt f = this.computeMessageRepresentative();
        FlexiBigInt tmp = f.add(this.mS.multiply(c)).remainder(this.mR);
        FlexiBigInt d = invU.multiply(tmp).mod(this.mR);
        ECDSAASN1Signature ecdsaSigVal = new ECDSAASN1Signature(c, d);
        return ASN1Tools.derEncode((ASN1Type)ecdsaSigVal);
    }

    public boolean verify(byte[] sigBytes) throws SignatureException {
        FlexiBigInt h = FlexiBigInt.valueOf(1L);
        FlexiBigInt c1 = FlexiBigInt.valueOf(1L);
        Point W = this.mW;
        ECDSAASN1Signature eSigVal = new ECDSAASN1Signature();
        try {
            ASN1Tools.derDecode(sigBytes, (ASN1Type)eSigVal);
        }
        catch (ASN1Exception ASN1Exc) {
            throw new SignatureException("ASN1Exception: " + ASN1Exc.getMessage());
        }
        catch (IOException IOExc) {
            throw new SignatureException("IOException: " + IOExc.getMessage());
        }
        FlexiBigInt c = eSigVal.getR();
        FlexiBigInt d = eSigVal.getS();
        if (c.compareTo(ONE) < 0 || c.compareTo(this.mR) > -1) {
            return false;
        }
        if (d.compareTo(ONE) < 0 || d.compareTo(this.mR) > -1) {
            return false;
        }
        FlexiBigInt f = this.computeMessageRepresentative();
        if (d.gcd(this.mR).compareTo(ONE) != 0) {
            throw new SignatureException("gcd(d, r) !=1");
        }
        h = d.modInverse(this.mR);
        FlexiBigInt h1 = f.multiply(h).remainder(this.mR);
        FlexiBigInt h2 = c.multiply(h).remainder(this.mR);
        FlexiBigInt[] H = new FlexiBigInt[]{h1, h2};
        Point[] W1 = new Point[]{this.mG, W};
        Point P = ScalarMult.multiply(H, W1);
        c1 = P.getXAffin().toFlexiBigInt().mod(this.mR);
        return c1.equals(c);
    }

    private FlexiBigInt computeMessageRepresentative() {
        byte[] hash = this.md.digest();
        FlexiBigInt f = new FlexiBigInt(1, hash);
        int hLen = this.md.getDigestLength();
        int trunc = 8 * hLen - this.rLength;
        if (trunc > 0) {
            f = f.shiftRight(trunc);
        }
        return f;
    }

    public static final class Raw
    extends ECDSASignature {
        public Raw() {
            super((MessageDigest)new NullDigest());
        }
    }

    public static final class SHA512
    extends ECDSASignature {
        public static final String OID = "1.2.840.10045.4.3.4";

        public SHA512() {
            super((MessageDigest)new de.flexiprovider.core.md.SHA512());
        }
    }

    public static final class SHA384
    extends ECDSASignature {
        public static final String OID = "1.2.840.10045.4.3.3";

        public SHA384() {
            super((MessageDigest)new de.flexiprovider.core.md.SHA384());
        }
    }

    public static final class SHA256
    extends ECDSASignature {
        public static final String OID = "1.2.840.10045.4.3.2";

        public SHA256() {
            super((MessageDigest)new de.flexiprovider.core.md.SHA256());
        }
    }

    public static final class SHA224
    extends ECDSASignature {
        public static final String OID = "1.2.840.10045.4.3.1";

        public SHA224() {
            super((MessageDigest)new de.flexiprovider.core.md.SHA224());
        }
    }

    public static final class SHA1
    extends ECDSASignature {
        public static final String OID = "1.2.840.10045.4.1";

        public SHA1() {
            super((MessageDigest)new de.flexiprovider.core.md.SHA1());
        }
    }

    private static class ECDSAASN1Signature
    extends ASN1Sequence {
        private ASN1Integer r;
        private ASN1Integer s;

        public ECDSAASN1Signature() {
            super(2);
            this.r = new ASN1Integer();
            this.s = new ASN1Integer();
            ((ArrayList)((Object)this)).add(this.r);
            ((ArrayList)((Object)this)).add(this.s);
        }

        public ECDSAASN1Signature(FlexiBigInt mR, FlexiBigInt mS) {
            super(2);
            this.r = new ASN1Integer(1, FlexiBigIntUtils.toMinimalByteArray(mR));
            this.s = new ASN1Integer(1, FlexiBigIntUtils.toMinimalByteArray(mS));
            ((ArrayList)((Object)this)).add(this.r);
            ((ArrayList)((Object)this)).add(this.s);
        }

        public FlexiBigInt getR() {
            return ASN1Tools.getFlexiBigInt(this.r);
        }

        public FlexiBigInt getS() {
            return ASN1Tools.getFlexiBigInt(this.s);
        }
    }
}

