/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.padding;

import de.flexiprovider.api.PaddingScheme;
import de.flexiprovider.api.exceptions.BadPaddingException;

public class OneAndZeroesPadding
extends PaddingScheme {
    protected int padLength(int inLen) {
        return this.blockSize - inLen % this.blockSize;
    }

    protected void pad(byte[] input, int inOff, int inLen) {
        int padLength = this.padLength(inLen);
        input[inOff + inLen] = -128;
        int i = 1;
        while (i < padLength) {
            input[inOff + inLen + i] = 0;
            ++i;
        }
    }

    protected int unpad(byte[] input, int inOff, int inLen) throws BadPaddingException {
        while (inLen >= 0 && input[inOff + inLen - 1] != -128) {
            if (input[inOff + inLen - 1] != 0) {
                return -1;
            }
            --inLen;
        }
        int padOffset = inOff + inLen - 1;
        if (padOffset == -1) {
            throw new BadPaddingException("unpadding failed");
        }
        return padOffset;
    }
}

