/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math.polynomials;

import de.flexiprovider.common.math.IntegerFunctions;
import de.flexiprovider.common.math.polynomials.BinaryConvolutionPolynomial;
import de.flexiprovider.common.math.polynomials.ConvolutionPolynomial;
import de.flexiprovider.common.math.polynomials.ProductFormConvolutionPolynomial;
import de.flexiprovider.common.math.polynomials.SparseBinaryConvolutionPolynomial;
import de.flexiprovider.common.util.BigEndianConversions;
import de.flexiprovider.common.util.IntUtils;

public class ModQConvolutionPolynomial
implements ConvolutionPolynomial {
    private int N;
    private int q;
    private int degree;
    private int[] coefficients;

    public ModQConvolutionPolynomial(int N, int q) throws IllegalArgumentException {
        if (N < 1 || q == 0 || q == 1) {
            throw new IllegalArgumentException();
        }
        this.N = N;
        this.q = q < 0 ? -q : q;
        this.degree = 0;
        this.coefficients = new int[N];
    }

    public ModQConvolutionPolynomial(int N, int q, int degree, int headCoef) throws IllegalArgumentException {
        if (N < 1 || q == 0 || q == 1 || degree < 0) {
            throw new IllegalArgumentException();
        }
        this.N = N;
        this.q = q < 0 ? -q : q;
        this.degree = degree;
        this.coefficients = new int[N];
        this.coefficients[degree] = headCoef % q;
    }

    public ModQConvolutionPolynomial(int N, int q, int[] coefficients) throws IllegalArgumentException {
        if (N < 1 || q == 0 || q == 1 || coefficients.length > N) {
            throw new IllegalArgumentException();
        }
        this.N = N;
        this.q = q < 0 ? -q : q;
        this.coefficients = new int[N];
        System.arraycopy(coefficients, 0, this.coefficients, 0, coefficients.length);
        this.reduceCoeffThis();
        this.computeDegree();
    }

    public ModQConvolutionPolynomial(SparseBinaryConvolutionPolynomial other, int q, int p) {
        this.N = other.N;
        this.q = q;
        this.degree = other.degrees[other.degrees.length - 1];
        this.coefficients = new int[this.N];
        int i = other.degrees.length - 1;
        while (i >= 0) {
            this.coefficients[other.degrees[i]] = p;
            --i;
        }
    }

    public ModQConvolutionPolynomial(ModQConvolutionPolynomial other) {
        this.N = other.N;
        this.q = other.q;
        this.degree = other.degree;
        this.coefficients = IntUtils.clone(other.coefficients);
    }

    public ModQConvolutionPolynomial add(ModQConvolutionPolynomial addend) {
        ModQConvolutionPolynomial result = new ModQConvolutionPolynomial(this);
        result.addThis(addend);
        return result;
    }

    public void addThis(ModQConvolutionPolynomial addend) {
        if (this.N != addend.N || this.q != addend.q) {
            throw new ArithmeticException("Polynomials are not defined over the same ring.");
        }
        int i = this.N - 1;
        while (i >= 0) {
            int n = i;
            this.coefficients[n] = this.coefficients[n] + addend.coefficients[i];
            if (this.coefficients[i] >= this.q) {
                int n2 = i;
                this.coefficients[n2] = this.coefficients[n2] - this.q;
            }
            --i;
        }
        this.computeDegree();
    }

    public ModQConvolutionPolynomial subtract(ModQConvolutionPolynomial minuend) {
        ModQConvolutionPolynomial result = new ModQConvolutionPolynomial(this);
        result.subtractThis(minuend);
        return result;
    }

    public void subtractThis(ModQConvolutionPolynomial minuend) {
        if (this.N != minuend.N || this.q != minuend.q) {
            throw new ArithmeticException("Polynomials are not defined over the same ring.");
        }
        int i = this.N - 1;
        while (i >= 0) {
            int n = i;
            this.coefficients[n] = this.coefficients[n] - minuend.coefficients[i];
            if (this.coefficients[i] < 0) {
                int n2 = i;
                this.coefficients[n2] = this.coefficients[n2] + this.q;
            }
            --i;
        }
        this.computeDegree();
    }

    public ModQConvolutionPolynomial multiplyInteger(int a) {
        ModQConvolutionPolynomial result = new ModQConvolutionPolynomial(this);
        result.multiplyIntegerThis(a);
        return result;
    }

    public void multiplyIntegerThis(int a) {
        if (a % this.q == 0) {
            this.coefficients = new int[this.N];
            this.degree = 0;
            return;
        }
        if (a == 2) {
            int i = this.degree;
            while (i >= 0) {
                int n = i;
                this.coefficients[n] = this.coefficients[n] << 1;
                if (this.coefficients[i] >= this.q) {
                    int n2 = i;
                    this.coefficients[n2] = this.coefficients[n2] - this.q;
                }
                --i;
            }
        } else {
            int i = this.degree;
            while (i >= 0) {
                this.coefficients[i] = this.coefficients[i] * a % this.q;
                --i;
            }
        }
        this.computeDegree();
    }

    public ModQConvolutionPolynomial multiply(ConvolutionPolynomial factor) throws ArithmeticException {
        if (factor instanceof SparseBinaryConvolutionPolynomial) {
            return this.multiplyPatterns((SparseBinaryConvolutionPolynomial)factor);
        }
        if (factor instanceof ProductFormConvolutionPolynomial) {
            return this.multiply((ProductFormConvolutionPolynomial)factor);
        }
        if (factor instanceof ModQConvolutionPolynomial) {
            return this.multiply((ModQConvolutionPolynomial)factor);
        }
        throw new ArithmeticException("Unknown polynomial type.");
    }

    public ModQConvolutionPolynomial multiply(SparseBinaryConvolutionPolynomial factor) {
        if (this.N != factor.N) {
            throw new ArithmeticException("Polynomials are not defined over the same ring.");
        }
        int[] a = this.coefficients;
        int[] b = factor.degrees;
        int df = b.length;
        int[] coeff = new int[this.N];
        int i = 0;
        while (i < df) {
            int j = b[i];
            int k = 0;
            while (k <= this.degree) {
                int n = j++;
                coeff[n] = coeff[n] + a[k];
                if (j == this.N) {
                    j = 0;
                }
                ++k;
            }
            ++i;
        }
        return new ModQConvolutionPolynomial(this.N, this.q, coeff);
    }

    public ModQConvolutionPolynomial multiply(ProductFormConvolutionPolynomial factor) {
        int k;
        int index;
        if (this.N != factor.N) {
            throw new ArithmeticException("Polynomials are not defined over the same ring.");
        }
        int[] a = this.coefficients;
        int[] b1 = factor.f1.degrees;
        int[] b2 = factor.f2.degrees;
        int[] b3 = factor.f3.degrees;
        int[] coeff = new int[this.N];
        int[] temp = new int[this.N];
        int i = b1.length - 1;
        while (i >= 0) {
            index = b1[i];
            k = 0;
            while (k <= this.degree) {
                int n = index++;
                temp[n] = temp[n] + a[k];
                if (index == this.N) {
                    index = 0;
                }
                ++k;
            }
            --i;
        }
        i = b2.length - 1;
        while (i >= 0) {
            index = b2[i];
            k = 0;
            while (k < this.N) {
                int n = index++;
                coeff[n] = coeff[n] + temp[k];
                if (index == this.N) {
                    index = 0;
                }
                ++k;
            }
            --i;
        }
        temp = new int[this.N];
        i = b3.length - 1;
        while (i >= 0) {
            index = b3[i];
            k = 0;
            while (k <= this.degree) {
                int n = index++;
                temp[n] = temp[n] + a[k];
                if (index == this.N) {
                    index = 0;
                }
                ++k;
            }
            --i;
        }
        coeff = this.add(coeff, temp);
        return new ModQConvolutionPolynomial(this.N, this.q, coeff);
    }

    public ModQConvolutionPolynomial multiply(ModQConvolutionPolynomial factor) throws ArithmeticException {
        ModQConvolutionPolynomial result = new ModQConvolutionPolynomial(this);
        result.multiplyThis(factor);
        return result;
    }

    public void multiplyThis(ModQConvolutionPolynomial factor) throws ArithmeticException {
        if (this.N != factor.N || this.q != factor.q) {
            throw new ArithmeticException("Polynomials are not defined over the same ring.");
        }
        int[] temp = new int[this.N];
        int i = 0;
        while (i <= this.degree) {
            int resIndex = i;
            int j = 0;
            while (j <= factor.degree) {
                int n = resIndex++;
                temp[n] = temp[n] + this.coefficients[i] * factor.coefficients[j];
                if (resIndex == this.N) {
                    resIndex = 0;
                }
                ++j;
            }
            ++i;
        }
        this.coefficients = temp;
        this.reduceCoeffThis();
        this.computeDegree();
    }

    public ModQConvolutionPolynomial multiplySlidingWindow(BinaryConvolutionPolynomial factor) throws ArithmeticException {
        if (this.N != factor.N) {
            throw new ArithmeticException("Polynomials are not defined over the same ring.");
        }
        int w = 5;
        int[][] T = new int[w - 1][this.N];
        int i = w - 1;
        while (i >= 1) {
            int index = i;
            int j = 0;
            while (j < this.N) {
                T[i - 1][j] = this.coefficients[j] + this.coefficients[index++];
                if (index == this.N) {
                    index = 0;
                }
                ++j;
            }
            --i;
        }
        int[] coeff = new int[this.N];
        int[][] b = factor.getPatternLocations(w);
        int j = 0;
        while (j < b[0][0]) {
            int index = b[0][j + 1];
            int k = 0;
            while (k < this.N) {
                int n = index++;
                coeff[n] = coeff[n] + this.coefficients[k];
                if (index == this.N) {
                    index = 0;
                }
                ++k;
            }
            ++j;
        }
        int i2 = w - 1;
        while (i2 >= 1) {
            int di = b[i2][0];
            int j2 = di - 1;
            while (j2 >= 0) {
                int index = b[i2][j2 + 1];
                int k = 0;
                while (k < this.N) {
                    int n = index++;
                    coeff[n] = coeff[n] + T[i2 - 1][k];
                    if (index == this.N) {
                        index = 0;
                    }
                    ++k;
                }
                --j2;
            }
            --i2;
        }
        return new ModQConvolutionPolynomial(this.N, this.q, coeff);
    }

    public ModQConvolutionPolynomial multiplySlidingWindow(SparseBinaryConvolutionPolynomial factor) throws ArithmeticException {
        if (this.N != factor.N) {
            throw new ArithmeticException("Polynomials are not defined over the same ring.");
        }
        int w = 5;
        int[][] T = new int[w - 1][this.N];
        int i = w - 1;
        while (i >= 1) {
            int index = i;
            int j = 0;
            while (j < this.N) {
                T[i - 1][j] = this.coefficients[j] + this.coefficients[index++];
                if (index == this.N) {
                    index = 0;
                }
                ++j;
            }
            --i;
        }
        int[] coeff = new int[this.N];
        int[][] b = factor.getPatternLocations(w);
        int j = 0;
        while (j < b[0][0]) {
            int index = b[0][j + 1];
            int k = 0;
            while (k < this.N) {
                int n = index++;
                coeff[n] = coeff[n] + this.coefficients[k];
                if (index == this.N) {
                    index = 0;
                }
                ++k;
            }
            ++j;
        }
        int i2 = w - 1;
        while (i2 >= 1) {
            int di = b[i2][0];
            int j2 = di - 1;
            while (j2 >= 0) {
                int index = b[i2][j2 + 1];
                int k = 0;
                while (k < this.N) {
                    int n = index++;
                    coeff[n] = coeff[n] + T[i2 - 1][k];
                    if (index == this.N) {
                        index = 0;
                    }
                    ++k;
                }
                --j2;
            }
            --i2;
        }
        return new ModQConvolutionPolynomial(this.N, this.q, coeff);
    }

    public ModQConvolutionPolynomial multiplyPatterns(SparseBinaryConvolutionPolynomial factor) throws ArithmeticException {
        int index;
        if (this.N != factor.N) {
            throw new ArithmeticException("Polynomials are not defined over the same ring.");
        }
        int[] coeff = new int[this.N];
        int[][] L = factor.getPatterns();
        int[] P = new int[this.N];
        int i = L.length - 1;
        while (i >= 1) {
            if (L[i] != null) {
                index = i;
                int j = 0;
                while (j < this.N) {
                    P[j] = this.coefficients[j] + this.coefficients[index++];
                    if (index == this.N) {
                        index = 0;
                    }
                    ++j;
                }
                int j2 = L[i][0] - 1;
                while (j2 >= 0) {
                    index = L[i][j2 + 1];
                    int k = 0;
                    while (k < this.N) {
                        int n = index++;
                        coeff[n] = coeff[n] + P[k];
                        if (index == this.N) {
                            index = 0;
                        }
                        ++k;
                    }
                    --j2;
                }
            }
            --i;
        }
        if (L[0] != null) {
            index = L[0][0];
            int k = 0;
            while (k < this.N) {
                int n = index++;
                coeff[n] = coeff[n] + this.coefficients[k];
                if (index == this.N) {
                    index = 0;
                }
                ++k;
            }
        }
        return new ModQConvolutionPolynomial(this.N, this.q, coeff);
    }

    public ModQConvolutionPolynomial multiplyPatterns(ProductFormConvolutionPolynomial factor) throws ArithmeticException {
        int index;
        int k;
        int j;
        int index2;
        if (this.N != factor.N) {
            throw new ArithmeticException("Polynomials are not defined over the same ring.");
        }
        int[] coeff = new int[this.N];
        int[] af1 = new int[this.N];
        int[] af1f2 = new int[this.N];
        int[] P = new int[this.N];
        int[][] L1 = factor.f1.getPatterns();
        int[][] L2 = factor.f2.getPatterns();
        int[][] L3 = factor.f3.getPatterns();
        int df = L1.length;
        int i = df - 1;
        while (i >= 1) {
            if (L1[i] != null || L3[i] != null) {
                int k2;
                index2 = i;
                int j2 = 0;
                while (j2 < this.N) {
                    P[j2] = this.coefficients[j2] + this.coefficients[index2++];
                    if (index2 == this.N) {
                        index2 = 0;
                    }
                    ++j2;
                }
                if (L1[i] != null) {
                    j = L1[i][0] - 1;
                    while (j >= 0) {
                        index2 = L1[i][j + 1];
                        k2 = 0;
                        while (k2 < this.N) {
                            int n = index2++;
                            af1[n] = af1[n] + P[k2];
                            if (index2 == this.N) {
                                index2 = 0;
                            }
                            ++k2;
                        }
                        --j;
                    }
                }
                if (L3[i] != null) {
                    j = L3[i][0] - 1;
                    while (j >= 0) {
                        index2 = L3[i][j + 1];
                        k2 = 0;
                        while (k2 < this.N) {
                            int n = index2++;
                            coeff[n] = coeff[n] + P[k2];
                            if (index2 == this.N) {
                                index2 = 0;
                            }
                            ++k2;
                        }
                        --j;
                    }
                }
            }
            --i;
        }
        if (L1[0] != null) {
            index2 = L1[0][0];
            k = 0;
            while (k < this.N) {
                int n = index2++;
                af1[n] = af1[n] + this.coefficients[k];
                if (index2 == this.N) {
                    index2 = 0;
                }
                ++k;
            }
        }
        if (L3[0] != null) {
            index2 = L3[0][0];
            k = 0;
            while (k < this.N) {
                int n = index2++;
                coeff[n] = coeff[n] + this.coefficients[k];
                if (index2 == this.N) {
                    index2 = 0;
                }
                ++k;
            }
        }
        int i2 = df - 1;
        while (i2 >= 1) {
            if (L2[i2] != null) {
                index = i2;
                j = 0;
                while (j < this.N) {
                    P[j] = af1[j] + af1[index++];
                    if (index == this.N) {
                        index = 0;
                    }
                    ++j;
                }
                int j3 = L2[i2][0] - 1;
                while (j3 >= 0) {
                    index = L2[i2][j3 + 1];
                    int k3 = 0;
                    while (k3 < this.N) {
                        int n = index++;
                        af1f2[n] = af1f2[n] + P[k3];
                        if (index == this.N) {
                            index = 0;
                        }
                        ++k3;
                    }
                    --j3;
                }
            }
            --i2;
        }
        if (L2[0] != null) {
            index = L2[0][0];
            int k4 = 0;
            while (k4 < this.N) {
                int n = index++;
                af1f2[n] = af1f2[n] + af1[k4];
                if (index == this.N) {
                    index = 0;
                }
                ++k4;
            }
        }
        coeff = this.add(af1f2, coeff);
        return new ModQConvolutionPolynomial(this.N, this.q, coeff);
    }

    public ModQConvolutionPolynomial invert() {
        ModQConvolutionPolynomial unit = new ModQConvolutionPolynomial(this.N, this.q, 0, 1);
        ModQConvolutionPolynomial[] g = this.extGCD();
        if (g[0].equals(unit)) {
            return g[1];
        }
        return null;
    }

    public ModQConvolutionPolynomial reduceCoeffModP(int p) {
        ModQConvolutionPolynomial result = new ModQConvolutionPolynomial(this);
        result.reduceCoeffModPThis(p);
        return result;
    }

    public void reduceCoeffModPThis(int p) {
        if (p == 2) {
            int i = this.degree;
            while (i >= 0) {
                int n = i--;
                this.coefficients[n] = this.coefficients[n] & 1;
            }
        } else {
            int i = this.degree;
            while (i >= 0) {
                int n = i--;
                this.coefficients[n] = this.coefficients[n] % p;
            }
        }
        this.computeDegree();
    }

    public void shiftCoeffThis(int A) {
        if (A != 0) {
            int i = this.degree;
            while (i >= 0) {
                int n = i--;
                this.coefficients[n] = this.coefficients[n] + A;
            }
        }
    }

    public int evaluateAtOne() {
        int result = this.coefficients[this.N - 1];
        int i = this.N - 2;
        while (i >= 0) {
            if ((result += this.coefficients[i]) >= this.q) {
                result -= this.q;
            }
            --i;
        }
        return result;
    }

    public byte[] RE2OSP() {
        int oLen = IntegerFunctions.ceilLog256(this.q - 1);
        byte[] result = new byte[oLen * this.N];
        int i = this.N - 1;
        while (i >= 0) {
            byte[] os = BigEndianConversions.I2OSP(this.coefficients[i], oLen);
            System.arraycopy(os, 0, result, i * oLen, oLen);
            --i;
        }
        return result;
    }

    public static ModQConvolutionPolynomial OS2REP(int N, int q, byte[] encoded) throws IllegalArgumentException {
        int oLen = IntegerFunctions.ceilLog256(q - 1);
        if (encoded.length != oLen * N) {
            throw new IllegalArgumentException("Encoded polynomial has wrong length.");
        }
        ModQConvolutionPolynomial result = new ModQConvolutionPolynomial(N, q);
        int i = 0;
        while (i < N) {
            result.coefficients[i] = BigEndianConversions.OS2IP(encoded, i * oLen, oLen);
            ++i;
        }
        result.computeDegree();
        return result;
    }

    public byte[] BRE2OSP() throws ArithmeticException {
        int i = this.N - 1;
        while (i >= 0) {
            if (this.coefficients[i] != 0 && this.coefficients[i] != 1) {
                throw new ArithmeticException("Not a binary polynomial.");
            }
            --i;
        }
        byte[] result = new byte[this.N + 7 >> 3];
        int i2 = this.N - 1;
        while (i2 >= 0) {
            int n = i2 >> 3;
            result[n] = (byte)(result[n] | this.coefficients[i2] << (i2 & 7));
            --i2;
        }
        return result;
    }

    public static ModQConvolutionPolynomial OS2BREP(int N, int q, byte[] encoded) throws IllegalArgumentException {
        if (encoded.length > N + 7 >>> 3) {
            throw new IllegalArgumentException("Encoded octet string has wrong length.");
        }
        ModQConvolutionPolynomial result = new ModQConvolutionPolynomial(N, q);
        int i = N - 1;
        while (i >= 0) {
            result.coefficients[i] = encoded[i / 8] >>> (i & 7) & 1;
            --i;
        }
        result.computeDegree();
        return result;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ModQConvolutionPolynomial)) {
            return false;
        }
        ModQConvolutionPolynomial otherPol = (ModQConvolutionPolynomial)other;
        return this.degree == otherPol.degree && this.q == otherPol.q && IntUtils.equals(this.coefficients, otherPol.coefficients);
    }

    public int hashCode() {
        return this.degree + this.q + this.coefficients.hashCode();
    }

    public String toString() {
        String result = "ModQPolynomial (degree " + this.degree + ", modulus " + this.q + "):\n";
        if (this.degree == 0) {
            result = result + Integer.toString(this.coefficients[0]);
            return result;
        }
        result = result + this.coefficients[this.degree] + "*x^" + this.degree;
        int i = this.degree - 1;
        while (i > 0) {
            int coefficient = this.coefficients[i];
            if (coefficient != 0) {
                result = result + " + " + coefficient + "*x^" + i;
            }
            --i;
        }
        if (this.coefficients[0] != 0) {
            result = result + " + " + this.coefficients[0];
        }
        return result;
    }

    private void reduceCoeffThis() {
        int i = this.N - 1;
        while (i >= 0) {
            int n = i;
            this.coefficients[n] = this.coefficients[n] % this.q;
            if (this.coefficients[i] < 0) {
                int n2 = i;
                this.coefficients[n2] = this.coefficients[n2] + this.q;
            }
            --i;
        }
    }

    private void reduceCoeffThis(int[] p) {
        int i = p.length - 1;
        while (i >= 0) {
            int n = i;
            p[n] = p[n] % this.q;
            if (p[i] < 0) {
                int n2 = i;
                p[n2] = p[n2] + this.q;
            }
            --i;
        }
    }

    private void computeDegree() {
        this.degree = this.coefficients.length - 1;
        while (this.degree > 0 && this.coefficients[this.degree] == 0) {
            --this.degree;
        }
    }

    private int computeDegree(int[] p) {
        int degree = p.length - 1;
        while (degree > 0 && p[degree] == 0) {
            --degree;
        }
        return degree;
    }

    private int[] add(int[] a, int[] b) {
        int[] addend;
        int[] result = new int[this.N];
        if (a.length < b.length) {
            System.arraycopy(b, 0, result, 0, b.length);
            addend = a;
        } else {
            System.arraycopy(a, 0, result, 0, a.length);
            addend = b;
        }
        int i = addend.length - 1;
        while (i >= 0) {
            int n = i;
            result[n] = result[n] + addend[i];
            --i;
        }
        return result;
    }

    private int[] multiply(int[] a, int[] b) {
        int[] result = new int[this.N];
        int i = a.length - 1;
        while (i >= 0) {
            int index = i;
            int j = 0;
            while (j < b.length) {
                int n = index++;
                result[n] = result[n] + a[i] * b[j];
                if (index == this.N) {
                    index = 0;
                }
                ++j;
            }
            --i;
        }
        return result;
    }

    private ModQConvolutionPolynomial[] extGCD() {
        int[] u = new int[this.N];
        u[0] = 1;
        int[] d = new int[this.N + 1];
        d[0] = -1;
        d[this.N] = 1;
        int dDegree = this.N;
        int[] v1 = new int[this.N];
        int[] v3 = IntUtils.clone(this.coefficients);
        int v3Degree = this.degree;
        int[] duv = IntegerFunctions.extGCD(v3[v3Degree], this.q);
        boolean minus = true;
        while (duv[0] != this.q) {
            int[] r = IntUtils.clone(d);
            int k = dDegree - v3Degree;
            int[] v = new int[k + 1];
            int i = k;
            int c = dDegree;
            while (i >= 0) {
                if (r[c] == 0) {
                    v[i] = 0;
                } else {
                    v[i] = duv[1] * r[c] % this.q;
                    r[c] = 0;
                    int cc = c;
                    int j = v3Degree - 1;
                    while (j >= 0) {
                        int n = --cc;
                        r[n] = r[n] - v[i] * v3[j];
                        int n2 = cc;
                        r[n2] = r[n2] % this.q;
                        --j;
                    }
                }
                --i;
                --c;
            }
            d = IntUtils.clone(v3);
            dDegree = this.computeDegree(d);
            if (r.length > this.N) {
                v3 = new int[this.N];
                System.arraycopy(r, 0, v3, 0, this.N);
            } else {
                v3 = IntUtils.clone(r);
            }
            this.reduceCoeffThis(v3);
            v3Degree = this.computeDegree(v3);
            duv = IntegerFunctions.extGCD(v3[v3Degree], this.q);
            int[] uClone = IntUtils.clone(u);
            u = this.add(v1, this.multiply(v, u));
            this.reduceCoeffThis(u);
            v1 = uClone;
            boolean bl = minus = !minus;
        }
        duv = IntegerFunctions.extGCD(d[dDegree], this.q);
        d[dDegree] = duv[0];
        int i = dDegree - 1;
        while (i >= 0) {
            int n = i--;
            d[n] = d[n] * duv[1];
        }
        if (minus) {
            duv[1] = this.q - duv[1];
        }
        int i2 = this.N - 1;
        while (i2 >= 0) {
            int n = i2--;
            v1[n] = v1[n] * duv[1];
        }
        return new ModQConvolutionPolynomial[]{new ModQConvolutionPolynomial(this.N, this.q, d), new ModQConvolutionPolynomial(this.N, this.q, v1)};
    }
}

