/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.api;

import de.flexiprovider.common.math.IntegerFunctions;
import de.flexiprovider.common.util.BigEndianConversions;
import java.security.SecureRandomSpi;

public abstract class SecureRandom
extends SecureRandomSpi {
    protected final byte[] engineGenerateSeed(int numBytes) {
        return this.generateSeed(numBytes);
    }

    protected final void engineNextBytes(byte[] bytes) {
        this.nextBytes(bytes);
    }

    protected final void engineSetSeed(byte[] seed) {
        this.setSeed(seed);
    }

    public abstract byte[] generateSeed(int var1);

    public abstract void nextBytes(byte[] var1);

    public abstract void setSeed(byte[] var1);

    public final int nextInt() {
        byte[] intBytes = new byte[4];
        this.nextBytes(intBytes);
        return BigEndianConversions.OS2IP(intBytes);
    }

    public final int nextInt(int upperBound) {
        byte[] intBytes;
        int result;
        int octL = IntegerFunctions.ceilLog256(upperBound);
        do {
            intBytes = new byte[octL];
            this.nextBytes(intBytes);
        } while ((result = BigEndianConversions.OS2IP(intBytes, 0, octL)) < 0 || result >= upperBound);
        return result;
    }
}

