<?

class Transactions extends MY_Model
{
	
    function __construct()
    {
        parent::__construct();
    }
	
	function get ($where = null, $offset = null, $singleRow = false, $countOnly = false) {
		if ($where)
			$this->db->where($where);
		$this->db->from('transaction t')
			->join('user u','t.user_id = u.id')
			->join('landevice ld','t.landevice_id = ld.landevice_id')
			-> order_by("t.timestamp", "desc"); 
		if ($countOnly) {
			return $this -> db -> count_all_results();
		} else {
			$this->db->select('t.*, u.username, ld.mac');
			if ($singleRow) {
				return $this -> db -> get() -> row_array();
			} else {
				if ($offset !== null)
					$this -> db -> limit(PER_PAGE, $offset);
				return $this -> db -> get() -> result_array();
			}
		}
	}
	
	function getByUser ($user_id) {
		$where = array('t.user_id' => $user_id);
		return $this->get($where);
	}
	
	function getSearchConditions () {
		$where = array();
		
		if ($this -> session -> userdata('search_transaction_createdFrom')) {
			$where['t.timestamp > '] = $this -> session -> userdata('search_transaction_createdFrom');
		}
		if ($this -> session -> userdata('search_transaction_createdTo')) {
			$where['t.timestamp < '] = $this -> session -> userdata('search_transaction_createdTo');
		}
		if ($this -> session -> userdata('search_transaction_username')) {
			$this -> db -> like('u.username', $this -> session -> userdata('search_transaction_username'), 'after');
		}
		if ($this -> session -> userdata('search_transaction_status')) {
			$where['t.status'] = $this -> session -> userdata('search_transaction_status');
		}
		if ($this -> session -> userdata('search_transaction_mac')) {
			$this -> db -> like('ld.mac', $this -> session -> userdata('search_transaction_mac'), 'after');
		}
		return $where;
	}
}
