<?

class Products extends CI_Model
{
	
    function __construct()
    {
        parent::__construct();
    }
	

	function getProductTypes() {
		return $this->db->get('product')->result_array();
	}
	
	function getProductsDropdown($withBlank = true) {
		$result = $this->getProductTypes();
		$products = array();
		if ($withBlank)
			$products[''] = '';
		foreach ($result as $product) {
			$products[$product['product_id']] = $product['name'];
		}
		return $products;
	}
	
	function get ($where = null) {
		$this->db->from('userproductlog up')
			->join('product p','up.product_id = p.product_id')
			->order_by("up.date_added", "desc"); 
		if ($where)
			$this->db->where($where);
		return $this->db->get()->result_array();
	}
	
	function getByUser ($user_id) {
		$where = array('up.user_id' => $user_id);
		return $this->get($where);
	}
}
