<?

class Gatewayclientsessions extends Devices_Model
{
	
    function __construct()
    {
        parent::__construct();
    }
	
	function get ($where = null, $offset = null, $singleRow = false, $countOnly = false) {
		$this->db->select('gcs.*, gc.user_id, u.username')
			->from('gatewayclientsession gcs')
			->join('gatewayclient gc','gcs.mac = gc.mac and gc.deleted = 0','left')
			->join('user u','gc.user_id = u.id','left')
			->order_by("gcs.connected_date", "desc"); 
		if ($where)
			$this->db->where($where);
		if ($countOnly) {
			return $this -> db -> count_all_results();
		} else if ($singleRow) {
			$result = $this -> db -> get() -> row_array();
			return $result;
		} else {
			if ($offset !== null)
				$this -> db -> limit(PER_PAGE, $offset);
			return $this -> db -> get() -> result_array();
		}
	}
	
	function getSearchConditions () {
		$where = array();
		if ($this -> session -> userdata('search_server_mac')) {
			$this -> db -> like('gcs.mac', $this -> session -> userdata('search_server_mac'), 'after');
		}
		if ($this -> session -> userdata('search_server_public_ip')) {
			$this -> db -> like('gcs.public_ip', $this -> session -> userdata('search_server_public_ip'), 'after');
		}
		return $where;
	}
	
	function getById ($session_id) {
		$where = array('gcs.gateway_client_session_id' => $session_id);
		return $this->get($where, null, true);
	}
	function getURL($session,$data) {
		$data['mac'] = $session['mac'];
		return parent::getURL($data);
	}
}
