<?

class MY_Model extends CI_Model
{
		
	protected $errorMessages = array(
		'FAILED_INVALIDMACADDRESS' => 'Invalid mac address',
		'FAILED_GCDISCONNECTED' => 'Gateway client disconnected',
		'STATUS_FAILED_DEVICENOTCONNECTED' => 'Device disconnected',
		'FAILED_MALFORMEDURL' => 'Malformed url', 
		'FAILED_NOACCESS' => 'No access', 
		'FAILED_NOANSWER' => 'No answer', 
		'FAILED_WRONGOLDPASSWORD' => 'Wrong old password', 
		'FAILED_PASSWORDINVALID' => 'Password invalid', 
		'FAILED_NOTFOUNDUSER' => 'User not found',
		'FAILED_NOTACTIVATED' => 'User not activated',
		'ERROR' => 'Unknown error'
	);
		
		
	protected $name;
	
    function __construct()
    {
        parent::__construct();
    }
	
	function getSearchConditions() {
		return array();
	}
	
	function count($where = array(), $specialWhere = null) {
		if ($specialWhere)
			foreach ($specialWhere as $field => $value)
				$this->db->where($field, $value, false);
		$where = array_merge($where, $this->getSearchConditions());
		if (!$where)
			$where = null;
		return $this -> get($where, null, false, true);
	}
	
	function countAll() {
		return $this -> get(null, null, false, true);
	}
	
	function getAll($offset = null, $countOnly = false) {
		$where = $this->getSearchConditions();
		return $this->get($where,$offset,false,$countOnly);
	}
	
	function checkResult ($ok, $msg) {
		if ($msg) {
			$type = $ok ? 'message' : 'error';
			$this -> session -> set_flashdata($type, $msg);
		}
		return $ok;
		
	}
	
	function clearSession ($saveFlashdata = true) {
		$error = $this->session->userdata('flash:new:error');
		$message = $this->session->userdata('flash:new:message');
		$this -> session -> sess_destroy();
		$this -> session -> sess_create();
		if ($saveFlashdata) {
			$this->session->set_flashdata('error',$error);
			$this->session->set_flashdata('message',$message);
		}
		delete_cookie('JSESSIONID');
	}
	
	function getDomain() {
		$url = $this->config->item('base_url');
		$parse = parse_url($url);
		return $parse['host'];
	}
	
	function getPath() {
		$url = $this->config->item('base_url');
		$parse = parse_url($url);
		$path = $parse['path'];
		if (strlen($path) > 1 && $path[0] == '/')
			$path = substr($path, 1);
		return $path;
	}
}
require(APPPATH.'core/Devices_Model.php');
