<?php
abstract class MY_Controller extends CI_Controller
{
	protected $unauthorized;
	protected $requireRestAuthorization;
	protected $search_criteria;
	protected $model;
	protected $controller;
	protected $fields;
	protected $index = null;
	
   function __construct()
   {
      parent::__construct();
	  if (isset($this->model))
	  		$this->load->model($this->model);
	  if (!$this->_isAuthorized()) {
	  		$this->users->clearSession();
			redirect('user/login');
	  }
   }
   
   function _isAuthorized () {
		$authorized = (isset($this->unauthorized) && in_array($this->router->method,$this->unauthorized) 
			|| $this->users->verify());
		if ($authorized) {
			if (isset($this->requireRestAuthorization) && in_array($this->router->method,$this->requireRestAuthorization))
				return $this->rest->ensureLogedIn();
			else {
				return true;
			}
		} else {
			return false;
		}
		
   }
   
   function _prepareAndShow ($object_id, $function = null, $validation = null, $data = null, $deleted = null) {
    	$model = $this->model;
		$controller = $this->controller;
		if ($object = $this->$model->check($object_id, $deleted)) {
			if (!$function || ($validation && !$this->form_validation->run($validation))) {
				$data['object'] = $object;
				$data['content'] = $this->load->view("$controller/show", $data, true);
				$this->load->view('index', $data);
			} else {
				$this->$model->$function($object,$data);
				redirect("$controller/show/".$object_id);
			}
			
		} else {
			if ($this->index)
				redirect($this->index);
			else
				redirect("$controller/index");
		}
	}
   
   function _ajax ($object_id, $function, $validation = null, $data = null) {
    	$model = $this->model;
		$controller = $this->controller;
		$status = 0;
		if ($object = $this->$model->check($object_id)) {
			if ($validation && !$this->form_validation->run($validation)) {
				$response = validation_errors();
			} else {
				$response = $this->$model->$function($object,$data);
				if ($response !== null) {
					$status = 1;
					preg_match_all('/<html.*?>(.*?)<\/html>/is', $response, $match);
					if ($match[1])
						$response = $match[1];
					$response = json_encode($response);
				} else {
					$response = $this->session->userdata('flash:new:error');
					$this->session->unset_userdata('flash:new:error');
				}
			}	
		} else {
			$response = 'Invalid id';
		}
		if (!$status)
			$response = '"'.$response.'"';
		$data['json'] = '{"status":'.$status.', "response":'.$response.'}';
        $this->load->view('templates/json', $data);
	}
	
	function _show($object_id = 0, $deleted = null) {
		$this->_prepareAndShow($object_id, $deleted);
	}
	
	function _edit($object_id = 0) {
		$data = $this->_getDataFromPost();
		$this->_prepareAndShow($object_id, 'edit', null, $data);
	}
   
   function _clearSearch() {
		foreach ($this->search_criteria as $field)
			$this->session->unset_userdata('search_'.$this->controller."_$field");
	}
   
   function _getDataFromPost() {
   		$data = array();
		foreach ($this->fields as $field) {
			$data[$field] = $this->input->post($field);
		}
		return $data;
   }
   
   function _index($offset = 0, $countAll = false) {
   		$model = $this->model;
		$controller = $this->controller;
		if(!is_numeric($offset)) {
			$this->_clearSearch();
			$offset = 0;
		}
		$num = $this->$model->count();
		
		$config['base_url'] = $url = $this->config->item('base_url')."$controller/index";
		$config['total_rows'] = $num;
		$this->pagination->initialize($config);
		if ($countAll) {
			if(!is_numeric($offset))
				$data['countAll'] = $num;
			else
				$data['countAll'] = $this->$model->countAll();
		}
		$data['count'] = $num;
		$data['objects'] = $this->$model->getAll($offset);
		$data['content'] = $this->load->view("$controller/index", $data, true);
		$this->load->view('index', $data);
	}
	
	function _search($offset = 0, $countAll = false) {
		if($this->input->post('submit')) {
			$this->_clearSearch();
			foreach ($this->search_criteria as $field)
				if($this->input->post('search_'.$this->controller."_$field"))
					$this->session->set_userdata('search_'.$this->controller."_$field", $this->input->post('search_'.$this->controller."_$field"));
		}
		$this->_index($offset,$countAll);
	}
}
