/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.i18n;

import java.util.List;

import com.google.gwt.i18n.client.Messages;

import eu.maydu.gwt.validation.client.ValidationResult.ValidationError;


/**
 * Standard messages used by the standard validators and transformers.
 * 
 * @author Anatol Mayen
 *
 */
public interface StandardValidationMessages {
	
	public String notNull();
	public String isNull();
	public String equal();
	public String notEqual();
	public String notEmpty();
	
	public String min(int minValue, int actualValue);
	public String min(long minValue, long actualValue);
	public String min(float minValue, float actualValue);
	public String min(double minValue, double actualValue);
	public String max(int maxValue, int actualValue);
	public String max(long maxValue, long actualValue);
	public String max(float maxValue, float actualValue);
	public String max(double maxValue, double actualValue);
	public String notInRange(int min, int max, int value);
	public String notInRange(long min, long max, long value);
	public String notInRange(float min, float max, float value);
	public String notInRange(double min, double max, double value);
	public String notAnInteger();
	public String notALong();
	public String notAFloat();
	public String notADouble();
	public String length(int minLength, int maxLength, int actualLength);
	public String stringsNotEqual();
	public String mustSelectValue();
	public String validator_assertFalse();
	public String validator_assertTrue();
	public String validator_future();
	public String validator_length();
	public String validator_max();
	public String validator_min();
	public String validator_notNull();
	public String validator_past();
	public String validator_pattern();
	public String validator_range();
	public String validator_size();
	public String validator_email();
	public String validator_notEmpty();
	public String validator_digits();
	public String validator_creditCard();
	public String validator_ean();
	public String noDateGiven();
	public String unparsableDate();
	public String notARegEx();
	public String regexNotFulfilled();
	public String notAValidCharacter(char c);
	public String notAValidEmail(String givenEmailInput);
	public String notAValidTimeWithoutSeconds(String parameter);
	public String notAValidTimeWithSecondsOptionally(String parameter);
	public String notAValidTimeWithSecondsRequired(String parameter);

}