/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.groupValidators;

import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextBoxBase;

import eu.maydu.gwt.validation.client.GroupValidator;
import eu.maydu.gwt.validation.client.ValidationAction;
import eu.maydu.gwt.validation.client.ValidationResult;
import eu.maydu.gwt.validation.client.transformers.TrimTransformer;
import eu.maydu.gwt.validation.client.validators.numeric.IntegerValidator;

/**
 * 
 * @author Anatol Mayen
 *
 */
public class TrimmedIntegerValidator extends GroupValidator<TrimmedIntegerValidator>{

	private TextBoxBase text;
	private SuggestBox suggest;
	private boolean noMinMax = false;
	
	
	public TrimmedIntegerValidator(TextBoxBase text, int min, int max, boolean preventsPropagation) {
		super(preventsPropagation);
		if(text == null)
			throw new IllegalArgumentException("text must not be null");
		if(min > max)
			throw new IllegalArgumentException("min must be <= max");
		this.text = text;
		setup(min, max);
	}
	
	public TrimmedIntegerValidator(TextBoxBase text, int min, int max) {
		this(text, min, max, false);
	}
	
	public TrimmedIntegerValidator(TextBoxBase text, boolean preventsPropagation) {
		this(text, 0, Integer.MAX_VALUE, preventsPropagation);
	}
	
	public TrimmedIntegerValidator(TextBoxBase text) {
		this(text, 0, Integer.MAX_VALUE, false);
	}
	
	public TrimmedIntegerValidator(SuggestBox suggest, int min, int max, boolean preventsPropagation) {
		super(preventsPropagation);
		if(suggest == null)
			throw new IllegalArgumentException("suggest must not be null");
		if(min > max)
			throw new IllegalArgumentException("min must be <= max");
		this.suggest = suggest;
		setup(min, max);
	}
	
	public TrimmedIntegerValidator(SuggestBox suggest, int min, int max) {
		this(suggest, min, max, false);
	}
	
	public TrimmedIntegerValidator(SuggestBox suggest, boolean preventsPropagation) {
		this(suggest, 0, Integer.MAX_VALUE, preventsPropagation);
	}
	
	public TrimmedIntegerValidator(SuggestBox suggest) {
		this(suggest, 0, Integer.MAX_VALUE, false);
	}
	
	private void setup(int min, int max) {
		if(this.text != null) {
			addValidators(
					new TrimTransformer(this.text),
					this.noMinMax?
							new IntegerValidator(this.text):
							new IntegerValidator(this.text, min, max)
					);
		}else {
			addValidators(
					new TrimTransformer(this.suggest),
					this.noMinMax?
							new IntegerValidator(this.suggest):
							new IntegerValidator(this.suggest, min, max)
					);
		}
	}
	
	
	@Override
	@SuppressWarnings("unchecked")
	public void invokeActions(ValidationResult result) {
		if(text != null) {
			for(ValidationAction action : getFailureActions()) {
				action.invoke(result, text);
			}
		}else {
			for(ValidationAction action : getFailureActions()) {
				action.invoke(result, suggest);
			}
		}
	}

}
