/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client;

import java.util.LinkedList;
import java.util.List;

/**
 * 
 * Holds a list with all the errors that occured during validation of an action.
 * 
 * @author Anatol Mayen
 *
 */
public class ValidationResult {

	public class ValidationError {
		public ValidationError() {
			
		}
		public ValidationError(String propertyName, String error) {
			this.propertyName = propertyName;
			this.error = error;
		}
		public String propertyName;
		public String error;
	}
	private List<ValidationError> errors;
	
	public ValidationResult() {
		errors = new LinkedList<ValidationError>();
	}
	
	public ValidationResult(List<ValidationError> errors) {
		this.errors = errors;
	}
	
	public ValidationResult(String error) {
		this.errors = new LinkedList<ValidationError>();
		ValidationError verror = new ValidationError(null,error);
		this.errors.add(verror);
	}
	
	
	public List<ValidationError> getErrors() {
		return errors;
	}
	
	/**
	 * 
	 * @return <code>true</code> if one ore more validations failed, otherwise <code>false</code>
	 */
	public boolean validationFailed() {
		return errors==null?false:errors.size()>0;
	}

	public void addErrors(ValidationResult result) {
		
		for(ValidationError error: result.getErrors()) {
			errors.add(error);
		}
	}
	
}
