/**
 * @author 2012 Vestiacom. All rights reserved.
 * 
 */
(function(window,undefined){

    var History = window.History;
    if ( !History.enabled ) {
        return false;
    }

    History.Adapter.bind(window,'statechange',function(){
    	if (ignoreStateEvent) {
    		ignoreStateEvent = false;
    		return;
    	}
        var State = History.getState();
        if (State.data != null && State.data['p']) {	//login,register,home
        	Page.goToCurrentState();
        }
    });
})(window);

var currentPath = new Array();
var contentCollection = '';
var relayAddress = "";
var upnpAddress = "";
var currentDeviceAddress = "";
var readAction = "?action=read";
var sessionParam = "";
var deviceParams = "";
var gcId = 0;
var ldId = 0;
//var relay = "192.168.21.126:4080"
var currentDeviceName = '';
var currentUsername = '';
var imageTypes = new Array('jpg', 'jpeg', 'png', 'gif', 'bmp');
var videoTypes = new Array('mp4', 'mpeg4', '.m4v', '.f4v', '.mov', '.webm',  '.flv', '.ogv', '.aac', '.m4a', '.f4a',  '.ogg', '.oga', '.mp3');
var currentImages = new Array();
var activeSortIndex = 0;
var activeSortDescending = true;
var isHttps = false;
var ignoreStateEvent = false;
var deviceCheckInBackground = false;

function checkUpnp() {
	$.ajax({
		type: "GET",
		dataType: "jsonp",
		url: "https://" + upnpAddress + '/' + '?action=read' + sessionParam + deviceParams,
		cache: false,
		success: function(data) {
			if (!data || data['hc'] != 200) {			
				return;
			}
			isHttps = false;
			//currentDeviceAddress = upnpAddress;
		}});
}

/************************************
 *
 * adapter.restful for RemoteNAS
 *
 *
 */
$$.adapter.restfulRemoteNAS = function(_params) {
	var dataPart = "";
	if (this.model != null && this.model.size() > 0) {
		dataPart = {data: JSON.stringify(this.model.get())};
	}
	var params = $.extend({
		contentType: 'application/json',
		dataType: "json",
      	url: (this._data.persist.baseUrl || '/app') + this._data.persist.collection + (_params.id ? '/'+_params.id : '')
    }, _params, dataPart);
    $.ajax(params);
};

/************************************
 *
 * adapter.restful for RemoteNAS
 *
 *
 */
$$.adapter.restfulRemoteNASForGET = function(_params) {
	var params = $.extend({
		data: this.model.get(),
      	url: (this._data.persist.baseUrl || '/app') + this._data.persist.collection + (_params.id ? '/'+_params.id : '')
    }, _params);
    $.ajax(params);
};

/************************************
 *
 * adapter.restful for RemoteNAS device
 *
 *
 */
$$.adapter.restfulRemoteNASDevice = function(_params) {
	var params;
	var pathPart = (currentPath.length > 0)?"/" + currentPath.toString().replace(/,/g,'/'):"";
	params = $.extend({
		timeout: 15000,
		contentType: 'application/json',
		dataType: "jsonp",
	    url: ((isHttps)?"https://":"http://") + currentDeviceAddress + pathPart + '/' + currentAction + sessionParam + deviceParams + this._data.persist.collection
	}, _params);
	$.ajax(params);
};

/************************************
 *
 * adapter.restful for RemoteNAS with plugin option
 *
 *
 */
$$.adapter.restfulRemoteNASPlugin = function(_params) {
	var plugin;
	if (plugin) {
		//use plugin
	} else {
		$$.adapter.restfulRemoteNAS(_params);
	}
};

/************************************
*
* Utils 
*
*
*/ 

var Utils = {
	gup: function(name,url) {
		name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
		var regexS = "[\\?&]"+name+"=([^&#]*)";
		var regex = new RegExp( regexS );
		var results;
		if (!url) {
			results = regex.exec( window.location.href );
		} else {
			results = regex.exec(url);
		}
		if( results == null )
			return "";
		else
			return results[1];
	},	
	formatSize: function(size) {
		if (size == 0 || !size) return "0 B";
		var i = 0;
		
		while (size > 1024) {
			size = size / 1024.0;
			++i;
		}
		var unit;
		switch (i) {
			case 0:
				unit = " B";
				break;
			case 1:
				unit = " KB";
				break;
			case 2:
				unit = " MB";
				break;
			case 3:
				unit = " GB";
				break;
			case 4:
				unit = " TB";
				break;
	
			default:
				break;
		}
		if (i > 1) return size.toFixed(1) + unit;
		return size.toFixed(0) + unit;
	},
	parseSize: function(size) {
		if (!size || size == '' || size == '-') return -1;
		var parts = size.match(/^(\d+(?:\.\d+)?) *(B|KB|MB|GB|TB)$/);
		var n = parseFloat(parts[1]);
		var type = parts[2];
	  	var map = {B: 1, KB: 1024, MB: 1024 * 1024, GB: 1024 * 1024 * 1024};
	  	return map[type] * n;
	},
	formatDate: function(date) {
		var minutes = date.getMinutes();
		if (minutes < 10) {
			minutes = "0" + minutes;	
		}
		return 	$.datepicker.formatDate("MM dd, yy" ,date) + " " + date.getHours() + ":" + minutes;
	},
	formatFileSize: function(bytes) {
		if (typeof bytes !== 'number') {
	        return '';
	    }
	    if (bytes >= 1000000000) {
	        return (bytes / 1000000000).toFixed(2) + ' GB';
	    }
	    if (bytes >= 1000000) {
	        return (bytes / 1000000).toFixed(2) + ' MB';
	    }
	    return (bytes / 1000).toFixed(2) + ' KB';
	},
	formatBitrate: function(bits) {
		if (typeof bits !== 'number') {
	        return '';
	    }
	    if (bits >= 1000000000) {
	        return (bits / 1000000000).toFixed(2) + ' Gbit/s';
	    }
	    if (bits >= 1000000) {
	        return (bits / 1000000).toFixed(2) + ' Mbit/s';
	    }
	    if (bits >= 1000) {
	        return (bits / 1000).toFixed(2) + ' kbit/s';
	    }
	    return bits + ' bit/s';
	},
	formatTime: function(seconds) {
		var date = new Date(seconds * 1000),
        days = parseInt(seconds / 86400, 10);
	    days = days ? days + 'd ' : '';
	    return days +
	        ('0' + date.getUTCHours()).slice(-2) + ':' +
	        ('0' + date.getUTCMinutes()).slice(-2) + ':' +
	        ('0' + date.getUTCSeconds()).slice(-2);
	},
	formatPercentage: function(floatValue) {
		return (floatValue * 100).toFixed(2) + ' %';
	},
	getWindowSize: function(width) {
		if (window.innerWidth) {
			return (width)?window.innerWidth:window.innerHeight;
		} else if (document.documentElement && document.documentElement.clientHeight) {
			return (width)?document.documentElement.clientWidth:document.documentElement.clientHeight;
		} else if (document.body) {
			return (width)?document.body.clientWidth:document.body.clientHeight;
		}
		return 0;
	},
	cutToWidth: function(width, container) {
		if (container.width() <= width) return container.text();
		var text = container.text();
		var i = text.length;
		while (i > 0 && container.width() > width) {
			container.text(text.substring(0, i) + "...");
			i--;
		}
		return text.substring(0, i+1) + "...";
	},
	clearSelection: function() {
		if (window.getSelection) {
			window.getSelection().removeAllRanges();
		} else if (document.selection) {
			document.selection.empty();
		}
	}
}

var ListType = {"devices": 0, "disks": 1, "folders": 2};

var Page = {
	resized: function() {
		if ($("#app").width() < 768 || Utils.getWindowSize(true) < $('#contentHeader').width() + 70) {
			$('body').css('padding-top', 0);
			$('body').css('padding-left', 20);
			$('body').css('padding-right', 20);
			$('#header').addClass('abs');
			$('#accountWrapper').addClass('abs');
			$('#contentHeader').addClass('abs');
			$('#contentContainer').css('padding-top', '39px');
		} else {
			$('body').css('padding-top', 40);
			$('body').css('padding-left', 70);
			$('body').css('padding-right', 70);
			$('#header').removeClass('abs');
			$('#accountWrapper').removeClass('abs');
			$('#contentHeader').removeClass('abs');
			$("#contentLocation").css('width', "auto");
			$('#contentContainer').css('padding-top', '139px');
		}
		contentHeader.reloadBreadcrumbs();
	},
	sortList: function(list) {
		var listitems = list.children('div.entry').get();
		var selector = '';
		switch (activeSortIndex) {
			case 1:
				selector = "div.sizeInfo span";
				listitems.sort(function(a, b) {
					var compA = Utils.parseSize($(selector, a).text());
					var compB = Utils.parseSize($(selector, b).text());
	  				if (activeSortDescending) {
	  					return (compA < compB) ? -1 : (compA > compB) ? 1 : 0;
	  				} else {
	  					return (compA > compB) ? -1 : (compA < compB) ? 1 : 0;
	  			}
				});
				break;
			case 2:
				selector = "div.modifiedInfo span";
				listitems.sort(function(a, b) {
					var compA = Date.parse($(selector, a).text());
					var compB = Date.parse($(selector, b).text());
	  				if (activeSortDescending) {
	  					return (compA < compB) ? -1 : (compA > compB) ? 1 : 0;
	  				} else {
	  					return (compA > compB) ? -1 : (compA < compB) ? 1 : 0;
	  			}
				});
				break;
			case 0:
			default:
				selector = "span.file";
				listitems.sort(function(a, b) {
					var compA = $(selector, a).text().toUpperCase();
					var compB = $(selector, b).text().toUpperCase();
	  				if (activeSortDescending) {
	  					return (compA < compB) ? -1 : (compA > compB) ? 1 : 0;
	  				} else {
	  					return (compA > compB) ? -1 : (compA < compB) ? 1 : 0;
	  			}
				});
				break;
		}
		
		$.each(listitems, function(idx, itm) {
			$(itm).removeClass("last"); 
			list.append(itm);
		});
		list.children(':last').addClass("last");
	},
	showList: function(type) {
		switch(type) {
			case ListType.devices:
				$("#addDevice").show();
				$("#newFolder").hide();
				$("#upload").hide();
				contentHeader.view.$("#sizeSort").hide();
				contentHeader.view.$("#modifiedSort").hide();
				contentHeader.view.$("#root span.divider").hide();
				contentHeader.model.reset();
				break;
			case ListType.disks:
				$("#addDevice").hide();
				$("#newFolder").hide();
				$("#upload").hide();
				contentHeader.view.$("#sizeSort").hide();
				contentHeader.view.$("#modifiedSort").hide();
				contentHeader.view.$("#root span.divider").show();
				break;
			case ListType.folders:
				$("#addDevice").hide();
				$("#newFolder").show();
				$("#upload").show();
				contentHeader.view.$("#root span.divider").show();
				contentHeader.view.$("#sizeSort").show();
				contentHeader.view.$("#modifiedSort").show();
				break;
		}
		contentHeader.reloadBreadcrumbs();
	},
	pushHome: function() {
		History.pushState(null, "Home", "?p=home&lang=" + lang);
		this.showHome();
	},
	pushLogin: function() {
		History.pushState(null, "Login", "?p=login&lang=" + lang);
		this.showLogin();
	},
	pushRegister: function() {
		History.pushState(null, "Register", "?p=register&lang=" + lang);
		this.showRegister();
	},
	openPath: function() {
		var p = "home/" + currentDeviceName + '/' + currentPath.toString().replace(/,/g,'/');
		ignoreStateEvent = true;
		History.pushState({'p': p}, "", "?p=" + Base64.encode(p) + "&lang=" + lang);
		folderContent.persist($$.adapter.restfulRemoteNASDevice, {collection:'', cache:false});
		folderContent.refresh();
	},
	showNotLoggedIn: function() {
		var stateUri = Utils.gup('p', History.getState().url);
		if (stateUri == "register") {
			Page.showRegister();
		} else {
			if (stateUri == "login") {
				Page.showLogin();
			} else {
				Page.pushLogin();
			}
		}
	},
	showLogin: function() {
		$("#main").hide();
		$("#registration").hide();
		$("#login").show();
		loginForm.view.$('#username-input').focus();
	},
	showRegister: function() {
		$("#main").hide();
		$("#login").hide();
		$("#registration").show();
		regInput.reloadCaptcha();
		registrationForm.view.$('#username-input').focus();
	},
	showHome: function() {
		$("#main").show();
		folderContent.view.$().hide();
		devicesContent.model.reset();
		currentPath.length = 0;
		devicesContent.refresh();
		devicesContent.view.$().show();	
	},
	goToCurrentState: function() {
		var encodedPath = Utils.gup("p", History.getState().url);
		if (encodedPath == "") {
			this.showHome();
			return;
		}
		currentPath = Base64.decode(encodedPath).split('/');
		if (currentPath.length == 1) {
			this.showHome();
			return;
		}
		currentDeviceName = currentPath[1];
		currentPath = currentPath.slice(2, currentPath.length);
		deviceCheckInBackground = true;
		$("#main").show();
		devicesContent.model.reset();
		devicesContent.refresh();
	}
} 

/************************************
 *
 * Error messages
 *
 * (red bar, overlays at top)
 *
 */
var errorMsg = $$({
	model: {msg:''}, 
	view: { 
		format:'<div><span data-bind="msg"/> <span id="close">' + l('%errorBarAdditionalInfo') + '</span></div>', 
    	style:'& {position:fixed; top:40px; left:0; right:0; z-index:1000; background:#f55; color:white; display:none; padding:5px 15px;}  & #close {float:right;}' 
  	},
  	controller: {},  
  		// User-defined
  		show: function(s){ 
    		var self = this;
    		this.model.set({msg:s}); 
    		this.view.$().slideDown(200, function(){
      			$(document).one('click', function(){ self.hide(); }); 
    		}); 
  		},
  		hide: function(){ this.view.$().slideUp(100); }
});
$$.document.append(errorMsg);


/************************************
 *
 * Page header
 *
 */

var lang = Utils.gup("lang");
if (!lang || !(lang == "de" || lang == "fr" || lang == "en" || lang == "it")) lang = "en";
String.locale = lang;

var localizations = $$({}, '<ul class="nav nav-pills pull-right">\
  								<li class="en"><a href="#">en</a></li>\
  								<li class="de"><a class="de" href="#">de</a></li>\
  								<li class="fr"><a class="fr" href="#">fr</a></li>\
  								<li class="it"><a class="it" href="#">it</a></li>\
							</ul>', {
								'create' : function() {
									this.view.$('li.' + lang).addClass('active');
								},
								'click a': function(event) {
									var pathPart = (Utils.gup('p') == "")?"?":"?p="+Utils.gup('p') + "&";
									var url = window.location.protocol + "//" + window.location.host + window.location.pathname + pathPart + "lang=" + jQuery(event.target).parent().attr('class');
									window.open(url, '_self');
      							}
							}
);
$$.document.append(localizations, '.navbar div.container');

var account = $$({
	model: {email: ''},
	view: {
		format:
			'<div class="btn-group pull-right">\
            <a class="btn dropdown-toggle" data-toggle="dropdown" href="">\
              <i class="icon-user"></i> <span data-bind="email"></span>\
              <span class="caret"></span>\
            </a>\
            <ul class="dropdown-menu">\
              <li><a data-toggle="modal" href="#profileModal">' + l('%Profile') + '</a></li>\
              <li class="divider"></li>\
              <li><a id="logout">' + l('%Logout') + '</a></li>\
            </ul>\
          </div>'
	},
	controller: {
		'click #logout': function(){
			SessionManagement.logout();
		}
	}
});
$$.document.before(account, 'ul.nav');
account.view.$().hide();


/************************************
 *
 * Main Content 
 *
 *
 */
var main = $$({}, '<div id="main" class="row"></div>');
$$.document.prepend(main, $('#app'));

var contentWrapper = $$({}, '<div id="contentWrapper" class="span12"></div>');
main.append(contentWrapper);

var breadcrumb = $$({
	model: {path: '', name: ''},
	view: {format: '<li><a><span data-bind="name"/></a><span class="divider">/</span></li>'},
	controller: {
		'click a': function() {
			currentPath.length = 0;
			currentPath = this.model.get('path').substring(1).split('/');
			contentHeader.model.set({currentDir: this.model.get('name')});
			Page.openPath();
		}
	},
	onclickElement: function(elementName) {
		currentPath = currentPath.slice(0, $.inArray(elementName, currentPath) + 1);
		contentHeader.model.set({currentDir: elementName});
		Page.openPath();
	} 
});

var breadcrumBoxElement = $$(breadcrumb, {}, '<li class="breadcrumbBoxElement"><a onclick="breadcrumBoxElement.onclickElement(this.firstChild.firstChild.nodeValue); return false;"><span data-bind="name"/></a></li>');

var breadcrumbBox = $$({}, '<ul class="breadcrumbList dropdown-menu"><li><a href=""></a></li></ul>', {
	'change': function() {
		this.view.$().empty();
		var parts = this.model.get('parts');
		var paths = this.model.get('paths');
		for (var i=0; i < parts.length; i++) {
			this.append($$(breadcrumBoxElement, {path: paths[i], name: parts[i]}));
		}
	}
});
	
var contentHeader = $$({
	model: {isRoot:true, currentDir:'', device:''},
	view: {
		format: 
			'<div id="contentHeader" class="row">\
			<div class="span12">\
			<div id="mainHeader" class="row">\
				<div title="' + l('%Reload') + '" id="reload" class="span1"><img src="img/sync.png"/></div>\
				<div id="contentLocation" class="span8">\
				<ul class="breadcrumb">\
					<li id="root" title="' + l('%Home') + '"><img src="img/home.png"/><span class="divider">/</span></li>\
					<li id="deviceBreadcrumb"><a><span class="device" data-bind="device"/></a><span class="divider">/</span></li>\
					<li class="dropdown" id="breadcrumbBox">\
						<a class="dropdown-toggle" data-toggle="dropdown" href="#breadcrumbBox"/><span class="box divider">/</span>\
					</li>\
					<span id="breadcrumbs" class="breadcrumb"/>\
					<li class="active"><span data-bind="currentDir"/></li>\
				</ul>\
				</div>\
				<div id="mainActions" class="span2"><ul>\
					<li><a id="upload" title="' + l('%Upload') + '"/></li>\
					<li><a id="newFolder" data-toggle="modal" href="#addNewFolderModal" title="' + l('%NewFolder') + '"/></li>\
					<li><a id="addDevice" data-toggle="modal" href="#addDeviceModal" title="' + l('%AddDevice') + '"/></li>\
				</ul></div>\
			</div>\
			<div id="contentSort" class="row">\
				<a id="nameSort" class="span6">' + l('%Name') + '<b class="caret" style="display: block;"/></a>\
				<a id="sizeSort" class="span1">' + l('%Size') + '<b class="caret"/></a>\
				<a id="modifiedSort" class="span3">' + l('%ModifiedOn') + '<b class="caret"/></a>\
				<span id="actionsSort" class="span1"/>\
			</div>\
			</div>\
			</div>'
	}, 
	controller: {
		'click #reload': function() {
			if (devicesContent.view.$().is(':visible')) {
				devicesContent.refresh();		
			} else {
				folderContent.refresh();	
			}
		},
		'click #deviceBreadcrumb .device': function() {
			currentPath.length = 0;
			this.model.set({currentDir: this.model.get('device'), device: ''});
			var p = "home/" + currentDeviceName;
			ignoreStateEvent = true;
			History.pushState({'p': p}, "", "?p=" + Base64.encode(p) + "&lang=" + lang);
			folderContent.persist($$.adapter.restfulRemoteNASDevice, {collection:'', cache:false});
			folderContent.refresh();
		},
		'click #breadcrumbBox': function() {
			$("#breadcrumbBox a").dropdown();
		},
		'click #root': function() {
			Page.pushHome();
		},
		'click #nameSort': function() {
			if (activeSortIndex == 0) {
				activeSortDescending = !activeSortDescending;
			} else {
				this.view.$('.caret').hide();
				this.view.$('#nameSort .caret').show();
				activeSortIndex = 0;
			}
			if (activeSortDescending) {
				this.view.$('#nameSort .caret').removeClass('up');
			} else {
				this.view.$('#nameSort .caret').addClass('up');
			}
			if (devicesContent.view.$().is(':visible')) {
				Page.sortList(devicesContent.view.$("div.content .span12"));
			} else {
				Page.sortList(folderContent.view.$("div.content .span12"));
			}
		},
		'click #sizeSort': function() {
			if (activeSortIndex == 1) {
				activeSortDescending = !activeSortDescending;
			} else {
				this.view.$('.caret').hide();
				this.view.$('#sizeSort .caret').show();
				activeSortIndex = 1;
			}
			if (activeSortDescending) {
				this.view.$('#sizeSort .caret').removeClass('up');
			} else {
				this.view.$('#sizeSort .caret').addClass('up');
			}
			Page.sortList(folderContent.view.$("div.content .span12"));
		},
		'click #modifiedSort': function() {
			if (activeSortIndex == 2) {
				activeSortDescending = !activeSortDescending;
			} else {
				this.view.$('.caret').hide();
				this.view.$('#modifiedSort .caret').show();
				activeSortIndex = 2;
			}
			if (activeSortDescending) {
				this.view.$('#modifiedSort .caret').removeClass('up');
			} else {
				this.view.$('#modifiedSort .caret').addClass('up');
			}
			Page.sortList(folderContent.view.$("div.content .span12"));
		},
		'click #upload': function() {
			$('#uploadModal').modal('show');
		}
	},
	// User-defined
  	reloadBreadcrumbs: function(){
  		if (this.model.get('device') != '') {
	    	this.model.set({currentDir: Utils.cutToWidth(0.55*Utils.getWindowSize(true), $("ul.breadcrumb li.active span"))});
  			this.view.$("#deviceBreadcrumb").show();
  			if ($("#deviceBreadcrumb span.device").width() > 600) {
  				this.model.set('device', Utils.cutToWidth(600, $("#deviceBreadcrumb span.device")));
  			}	
  		} else {
  			this.view.$("#deviceBreadcrumb").hide();
  		}
  		this.view.$("#breadcrumbs").empty();
  		this.view.$("#breadcrumbs").hide();
  		
  		var pathLength = currentPath.length;
  		$("#breadcrumbBox").hide();
    	this.view.$("span.box.divider").hide();
    	if (pathLength > 0) {
    		this.view.$("#root span.divider").show();
    		this.model.set({currentDir: currentPath[pathLength - 1]});
    	}
    	if (pathLength > 1) {
			var path = "";
    		this.view.$("#breadcrumbs").show();
    		for(var i = 0; i < pathLength - 1; i++) {
    			path += '/' + currentPath[i];
    			this.append($$(breadcrumb, {path: path, name: currentPath[i]}), "#breadcrumbs");
    		}
    		if ($("#contentLocation").width() > 0.55*Utils.getWindowSize(true) || $("ul.breadcrumb").height() > 38)	 {
    			
    			if (pathLength == 2) {
    				var breadcrumbWidth = 0.55*Utils.getWindowSize(true) - $("#root").width() - $("#deviceBreadcrumb").width();
    				Utils.cutToWidth(breadcrumbWidth, $("b.breadcrumbRN span"));
    			} else {
	    			//$("#breadcrumbBox ul.breadcrumbList").hide();
	    			$("#breadcrumbBox").attr('style', 'display:inline;');
	    			this.view.$("span.box.divider").show();
	    			var boxLength = 2;
	    			do {
	    				breadcrumbBox.view.$().empty();
	    				path = "";
	    				for(var i = 0; i < boxLength; i++) {
    						path += '/' + currentPath[i];
    						this.append($$(breadcrumBoxElement, {path: path, name: currentPath[i]}), "#breadcrumbBox ul.breadcrumbList");
						}
						this.view.$("#breadcrumbs").empty();
						if (boxLength == pathLength - 1) this.view.$("#breadcrumbs").hide();
						for(var i = boxLength; i < pathLength - 1; i++) {
    						path += '/' + currentPath[i];
    						this.append($$(breadcrumb, {path: path, name: currentPath[i]}), "#breadcrumbs");
    					}
    					boxLength++;
	    			} while (boxLength < pathLength && $("#contentLocation").width() > 0.55*Utils.getWindowSize(true));
	    			if ($("#contentLocation").width() > 0.55*Utils.getWindowSize(true)) {
	    				this.model.set({currentDir: Utils.cutToWidth(0.55*Utils.getWindowSize(true) - $("#root").width() - $("#deviceBreadcrumb").width() - $("#breadcrumbBox").width() - 45, $("ul.breadcrumb li.active span"))});
	    			}
	    		}	
    		}
    	}
  	}
});
contentHeader.append(breadcrumbBox, "#breadcrumbBox");
contentWrapper.append(contentHeader);

var contentContainer = $$({}, '<div class="row"><div id="contentContainer" class="span12"/></div>');
contentWrapper.append(contentContainer);

var device = $$({}, '<div class="entry row">\
			<div class="fileInfo span6"><a class="filename"><b data-bind="class=icon"/><o class="offset"/><span class="file" data-bind="name"/></a></div>\
			<div class="sizeInfo span2">&nbsp;</div>\
			<div class="modifiedInfo span2">&nbsp;</div>\
			<div class="actions span1"><a title="Remove device" class="delete"/><a title="' + l('%Rename') + '" class="rename"/></div>\
			</div>', {
				'click a.filename': function() {
					var gc = this.model.get('gatewayClient');
					if (gc['status'] == 'CONNECTED') {
						devicesContent.view.$().hide();
						folderContent.view.$().show();
						ldId = this.model.get('lanDeviceId');
						gcId = gc['gatewayClientId'];
						deviceParams = "&LD_ID=" + this.model.get('lanDeviceId') + "," + "&GC_ID=" + gc['gatewayClientId'] + ",";
						upnpAddress = gc['upnpAddress'] + ":" + gc['upnpPort'];
						currentAction = readAction;
						currentDeviceName = this.model.get('name');
						var p = "home/" + currentDeviceName;
						ignoreStateEvent = true;
						History.pushState({'p': p}, "", "?p=" + Base64.encode(p) + "&lang=" + lang);
						contentHeader.model.set({currentDir: currentDeviceName});
						folderContent.persist($$.adapter.restfulRemoteNASDevice, {collection:'', cache:false});
						checkUpnp();
						isHttps = false;
						folderContent.refresh();
					}
				},
				'click a.delete': function() {
					removeDevice.model.set({ldId: this.model.get('lanDeviceId')});
					$('#removeDeviceModal').modal('show')
				},
				'click a.rename': function() {
					renameDevice.model.set({settings: this.model.get(), name: this.model.get('name'), ldId: this.model.get('lanDeviceId')});
					$('#renameDeviceModal').modal('show')
				}
			});

var EntryActions = {
	download: function(name) {
		window.open(((isHttps)?"https://":"http://") + currentDeviceAddress + '/' + currentPath.toString().replace(/,/g,'/') + '/' + name + readAction + '&wantContentDisposition=1' + sessionParam + deviceParams, "_self");
	},
	rename: function(name) {
		renameFileFolder.model.set({newName: name, oldName:  name});
		$('#renameFileFolderModal').modal('show');
	},
	move: function(name) {
		moveFileFolder.model.set({name: name});
		$('#moveFileFolderModal').modal('show');
	},
	remove: function(name, type) {
		if (type == 6 || type == 4) {
			removeFolder.model.set({name: name});
			$('#removeFolderModal').modal('show');
		} else {
			removeFile.model.set({name: name});
			$('#removeFileModal').modal('show')
		}
	}	
};
	
var entry = $$({}, '<div class="entry row" oncontextmenu="return false;">\
			<div class="fileInfo span6"><a class="filename"><b data-bind="class=icon"/><o class="offset"/><span class="file" data-bind="n"/></a></div>\
			<div class="sizeInfo span1"><span data-bind="s"/></div>\
			<div class="modifiedInfo span3"><span data-bind="mt"/></div>\
			<div class="actions span2"><a class="rename" title="' + l('%Rename') + '"/><a class="move" title="' + l('%Move') + '"/><a class="delete" title="' + l('%Delete') + '"/></div>\
			</div>', {
				'contextmenu &': function(e) {
					if (this.model.get('t') != 6) {
						Utils.clearSelection();
						contextMenu.showMenu(e.pageX, e.pageY, this.model.get('n'), this.model.get('t'));
					}
				},
				'click a.filename': function() {
					var type = this.model.get('t');
					currentPath.push(this.model.get('n'));
					if (type == 6 || type == 4) {
						//folder or disk
						contentHeader.model.set({currentDir: this.model.get('n'), device: currentDeviceName});
						Page.openPath();
					} else {
						currentPath.pop();
						var imgIndex = this.model.get('imgIndex');
						if (imgIndex != undefined) {
							//image or video
							lightboxPopup.model.set({title: currentPath.toString().replace(/,/g,'/')});
							if(Galleria.get().length != 0) {
								Galleria.get(0).trigger('galleria-newcontent');
								Galleria.configure({show: imgIndex});
								Galleria.get(0).load(currentImages);
							} else {
								Galleria.run('#galleria', { dataSource: currentImages, show: imgIndex});
								Galleria.get(0).bind('galleria-newcontent', function() {
									$("#lightboxModal div.lightbox-loader").show();
								});
							}
							$('#lightboxModal').modal('show');
						} else {
							window.open(((isHttps)?"https://":"http://") + currentDeviceAddress + '/' + currentPath.toString().replace(/,/g,'/') + '/' + this.model.get('n') + readAction + sessionParam + deviceParams, "_blank");
						}
					}
					
				},
				'click a.download': function() {
					EntryActions.download(this.model.get('n'));
				},
				'click a.delete': function() {
					EntryActions.remove(this.model.get('n'), this.model.get('t'))
				},
				'click a.rename': function() {
					EntryActions.rename(this.model.get('n'));
				},
				'click a.move': function() {
					EntryActions.move(this.model.get('n'));
				}
			});

var emptyInfo = $$({}, '<div class="empty span12">' + l('%emptyFolderInfo') + '</div>');
var noDevsInfo = $$({}, '<div class="empty span12">' + l('%noDevices') + '</div>')

var contentPrototype = $$({
	model: {},
	view: {},
	controller: {
		'persist:start': function(){
			$("div.content .span12").empty();
			this.view.$('div.ajax img').show();
		},
		'persist:stop': function(){
			this.view.$('div.ajax img').hide();
		},
		'persist:error': function(){
			errorMsg.show(l('%serverError'));
		},
		'persist:load:success': function(event, data){
			if (!data) {
				SessionManagement.logout();
				return;
			}
			if (data['status'] != "SUCCESS") {
				errorMsg.show(l('%serverError'));
				return;
			}
			var ice = data['iceParameters']['params'];
//			currentDeviceAddress = relayAddress = ice['relayIp'] + ":" + ice['relayPort'];
//			currentDeviceAddress = relayAddress = "192.168.21.100:4080";
			currentDeviceAddress = relayAddress = "maxi:1443";
			sessionParam = "&JSESSIONID=" + $.cookie('JSESSIONID') +",";
			
			if(deviceCheckInBackground) {
				deviceCheckInBackground = false;
				var i = 0;
				var found = false;
				var foundDevice;
				do {
					if (data['devices'][i]['name'] == currentDeviceName) {
						found = true;
						foundDevice = data['devices'][i];
					}
					i++;
				} while (!found && i < data['devices'].length -1);
				if (found) {
					var gc = foundDevice['gatewayClient'];
					if (gc['status'] == 'CONNECTED') {
						devicesContent.view.$().hide();
						folderContent.view.$().show();
						deviceParams = "&LD_ID=" + foundDevice['lanDeviceId'] + "," + "&GC_ID=" + gc['gatewayClientId'] + ",";
						upnpAddress = gc['upnpAddress'] + ":" + gc['upnpPort'];
						currentAction = readAction;
						if (currentPath.length == 0) {
							contentHeader.model.set({currentDir: currentDeviceName});
						} else {
							contentHeader.model.set({device: currentDeviceName});
						}
						folderContent.persist($$.adapter.restfulRemoteNASDevice, {collection:'', cache:false});
						checkUpnp();
						//isHttps = false;
						folderContent.refresh();
					} else {
						currentDeviceName = "";
						Page.showHome();
					}
				} else {
					currentDeviceName = "";
					Page.showHome();
				}
				return;
			}
			
			$("div.content .span12").empty();
			var devicesNum = data['devices'].length;
			if (devicesNum > 0) {
				for (var i = 0; i < devicesNum; i++) {
					var newEntry = $$(device,data['devices'][i]);
					if (newEntry.model.get('gatewayClient')['status'] == 'CONNECTED') {
						newEntry.model.set({icon: 'dev-on'});
					} else {
						newEntry.model.set({icon: 'dev-off'});
					}
					this.append(newEntry, "div.content .span12");
				}
				//sort by name
				Page.sortList(this.view.$("div.content .span12"));
			} else {
				this.append($$(noDevsInfo), "div.content .span12");
			}
		},
		'persist:error': function(){
			errorMsg.show(l('%serverError'));
		}
	}
}).persist($$.adapter.restfulRemoteNAS, {collection:contentCollection, cache:false});


var devicesContent = $$(contentPrototype, {
	model: {},
	view: {format: '<div class="deviceContent row"><div class="span12"><div class="row ajax"><img src="img/ajax.gif"/></div><div class="content row"><div class="span12"/></div></div></div>'},
	// User-defined
  	refresh: function(){
  		this.model.reset();
    	this.loadNoId();
    	Page.showList(ListType.devices);
  	}
}).persist($$.adapter.restfulRemoteNAS, {collection:'/hm/ld?class=nas', cache:false});
$$.document.append(devicesContent, "#contentContainer");

var folderContent = $$(contentPrototype, {
	model: {},
	view: {format: '<div class="folderContent row">\
						<div class="span12">\
							<div class="row ajax">\
								<img src="img/ajax.gif"/>\
							</div>\
							<div class="content row">\
								<div class="span12"/>\
							</div>\
						</div>\
					</div>'
			},
	controller: {
		'persist:load:success': function(event, data){
			if (data['hc'] == 200) {
				$("div.content .span12").empty();
				var entriesNum = data['entries'].length;
				currentImages.length = 0;
				var imgIndex = 0;
				diskList = false;
				if (entriesNum > 0) {
					var entries = data['entries'].sort(function(a,b) {
						if (a.n.toUpperCase() > b.n.toUpperCase()) {
							return 1;
						} else if (a.n.toUpperCase() < b.n.toUpperCase()) {
							return -1;
						}
						return 0;
					});
					for (var i = 0; i < entriesNum; i++) {
						var newEntry = $$(entry,entries[i]);
						var type = newEntry.model.get('t');
						if (type == 8) {
							var filename = newEntry.model.get('n').toLowerCase();
							var extension = (/[.]/.exec(filename)) ? /[^.]+$/.exec(filename) : "undefined";
							if (extension.constructor == Array) extension = extension[0];
							newEntry.model.set({icon: extension});
							if ($.inArray(extension, imageTypes) != -1 || $.inArray(extension, videoTypes) != -1) {
								//image or video
								newEntry.model.set({imgIndex: imgIndex});
								imgIndex++;
								var imgPath = ((isHttps)?"https://":"http://") + currentDeviceAddress + '/' + currentPath.toString().replace(/,/g,'/') + '/' + newEntry.model.get('n') + readAction + sessionParam + deviceParams;
								if ($.inArray(extension, videoTypes) != -1) {
									//video
									currentImages.push({iframe: 'video.html?path=' + imgPath, title: newEntry.model.get('n')});
								} else {
									//image
									currentImages.push({image: imgPath, big: imgPath, title: newEntry.model.get('n')});
								}
							}
							newEntry.model.set({s: Utils.formatSize(newEntry.model.get('s'))});
 						} else {
							newEntry.model.set({icon: 'dir'});
							if (type == 6) {
								//disks list
								newEntry.view.$('.actions').hide();
								newEntry.model.set({s: ''});
							} else {
								newEntry.model.set({s: '-'});
							}
						}
						if (type == 6) {
							newEntry.model.set({mt: ''});	
						} else {
							var modified = newEntry.model.get('mt');
							if (modified && modified != "") {
								newEntry.model.set({mt: Utils.formatDate(new Date(modified*1000))});
							} else {
								newEntry.model.set({mt: '-'});	
							}
						}
						this.append(newEntry, "div.content .span12");
					}
					Page.sortList(this.view.$("div.content .span12"));
				} else {
					this.append($$(emptyInfo), "div.content .span12");
				}
			} else {
				errorMsg.show(l("%serverError"));
			}
		}
	},
	// User-defined
	refresh: function() {
		if (currentPath.length == 0) {
			Page.showList(ListType.disks);
		} else {
			Page.showList(ListType.folders);
		}
		this.loadNoId();
	}
});
$$.document.append(folderContent, "#contentContainer");
folderContent.view.$().hide();

			
var contextMenu = $$({model: {name: '', type: ''}, 
		view: {format:'<li class="contextMenu dropdown">\
			<a class="dropdown-toggle" data-toggle="dropdown"></a>\
    		<ul class="dropdown-menu">\
	     		<li class="download"><a class="download" href="#">Download</a></li>\
	      		<li><a class="delete" href="#">' + l('%Delete') + '</a></li>\
	      		<li class="move"><a class="move" href="#">' + l('%Move') + '</a></li>\
	      		<li><a class="rename" href="#">' + l('%Rename') + '</a></li>\
    		</ul>\
  		</li>'
  		}, 
  		controller: {
			'click a.download': function() {
				EntryActions.download(this.model.get('name'));
			},
			'click a.delete': function() {
				EntryActions.remove(this.model.get('name'), this.model.get('type'))
			},
			'click a.rename': function() {
				EntryActions.rename(this.model.get('name'));
			},
			'click a.move': function() {
				EntryActions.move(this.model.get('name'));
			}
  		}, 
  		showMenu: function(left, top, name, type) {
  			this.view.$('ul.dropdown-menu').css('left', left + 'px').css('top', top - $(window).scrollTop() + 'px');
  			this.model.set({name: name, type: type});
			if (type == 4) {
				this.view.$('li.download').hide();
			} else {
				this.view.$('li.download').show();
			}
			this.view.$('.dropdown-toggle').dropdown('toggle');
  		}
});
$$.document.append(contextMenu, "#contentContainer");

/************************************
*
* Lightbox 
*
*
*/
var lightboxPopup = $$({title: ''}, '<div class="modal hide" id="lightboxModal">\
	<div class="modal-header"><button type="button" class="close" data-dismiss="modal">&times;</button><h3 data-bind="title"/></div>\
  		<div class="modal-body">\
  			<div class="lightbox-loader"/>\
  		</div>\
	</div>'
);

var lightbox = $$({}, '<div id="galleria"/>', {
	'create' : function() {
		Galleria.configure({
			imageCrop: false,
			_showPopout: false,
			initialTransition: 'fade',
			maxScaleRatio: 1,
			thumbnails: 'false'
		});
		Galleria.on('fullscreen_enter', function(e) {
			if (frames.length > 0) {
				if (frames.length > 1) {
					frames[1].videOn();	
				} else {
					frames[0].videoOn();
				}
			}
		}).on('fullscreen_exit', function() {
			if (frames.length > 0) {
				if (frames.length > 1) {
					frames[1].videOn();	
				} else {
					frames[0].videoOn();
				}
			}
		}).on('image', function() {
			if ($("#lightboxModal div.lightbox-loader").is(':visible')) {
				$("#lightboxModal div.lightbox-loader").hide();
			}
			if (frames.length > 0) {
				if (frames.length > 1) {
					frames[1].videOn();	
				} else {
					frames[0].videoOn();
				}
			}
		});
	}	
});
$$.document.append(lightboxPopup);
lightboxPopup.prepend(lightbox, 'div.modal-body');
$('#lightboxModal').on('shown', function() {
	document.body.style.overflow = 'hidden';
}).on('hidden', function() {
	$('body').css('overflow-y', 'scroll');
});

/************************************
*
* Popups 
*
*
*/

var infoPopupPrototype = $$({title: '', text: ''}, '<div class="modal hide">\
		<div class="modal-header"><button type="button" class="close" data-dismiss="modal">&times;</button><h3 data-bind="title"/></div>\
	  		<div class="modal-body">\
	  			<p data-bind="text"/>\
	  		</div>\
			<div class="modal-footer">\
	    		<a href="#" class="btn btn-primary" data-dismiss="modal">' + l('%OK') + '</a>\
			</div>\
		</div>'
);

var yesNoPopupPrototype = $$({title: '', text: ''}, '<div class="modal hide">\
		<div class="modal-header"><button type="button" class="close" data-dismiss="modal">&times;</button><h3 data-bind="title"/></div>\
	  		<div class="modal-body">\
  				<p data-bind="text"/>\
  			</div>\
			<div class="modal-footer">\
				<a href="#" class="btn" data-dismiss="modal">' + l('%No') + '</a>\
    			<a href="#" class="btn btn-primary">' + l('%Yes') + '</a>\
			</div>\
		</div>'
);

var profile = $$({}, '<div id="profileModal" class="modal hide">\
		<div class="modal-header"><button type="button" class="close" data-dismiss="modal">&times;</button><h3>' + l('%Profile') + '</h3></div>\
	  		<form>\
  				<div class="modal-body">\
	  				<fieldset>\
 			 			<div class="email control-group">\
							<label class="control-label" for="email-input">' + l('%Email') +':</label>\
							<div class="controls">\
								<input id="email-input" type="text" class="input-xlarge" data-bind="email">\
								<span class="help-inline" id="emailInvalidHelp">' + l('%registrationEmailInvalidError') +'</span>\
								<span class="help-inline" id="emailTakenHelp">' + l('%registrationEmailTakenError') +'</span>\
							</div>\
						</div>\
						<div class="password control-group">\
							<label class="control-label" for="pwdprofile-input0">' + l('%CurrentPassword') +':</label>\
							<div class="controls">\
								<input id="pwdprofile-input0" type="password" class="profile-pwd input-xlarge">\
								<span class="help-inline" id="currentPasswordHelp">' + l('%registrationPasswordInvalidError') +'</span>\
							</div>\
						</div>\
						<div class="newPassword control-group">\
							<label class="control-label" for="pwdprofile-input1">' + l('%NewPassword') +':</label>\
							<div class="controls">\
								<input id="pwdprofile-input1" type="password" class="profile-pwd input-xlarge">\
								<span class="help-inline" id="passwordHelp">' + l('%registrationPasswordInvalidError') +'</span>\
							</div>\
						</div>\
						<div class="confirm control-group">\
							<label class="control-label" for="pwdprofile-input2">' + l('%ConfirmNewPassword') +':</label>\
							<div class="controls">\
								<input id="pwdprofile-input2" type="password" class="profile-pwd input-xlarge">\
								<span class="help-inline" id="passwordMatchHelp">' + l('%registrationPasswordMatchError') +'</span>\
							</div>\
						</div>\
						<div class="firstname control-group">\
							<label class="control-label" for="firstname-input">' + l('%FirstName') +':</label>\
							<div class="controls">\
								<input id="firstname-input" type="text" class="input-xlarge" data-bind="firstname">\
								<span class="help-inline" id="firstnameHelp">' + l('%registrationFirstNameInvalidError') +'</span>\
							</div>\
						</div>\
						<div class="lastname control-group">\
							<label class="control-label" for="lastname-input">' + l('%LastName') +'</label>\
							<div class="controls">\
								<input id="lastname-input" type="text" class="input-xlarge" data-bind="lastname">\
								<span class="help-inline" id="lastnameHelp">' + l('%registrationLastNameInvalidError') +'</span>\
							</div>\
						</div>\
						<span id="saveError" class="help-line errorInfo">' + l('%loadAccountError') + '</span>\
  					</fieldset>\
  					<div class="ajax"><img src="img/ajax.gif"/></div>\
  				</div>\
				<div class="modal-footer">\
					<a href="#" class="btn btn-danger" data-dismiss="modal">' + l('%DeleteAccount') + '</a>\
					<a href="#" class="btn" data-dismiss="modal">' + l('%Cancel') + '</a>\
    				<a href="#" class="btn btn-primary">' + l('%OK') + '</a>\
				</div>\
			</form>\
		</div>', {
		'click .btn-danger': function() {
			$('#profileModal').modal('hide');
			$('#deleteAccountModal').modal('show');
		},
		'click .btn-primary': function() {
			this.view.$('div').removeClass('error');
			this.view.$("span.help-inline").hide();
			var error = false;
			$("#registrationError").hide();
			
			if (this.model.get('firstname').length == 0 ) {
				error = true;
				this.view.$('div.firstname').addClass('error');
			}
			if (this.model.get('lastname').length == 0 ) {
				this.model.get('lastname') = true;
				this.view.$('div.lastname').addClass('error');
			}
			if (this.model.get('email').match(/^\s*[\w\-\+_]+(\.[\w\-\+_]+)*\@[\w\-\+_]+\.[\w\-\+_]+(\.[\w\-\+_]+)*\s*$/) == null) {
				error = true;
				this.view.$('div.email').addClass('error');
				this.view.$('#emailInvalidHelp').show();
			}	
			var password = document.getElementById('pwdprofile-input0').value;
			if (password.length > 0 ) {
				this.model.set({password: password});
				var newPassword = document.getElementById('pwdprofile-input1').value;			
				var confirm = document.getElementById('pwdprofile-input2').value;
				if ((newPassword.length == 0) != (confirm.length == 0)) { //exactly one of them is empty
					error = true;
					if (newPassword.length != 0) {
						this.view.$('#passwordMatchHelp').show();
						this.view.$('div.confirm').addClass('error');	
					} else {
						this.view.$('#passwordHelp').show();
						this.view.$('div.newPassword').addClass('error');	
					}
				} else if (newPassword != confirm) {
					error = true;
					this.view.$('#passwordMatchHelp').show();
					this.view.$('div.confirm').addClass('error');	
				}
			}
			
			if (!error) {
				this.model.set({username: this.model.get('email')});
				this.view.$('div.ajax img').show();
				if (password.length > 0) {
					$.ajax({
						type: "POST",
						url: 'hm/user/verifyPassword',
						data: password,
						success: function(data) {
							if (!data || data != "CORRECT") {
								profile.view.$('#currentPasswordHelp').show();
								profile.view.$('pwdprofile-input0').attr('value', '');
								profile.view.$('div.password').addClass('error');
								profile.view.$('div.ajax img').hide();	
								return;
							}
							profile.model.set({password: newPassword});
							profile.saveProfile(profile.model.get());		
						},
						error: function() {
							profile.view.$('div.ajax img').hide();
							$('#profileModal').modal('hide');
							errorMsg.show(l("%serverError"));
						}
					});
				} else {
					this.saveProfile(this.model.get());
				}
			} else {
				this.view.$('div.all').addClass('error');
				$("#registrationError").show();	
				this.view.$('#username-input').focus();
			}
		},
		'persist:start': function(){
			this.view.$('div.ajax img').show();
		},
		'persist:stop': function(){
			this.view.$('div.ajax img').hide();
		},
		'persist:error': function(){
			errorMsg.show(l("%serverError"));		
		},
		'persist:load:success': function(event, data){
			if (!data || data['email' == '']) {
				errorMsg.show(l("%serverError"));
				return;	
			}
			tempProfileData = data;
		},
		'persist:save:success': function(event, data){
			
		}
	}, {
	saveProfile: function(profileData) {
		$.ajax({
			type: "PUT",
			url: 'hm/user',
			contentType: 'application/json',
			data: JSON.stringify(profileData),
			dataType: 'json',
			success: function(data) {
				profile.view.$('div.ajax img').hide();
				if (!data || data['status'] != "SUCCESS") {
					profile.view.$('#saveError').show();
					profile.view.$('fieldset').addClass('error');
					return;	
				}
				$('#profileEditSuccessModal').modal('show');
				account.model.set({email: profile.model.get('email')});
				$('#profileModal').modal('hide');
			},
			error: function() {
				profile.view.$('div.ajax img').hide();
				$('#profileModal').modal('hide');
				errorMsg.show(l("%serverError"));
			}
		});
	}
}).persist($$.adapter.restfulRemoteNASForGET, {collection:'/hm/user', cache:false});
$$.document.append(profile);
$('#profileModal').on('shown', function () {
	profile.view.$('div.ajax img').hide();
	profile.view.$('fieldset span').hide();
	profile.view.$('fieldset div').removeClass('error').removeClass('warning');
	profile.loadNoId();
}).on('hidden', function() {
	profile.view.$('input.profile-pwd').attr('value', '');
	profile.model.reset();
});

var profileEditSuccess = $$(infoPopupPrototype, {title: l("%Success"), text: l("%profileEditSuccess")}, infoPopupPrototype.view.format,
						{'create' : function() {this.view.$().attr('id', 'profileEditSuccessModal');}});
$$.document.append(profileEditSuccess);

var deleteAccount = $$(yesNoPopupPrototype, {name: '', title: l("%DeleteAccount"), text: l("%AreYouSure")}, yesNoPopupPrototype.view.format, {
	'create' : function() {
		this.view.$().attr('id', 'deleteAccountModal');
	},
	'click a.btn-primary': function() {
		$('#deleteAccountModal').modal('hide');
		$.ajax({
			type: "DELETE",
			url: 'hm/user',
			success: function(data) {
				if (!data) {
					errorMsg.show(l("%serverError"));
					return;
				}
				$('#deleteAccountModalSuccessModal').modal('show');
				SessionManagement.logout();
			},
			error: function() {
				errorMsg.show(l("%serverError"));
			}
		});
	}
});
$$.document.append(deleteAccount);

var deleteAccountSuccess = $$(infoPopupPrototype, {title: l("%Success"), text: l("%deleteAccountSuccess")}, infoPopupPrototype.view.format,
						{'create' : function() {this.view.$().attr('id', 'deleteAccountSuccessModal');}});
$$.document.append(deleteAccountSuccess);

var upload = $$({},
			'<div class="modal hide" id="uploadModal">\
				<div class="modal-header"><button type="button" class="close" data-dismiss="modal">&times;</button><h3>' + l('%uploadPopupTitle') + '</h3></div>\
				<form id="fileupload" action="" method="POST" enctype="multipart/form-data">\
					<div class="modal-body">\
						<p>' + l('%uploadPopupInfo') + '</p>\
						<!-- The global progress information -->\
						<div class="fileupload-progress fade">\
							<!-- The global progress bar -->\
							<div class="progress progress-success progress-striped active" role="progressbar" aria-valuemin="0" aria-valuemax="100">\
								<div class="bar" style="width:0%;"></div>\
							</div>\
							<!-- The extended global progress information -->\
							<div class="progress-extended">&nbsp;</div>\
						</div>\
						<br>\
						<!-- The loading indicator is shown during file processing -->\
					<div class="modal-footer">\
						<span class="btn btn-success fileinput-button">\
							<i class="icon-plus icon-white"></i>\
							<span>' + l('%AddFiles') + '</span>\
							<input type="file" name="files[]" multiple>\
						</span>\
						<button type="reset" class="btn btn-warning cancel">\
							<i class="icon-ban-circle icon-white"></i>\
							<span>' + l('%CancelUpload') + '</span>\
						</button>\
					</div>\
				</form>\
			</div>'
);
$$.document.append(upload);

var jqXHR;
var isIE = navigator.userAgent.indexOf('MSIE') != -1;
if (isIE) $('#fileupload .fileupload-progress').addClass('progress-animated');
$('#fileupload').fileupload({
	add: function (e, data) {
		if (isIE) {
			$(this).find('.fileupload-progress').removeClass('fade');
			$(this).find('.fileupload-progress .bar').css('width', '100%');
		}
		$("#uploadModal").modal({'backdrop': 'static'});
		$("#uploadModal button.close").hide();
        jqXHR = data.submit()
            .error(function (jqXHR, textStatus, errorThrown) {
            	$("#uploadModal").modal({'backdrop': true});
            	$("#uploadModal button.close").show();
               if (errorThrown === 'abort') {
               		$('#fileupload .fileupload-loading').hide();
           			$('#uploadCancelModal').modal('show');
                } else {
                	errorMsg.show(l("%serverError"));
                }
            });
    },
	// Callback for global upload progress events:
    progressall: function (e, data) {
    	if ($(this).find('.fileupload-loading').is(':visible')) {
    		$(this).find('.fileupload-loading').hide();
    	}
        var $this = $(this),
            progress = parseInt(data.loaded / data.total * 100, 10),
            globalProgressNode = $this.find('.fileupload-progress'),
            extendedProgressNode = globalProgressNode
                .find('.progress-extended');
        if (extendedProgressNode.length) {
            extendedProgressNode.html(
            		Utils.formatBitrate(data.bitrate) + ' | ' +
            		Utils.formatTime(
                        (data.total - data.loaded) * 8 / data.bitrate
                    ) + ' | ' +
                    Utils.formatPercentage(
                        data.loaded / data.total
                    ) + ' | ' +
                    Utils.formatFileSize(data.loaded) + ' / ' +
                    Utils.formatFileSize(data.total)
            );
        }
        globalProgressNode
            .find('.progress')
            .attr('aria-valuenow', progress)
            .find('.bar').css(
                'width',
                progress + '%'
            );
    },
    // Callback for uploads start, equivalent to the global ajaxStart event:
    start: function (e) {
    	$(this).find('.fileupload-progress').removeClass('fade');
    	if (!isIE) $(this).find('.fileupload-loading').show();
    },
    // Callback for uploads stop, equivalent to the global ajaxStop event:
    stop: function (e) {
        var fileuploadProgress = $(this).find('.fileupload-progress').addClass('fade');
        fileuploadProgress.find('.progress').attr('aria-valuenow', '0').find('.bar').css('width', '0%');
        fileuploadProgress.find('.progress-extended').html('&nbsp;');
    },
	done: function (e, data) {
		$("#uploadModal button.close").show();
		$('#uploadModal').modal('hide');
		$("#uploadModal").modal({'backdrop': true});
		$('#uploadSuccessModal').modal('show');
		folderContent.refresh();
    },
    drop: function (e, data) {
        $.each(data.files, function (index, file) {
        	$('#sessionInput').attr('value', $.cookie('JSESSIONID'));
        	$('#gcInput').attr('value', gcId);
        	$('#ldInput').attr('value', ldId);
        	$('#folderInput').attr('value', '/' + currentPath.toString().replace(/,/g,'/'));
        	$('#fileupload').attr('action', (isHttps)?'https://':'http://' +  currentDeviceAddress + '/' + currentPath.toString().replace(/,/g,'/') + '/' + file.name + '?action=write' + sessionParam + deviceParams);
        });
    },
    change: function (e, data) {
        $.each(data.files, function (index, file) {
        	$('#sessionInput').attr('value', $.cookie('JSESSIONID'));
        	$('#gcInput').attr('value', gcId);
        	$('#ldInput').attr('value', ldId);
        	$('#folderInput').attr('value', '/' + currentPath.toString().replace(/,/g,'/'));
        	$('#fileupload').attr('action', (isHttps)?'http://':'http://' +  currentDeviceAddress + '/' + currentPath.toString().replace(/,/g,'/') + '/' + file.name + '?action=write' + sessionParam + deviceParams);
        });
    },
    dataType: 'json',
    redirect: window.location.href.replace(
            /\/[^\/]*$/,
            '/cors/result.html?%s'
        )
});
$('#fileupload button.cancel').click(function (e) {
	if (jqXHR) {
		jqXHR.abort();
	} else {
		$('#fileupload').trigger('fileuploadfail');
	}
});

var uploadSuccess = $$(infoPopupPrototype, {title: l("%Success"), text: l("%filesUploadSuccess")}, infoPopupPrototype.view.format,
					{'create' : function() {this.view.$().attr('id', 'uploadSuccessModal');}});
$$.document.append(uploadSuccess);

var uploadCanceled = $$(infoPopupPrototype, {title: l("%UploadCanceledTitle"), text: l("%UploadCanceledInfo")}, infoPopupPrototype.view.format,
					{'create' : function() {this.view.$().attr('id', 'uploadCancelModal');}});
$$.document.append(uploadCanceled);


/************************************
*
* Device popups 
*
*
*/

var addDevice = $$({code: ''}, '<div class="modal hide" id="addDeviceModal">\
	<div class="modal-header"><button type="button" class="close" data-dismiss="modal">&times;</button><h3>' + l('%addDevicePopupTitle') + '</h3></div>\
	<form>\
  		<div class="modal-body">\
  			<label>' + l('%ActivationCode') + '</label>\
  			<fieldset class="control-group">\
  			<input type="text" class="code span3" data-bind="code" placeholder=' + l('%activationCodePlaceholder') + '>\
  			<p id="formatError" class="help-block">' + l('%activationCodeInvalidFormatError') + '</p>\
  			<p id="notconnectedError" class="help-block">' + l('%activationCodeNotConnectedError') + '</p>\
  			<p id="anotheraccountError" class="help-block">' + l('%activationCodeAnotherAccountError') + '</p>\
  			<p id="incorrectcodeError" class="help-block">' + l('%activationCodeIncorrectCodeError') + '</p>\
  			<p id="maxdeviceError" class="help-block">' + l('%activationCodeMaxDevCountError') + '</p>\
  			<p id="otherError" class="help-block">' + l('%activationCodeError') + '</p>\
  			</fieldset>\
  			<div class="ajax"><img src="img/ajax.gif"/></div>\
  		</div>\
		<div class="modal-footer">\
			<a href="#" class="btn" data-dismiss="modal">' + l('%Close') + '</a>\
    		<a href="#" class="btn btn-primary">' + l('%Add') + '</a>\
		</div>\
	</form>\
	</div>', {
	'create' : function() {
		this.view.$('div.ajax img').hide();
		this.view.$('fieldset p').hide();
	},
	'click a.btn-primary': function() {
		var code = this.model.get('code');
		this.view.$('fieldset p').hide();
		if (code == '' || code.match(/^([0-9A-Fa-f]{2}[:-]{0,1}){5}[0-9A-Fa-f]{2}$/) == null) {
			this.view.$('fieldset').addClass('error');
			this.view.$('#formatError').show();
			return;
		}
		this.view.$('fieldset').removeClass('error').removeClass('warning');
		this.view.$('#formatError').hide();
		this.loadNoId();
	},
	'persist:start': function(){
		this.view.$('div.ajax img').show();
	},
	'persist:stop': function(){
		this.view.$('div.ajax img').hide();
	},
	'persist:error': function(){
		this.view.$('#otherError').show();
		this.view.$('fieldset').addClass('error');
	},
	'persist:load:success': function(event, data){
		var code = this.model.get('code');
		this.model.reset();
		this.model.set({code: code});
		var status = data['status'];
		if (status == 'FAILED_NOTCONNECTED' || data['cameraActivationStatus'] ==  'FAILED_NOTCONNECTED') {		
			this.view.$('#notconnectedError').show();
			this.view.$('fieldset').addClass('error');
			return;	
		}
		if (status == 'FAILED_ANOTHERACCOUNTASSIGNED') {
			this.view.$('#anotheraccountError').show();
			this.view.$('fieldset').addClass('warning');
			return;
		}
		if (status == 'FAILED_CODEINCORRECT') {
			this.view.$('#incorrectcodeError').show();
			this.view.$('fieldset').addClass('error');
			return;
		}
		if (status == 'FAILED_REACHEDMAXDEVICECOUNT') {
			this.view.$('#maxdeviceError').show();
			this.view.$('fieldset').addClass('error');
			return;
		}
		if (status != "SUCCESS") {
			this.view.$('#otherError').show();
			this.view.$('fieldset').addClass('error');
			return;
		}
		this.model.reset();
		$('#addDeviceModal').modal('hide');
		$('#addDeviceSuccessModal').modal('show');
		devicesContent.refresh();
	},
	'persist:error': function(){
		this.view.$('#otherError').show();
		this.view.$('fieldset').addClass('error');
	}
}).persist($$.adapter.restfulRemoteNASForGET, {collection:'/hm/ld/activate', cache:false});
$$.document.append(addDevice);
$('#addDeviceModal').on('hidden', function () {
	addDevice.view.$('div.ajax img').hide();
	addDevice.view.$('fieldset p').hide();
	addDevice.view.$('fieldset').removeClass('error').removeClass('warning');
	addDevice.model.reset();
}).on('shown', function() { addDevice.view.$('input.code').focus();});

var addDeviceSuccess = $$(infoPopupPrototype, {title: l("%Success"), text: l("%addDeviceSuccess")}, infoPopupPrototype.view.format,
						{'create' : function() {this.view.$().attr('id', 'addDeviceSuccessModal');}});
$$.document.append(addDeviceSuccess);

var renameDevice = $$({ldId: '', name: ''}, '<div class="modal hide" id="renameDeviceModal">\
	<div class="modal-header"><button type="button" class="close" data-dismiss="modal">&times;</button><h3>' + l('%renameDevicePopupTitle') + '</h3></div>\
  		<form>\
  		<div class="modal-body">\
  			<label>Name</label>\
  			<fieldset class="control-group">\
  			<input type="text" class="name span3" data-bind="name">\
  			<p id="errorRename" class="help-block">' + l('%renameDeviceError') + '</p>\
  			</fieldset>\
  			<div class="ajax"><img src="img/ajax.gif"/></div>\
  		</div>\
		<div class="modal-footer">\
			<a href="#" class="btn" data-dismiss="modal">' + l('%Cancel') + '</a>\
    		<a href="#" class="btn btn-primary">' + l('%Rename') + '</a>\
		</div>\
	</form>\
	</div>', {
	'create' : function() {
		this.view.$('div.ajax img').hide();
		this.view.$('fieldset p').hide();
	},
	'click a.btn-primary': function() {
		this.view.$('div.ajax img').show();
		var settings = this.model.get('settings');
		settings['name'] = this.model.get('name');
		delete settings['home']; //FIXME
		delete settings['pan'];
		delete settings['tilt'];
		delete settings['zoom'];
		delete settings['illumination'];
		delete settings['motionDetection'];
		delete settings['audioDetection'];
		delete settings['ledcontrol'];
		delete settings['privacyButtonControl'];
		delete settings['icon'];
		$.ajax({
		type: "PUT",
		contentType: 'application/json',
		data: JSON.stringify(settings),
		url: "/app/hm/ld/" + this.model.get('ldId') + '/settings',
		cache: false,
		success: function(data) {
			if (data['status'] != 'SAVED') {
				renameDevice.view.$('div.ajax img').hide();
				renameDevice.view.$('fieldset').addClass('error');
				renameDevice.view.$("#errorRename").show();				
				return;
			}
			$('#renameDeviceModal').modal('hide');
			devicesContent.refresh();
		},
		error: function() {
			renameDevice.view.$('div.ajax img').hide();
			renameDevice.view.$('fieldset').addClass('error');
			renameDevice.view.$("#errorRename").show();	
		}});
	}
});
$$.document.append(renameDevice);
$('#renameDeviceModal').on('hidden', function () {
	renameDevice.view.$('div.ajax img').hide();
	renameDevice.view.$('fieldset p').hide();
	renameDevice.view.$('fieldset').removeClass('error');
	renameDevice.model.reset();
}).on('shown', function() { renameDevice.view.$('input.name').focus();});

var removeDevice = $$(yesNoPopupPrototype, {ldId: '', title: l("%removeDevicePopupTitle"), text: l("%AreYouSure")}, yesNoPopupPrototype.view.format, {
	'create' : function() {
		this.view.$().attr('id', 'removeDeviceModal');
	},
	'click a.btn-primary': function() {
		$.ajax({
		type: "DELETE",
		url: "/app/hm/ld/" + this.model.get('ldId'),
		cache: false,
		success: function(data) {
			if (data['status'] != 'OK') {
				errorMsg.show(l("%serverError"));
				return;
			}
			$('#removeDeviceModal').modal('hide');
			$('#removeDeviceSuccessModal').modal('show');
			devicesContent.refresh();
		},
		error: function() {
			errorMsg.show(l("%serverError"));
		}});
	}
});
$$.document.append(removeDevice);

var removeDeviceSuccess = $$(infoPopupPrototype, {title: l("%Success"), text: l("%removeDeviceSuccess")}, infoPopupPrototype.view.format,
						{'create' : function() {this.view.$().attr('id', 'removeDeviceSuccessModal');}});
$$.document.append(removeDeviceSuccess);

/************************************
*
* Folder/file popups 
*
*
*/

var addNewFolder = $$({name: ''}, '<div class="modal hide" id="addNewFolderModal">\
	<div class="modal-header"><button type="button" class="close" data-dismiss="modal">&times;</button><h3>' + l('%addFolderPopupTitle') + '</h3></div>\
  		<form>\
  		<div class="modal-body">\
  			<label>' + l('%addFolderPopupInfo') + '</label>\
  			<fieldset class="control-group">\
  			<input type="text" class="name span3" data-bind="name">\
  			<p id="errorAddFolderEmptyName" class="help-block">' + l('%addFolderPlaceholder') + '</p>\
  			<p id="errorAddFolder" class="help-block">' + l('%addFolderError') + '</p>\
  			<p id="errorAddFolderExists" class="help-block">' + l('%addFolderExistsError') + '</p>\
  			</fieldset>\
  			<div class="ajax"><img src="img/ajax.gif"/></div>\
  		</div>\
		<div class="modal-footer">\
			<a href="#" class="btn" data-dismiss="modal">' + l('%Cancel') + '</a>\
    		<a href="#" class="btn btn-primary">' + l('%Add') + '</a>\
		</div>\
	</form>\
	</div>', {
	'create' : function() {
		this.view.$('div.ajax img').hide();
		this.view.$('fieldset p').hide();
	},
	'click a.btn-primary': function() {
		this.view.$('fieldset p').hide();
		var name = this.model.get('name');
		if (name == '') {
			this.view.$('#errorAddFolderEmptyName');
			return;
		}
		this.view.$('div.ajax img').show();
		$.ajax({
		type: "GET",
		dataType: "jsonp",
		url: ((isHttps)?"https://":"http://") + currentDeviceAddress + '/' + currentPath.toString().replace(/,/g,'/') + '/' + name + '?action=mkdir' + sessionParam + deviceParams,
		cache: false,
		success: function(data) {
			if (!data || data['hc'] != 200) {
				addNewFolder.view.$('div.ajax img').hide();
				addNewFolder.view.$('fieldset').addClass('error');
				if (data && data['hc'] == 409) {
					addNewFolder.view.$("#errorAddFolderExists").show();
				} else {
					addNewFolder.view.$("#errorAddFolder").show();	
				}			
				return;
			}
			$('#addNewFolderModal').modal('hide');
			folderContent.refresh();
		},
		error: function(x,e) {
			addNewFolder.view.$('div.ajax img').hide();
			addNewFolder.view.$('fieldset').addClass('error');
			addNewFolder.view.$("#errorAddFolder").show();	
		}});
	}
});
$$.document.append(addNewFolder);
$('#addNewFolderModal').on('hidden', function () {
	addNewFolder.view.$('div.ajax img').hide();
	addNewFolder.view.$('fieldset p').hide();
	addNewFolder.view.$('fieldset').removeClass('error');
	addNewFolder.model.reset();
}).on('shown', function() { addNewFolder.view.$('input.name').focus();});

var removeFile = $$(yesNoPopupPrototype, {name: '', title: l("%removeFilePopupTitle"), text: l("%AreYouSure")}, yesNoPopupPrototype.view.format, {
	'create' : function() {
		this.view.$().attr('id', 'removeFileModal');
	},
	'click a.btn-primary': function() {
		$.ajax({
			type: "GET",
			dataType: "jsonp",
			url: ((isHttps)?"https://":"http://") + currentDeviceAddress + '/' + currentPath.toString().replace(/,/g,'/') + '/' + this.model.get('name') + '?action=unlink' + sessionParam + deviceParams,
			cache: false,
			success: function(data) {
				if (!data || data['hc'] != 200) {
					errorMsg.show(l("%serverError"));
					return;
				}
				$('#removeFileModal').modal('hide');
				$('#removeFileSuccessModal').modal('show');
				folderContent.refresh();
			},
			error: function() {
				errorMsg.show(l("%serverError"));
			}
		});
	}
});
$$.document.append(removeFile);

var removeFileSuccess = $$(infoPopupPrototype, {title: l("%Success"), text: l("%fileRemoveSuccess")}, infoPopupPrototype.view.format,
						{'create' : function() {this.view.$().attr('id', 'removeFileSuccessModal');}});
$$.document.append(removeFileSuccess);


var removeFolder = $$(yesNoPopupPrototype, {name: '', title: l("%removeFolderPopupTitle"), text: l("%AreYouSure")}, yesNoPopupPrototype.view.format, {
	'create' : function() {
		this.view.$().attr('id', 'removeFolderModal');
	},
	'click a.btn-primary': function() {
		$.ajax({
			type: "GET",
			dataType: "jsonp",
			url: ((isHttps)?"https://":"http://") + currentDeviceAddress + '/' + currentPath.toString().replace(/,/g,'/') + '/' + this.model.get('name') + '?action=rmdir&recursive=1' + sessionParam + deviceParams,
			cache: false,
			success: function(data) {
				if (!data || data['hc'] != 200) {
					errorMsg.show(l("%serverError"));
					return;
				}
				$('#removeFolderModal').modal('hide');
				$('#removeFolderSuccessModal').modal('show');
				folderContent.refresh();
			},
			error: function() {
				errorMsg.show(l("%serverError"));
			}
		});
	}
}).persist($$.adapter.restfulRemoteNASDevice, {collection:'', cache:false});
$$.document.append(removeFolder);

var removeFolderSuccess = $$(infoPopupPrototype, {title: l("%Success"), text: l("%folderRemoveSuccess")}, infoPopupPrototype.view.format,
						{'create' : function() {this.view.$().attr('id', 'removeFolderSuccessModal');}});
$$.document.append(removeFileSuccess);

var renameFileFolder = $$({oldName: '', newName: ''}, '<div class="modal hide" id="renameFileFolderModal">\
	<div class="modal-header"><button type="button" class="close" data-dismiss="modal">&times;</button><h3>' + l('%Rename') + '</h3></div>\
  		<form>\
  		<div class="modal-body">\
  			<label>' + l('%Name') + '</label>\
  			<fieldset class="control-group">\
  			<input type="text" class="name span3" data-bind="newName">\
  			<p id="errorRenameExists" class="help-block">' + l('%renameFileFolderExistsError') + '</p>\
  			<p id="errorRename" class="help-block">' + l('%renameFileFolderError') + '</p>\
  			</fieldset>\
  			<div class="ajax"><img src="img/ajax.gif"/></div>\
  		</div>\
		<div class="modal-footer">\
			<a href="#" class="btn" data-dismiss="modal">' + l('%Cancel') + '</a>\
    		<a href="#" class="btn btn-primary">' + l('%Rename') + '</a>\
		</div>\
	</form>\
	</div>', {
	'create' : function() {
		this.view.$('div.ajax img').hide();
		this.view.$('fieldset p').hide();
	},
	'click a.btn-primary': function() {
		this.view.$('div.ajax img').show();
		var urlPart = ((isHttps)?"https://":"http://") + currentDeviceAddress + '/' + currentPath.toString().replace(/,/g,'/') + '/';
		var path = currentPath.slice(1, currentPath.length);
		$.ajax({
		type: "GET",
		dataType: 'jsonp',
		url: urlPart + this.model.get('oldName')
			+ '?action=rename&to=' + path.toString().replace(/,/g,'/') + '/' + this.model.get('newName') + '&replace=0' + sessionParam + deviceParams,
		cache: false,
		success: function(data) {
			if (!data || data['hc'] != 200) {
				renameFileFolder.view.$('div.ajax img').hide();
				renameFileFolder.view.$('fieldset').addClass('error');
				if (data && data['hc'] == 409) {
					renameFileFolder.view.$("#errorRenameExists").show();
				} else {
					renameFileFolder.view.$("#errorRename").show();
				}			
				return;
			}
			$('#renameFileFolderModal').modal('hide');
			folderContent.refresh();
		},
		error: function() {
			renameFileFolder.view.$('div.ajax img').hide();
			renameFileFolder.view.$('fieldset').addClass('error');
			renameFileFolder.view.$("#errorRename").show();	
		}});
	}
});
$$.document.append(renameFileFolder);
$('#renameFileFolderModal').on('hidden', function () {
	renameFileFolder.view.$('div.ajax img').hide();
	renameFileFolder.view.$('fieldset p').hide();
	renameFileFolder.view.$('fieldset').removeClass('error');
	renameFileFolder.model.reset();
}).on('shown', function() { renameFileFolder.view.$('input.name').focus();});

var moveTreeElement = $$({path: '', name: '', level: 1},
	'<li class="treeElement"><span class="spacer"/><i class="tree-button icon-plus-sign"></i><span class="tree-name" data-bind="name"/><div class="ajax"><img src="img/ajax_small.gif"/></div>\<ul/></li>', {
		'click i.tree-button' : function(event) {
			var searchedObject = this.view.$('> i.tree-button');
			if (searchedObject[0] != event['currentTarget']) return; //ignore events from children
			if (searchedObject.hasClass('icon-plus-sign')) {
				//unfold
				this.view.$('> ul').show();
				searchedObject.removeClass('icon-plus-sign');
				searchedObject.addClass('icon-minus-sign');
				if (!this.view.$('> ul').hasClass('loaded')) {
					this.view.$('> ul').addClass('loaded');
					//load content
					var path = this.model.get('path') + '/' + this.model.get('name');
					var self = this;
					this.view.$('> div.ajax').show();
					$.ajax({
						type: "GET",
						dataType: "jsonp",
						url: ((isHttps)?"https://":"http://") + currentDeviceAddress + '/' + currentPath[0] + '/' + path + '/' + readAction + sessionParam + deviceParams,
						cache: false,
						success: function(data) {
							self.view.$('> div.ajax').hide();
							if (data['hc'] == 200) {
								var entriesNum = data['entries'].length;
								if (entriesNum > 0) {
									for(var i = 0; i < entriesNum; i++) {
										var n = data['entries'][i]['n'];
										if (data['entries'][i]['t'] == 4) {
											self.append($$(moveTreeElement, {name: n, path: path, level: self.model.get('level') + 1}), '> ul');
										}
									}
								}
							} else {
								errorMsg.show(l("%serverError"));
							}
						},
						error: function() {
							self.view.$('> div.ajax').hide();
							errorMsg.show(l("%serverError"));
						}
					});
				}
			} else {
				//fold
				//searchedObject.removeClass('icon-minus-sign').addClass('icon-plus-sign');
				this.view.$('i.tree-button').removeClass('icon-minus-sign').addClass('icon-plus-sign');
				this.view.$('ul').hide();
			}
		},
		'click span.tree-name' : function(event) {
			var searchedObject = this.view.$('> span.tree-name');
			if (searchedObject[0] != event['currentTarget']) return; //ignore events from children
			$('li.treeElement').removeClass('selected');
			$('span.diskTreeElement').removeClass('selected');
			searchedObject.parent().addClass('selected');
			moveFileFolder.model.set({newPath: this.model.get('path') + this.model.get('name') + '/'});
		},
		'create' : function() {
			var width = 10*this.model.get('level');
			this.view.$('> span.spacer').attr('style', 'width: ' + width + 'px');
		}
});

var moveFileFolder = $$({device: '', disk: '', name: '', newPath: ''}, '<div class="modal hide" id="moveFileFolderModal">\
	<div class="modal-header"><button type="button" class="close" data-dismiss="modal">&times;</button><h3>' + l('%movePopupTitle') + '</h3></div>\
  		<div class="modal-body">\
  			<div class="ajax"><img src="img/ajax.gif"/></div>\
  			<div class="moveTreeWrapper">\
  				<span class="diskTreeElement" data-bind="disk"/>\
  				<ul class="moveTree"/>\
  			</div>\
  			<p class="errorInfo" id="errorMove">' + l('%moveError') + '</p>\
  			<p class="errorInfo" id="errorMoveExists">' + l('%moveExistsError') + '</p>\
  		</div>\
		<div class="modal-footer">\
			<a href="#" class="btn" data-dismiss="modal">' + l('%Cancel') + '</a>\
    		<a href="#" class="btn btn-primary">' + l('%Move') + '</a>\
		</div>\
	</form>\
	</div>', {
	'create' : function() {
		this.view.$('div.ajax img').hide();
		this.view.$('p').hide();
	},
	'click span.diskTreeElement' : function(event) {
		this.view.$('li.treeElement').removeClass('selected');
		this.view.$('span.diskTreeElement').addClass('selected');
		moveFileFolder.model.set({newPath: '/'});
	},
	'click a.btn-primary': function() {
		this.view.$('div.ajax img').show();
		var urlPart = ((isHttps)?"https://":"http://") + currentDeviceAddress + '/' + currentPath.toString().replace(/,/g,'/') + '/';
		$.ajax({
		type: "GET",
		dataType: 'jsonp',
		url: urlPart + this.model.get('name')
			+ '?action=rename&to=' + this.model.get('newPath') + this.model.get('name') + '&replace=0' + sessionParam + deviceParams,
		cache: false,
		success: function(data) {
			if (!data || data['hc'] != 200) {
				moveFileFolder.view.$('div.ajax img').hide();
				if (data && data['hc'] == 409) {
					moveFileFolder.view.$("#errorMoveExists").show();
				} else {
					moveFileFolder.view.$("#errorMove").show();
				}			
				return;
			}
			$('#moveFileFolderModal').modal('hide');
			folderContent.refresh();
		},
		error: function() {
			moveFileFolder.view.$('div.ajax img').hide();
			moveFileFolder.view.$("#errorMove").show();	
		}});
	}
});
$$.document.append(moveFileFolder);
$('#moveFileFolderModal').on('shown', function () {
	moveFileFolder.view.$('div.ajax img').hide();
	//show root directory if disk or device has changed
	if (currentDeviceName != moveFileFolder.model.get('device') || currentPath[0] != moveFileFolder.model.get('disk')) {
		moveFileFolder.model.set({device: currentDeviceName, disk: currentPath[0]});
		$.ajax({
			type: "GET",
			dataType: "jsonp",
			url: ((isHttps)?"https://":"http://") + currentDeviceAddress + '/' + currentPath[0] + '/' + readAction + sessionParam + deviceParams,
			cache: false,
			success: function(data) {
				if (data['hc'] == 200) {
					var entriesNum = data['entries'].length;
					if (entriesNum > 0) {
						for(var i = 0; i < entriesNum; i++) {
							var n = data['entries'][i]['n'];
							if (data['entries'][i]['t'] == 4) {
								moveFileFolder.append($$(moveTreeElement, {name: n, path: ''}), 'ul.moveTree');
							}
						}
					}
				} else {
					errorMsg.show(l("%serverError"));
				}
			},
			error: function() {
				errorMsg.show(l("%serverError"));
			}
		});
	}
});
/************************************
*
* Login Content 
*
*
*/
var loginForm = $$({}, '<div id="login"></div>', '& {margin-top:20px;}');

var postInput = $$({
	model: {username: '', password: '', rememberMe: false},
	view: {
		format:
		'<div id="loginForm">\
			<form class="form-horizontal" action="">\
				<fieldset>\
					<legend>' + l('%Login') +':</legend>\
					<div class="email control-group">\
						<label class="control-label" for="username-input">' + l('%Email') +':</label>\
						<div class="controls">\
							<input id="username-input" type="text" class="input-xlarge" data-bind="username" placeholder="' + l('%emailPlaceholder') +'">\
							<p class="help-inline" id="loginEmailInvalidHelp">E-mail is invalid</span>\
						</div>\
					</div>\
					<div class="password control-group">\
						<label class="control-label" for="pwd-input">' + l('%Password') +':</label>\
						<div class="controls">\
							<input type="password" id="pwd-input" class="input-xlarge" placeholder="' + l('%passwordPlaceholder') +'">\
							<p class="help-inline" id="loginPasswordEmptyHelp">' + l('%passwordEmptyError') +'</span>\
						</div>\
					</div>\
					<div class="control-group">\
						<label class="control-label" for="optionsCheckbox"></label>\
						<div class="controls">\
							<label class="checkbox">\
								<input type="checkbox" id="rememberMe" data-bind="rememberMe">' + l('%Keep_me') +'\
							</label>\
						</div>\
					</div>\
					<div class="all control-group">\
						<p class="help-inline controls" id="loginFailedHelp">' + l('%loginError') +'</span>\
					</div>\
					<div class="form-actions">\
						<a id="forgot"  data-toggle="modal" href="#forgotPasswordModal" >' + l('%Forgot_password') +'</a>\
						<a id="registr" class="btn">' + l('%Register') +'</a>\
						<a id="post" class="btn btn-primary">' + l('%Login') +'</a>\
					</div>\
				</fieldset>\
			</form>\
		</div>'
	},
	controller: {
		'create' : function() {
			this.view.$('fieldset p').hide();
		},
		'click #registr': function() {
			$("#login").hide();
			Page.pushRegister();
		},
		'click #post': function() {
			this.view.$('div').removeClass('error');
			this.view.$('fieldset p').hide();
			if (this.model.get('username').length === 0 ) {
				this.view.$('div.email').addClass('error');
				this.view.$("#loginEmailInvalidHelp").show();	
				return;
			}
			var value = document.getElementById('pwd-input').value; //workaround because data-bind doesn't work for password input
			this.model.set({password: value});
			if (this.model.get('password').length === 0 ) {
				this.view.$('div.password').addClass('error');
				this.view.$("#loginPasswordEmptyHelp").show();
				return;
			}
			currentUsername = this.model.get('username');
			this.save(); // creates a new record since there is no model id
		},
		'persist:save:success': function(event, data) {
			this.model.reset();
			document.getElementById('pwd-input').value = "";
			this.view.sync();
			if (data['status'] == "OK") {
				$.cookie('JSESSIONID', data['sessionId'], {path: '/', domain: ''}); //path and domain are necessary for chrome!!!
				if (data['rememberMeCookie'] != null) {
					$.cookie('REMEMBERME', data['rememberMeCookie'], { expires: 365 });
				}
				devicesContent.refresh();
				account.model.set({email: currentUsername});
				account.view.$().show();
				$("#login").hide();
				Page.pushHome();
			} else {
				currentUsername = '';
				this.view.$('div.all').addClass('error');
				this.view.$("#loginFailedHelp").show();
			}
		},
		'persist:error': function() {
			errorMsg.show(l("%serverError"));
		}
	}
}).persist($$.adapter.restfulRemoteNAS, {collection:'/hm/user/authenticate', cache:false});
$$.document.prepend(loginForm, $('#app'));
loginForm.append(postInput);

/************************************
*
* Forgot password 
*
*
*/

var forgotPassword = $$({email: ''}, '<div class="modal hide" id="forgotPasswordModal">\
	<div class="modal-header"><button type="button" class="close" data-dismiss="modal">&times;</button><h3>' + l('%forgotPasswordPopupTitle') +'</h3></div>\
  		<form>\
  		<div class="modal-body">\
  			<label>' + l('%forgotPasswordPopupInfo') +'</label>\
  			<fieldset class="control-group">\
  			<input type="text" class="name span3" data-bind="email">\
  			<p id="errorForgot" class="help-block">' + l('%forgotPasswordError') +'</p>\
  			<p id="errorForgotValidation" class="help-block">' + l('%forgotPasswordEmailInvalidError') +'</p>\
  			<p id="errorForgotIncorrect" class="help-block">' + l('%forgotPasswordEmailIncorrectError') +'</p>\
  			</fieldset>\
  			<div class="ajax"><img src="img/ajax.gif"/></div>\
  		</div>\
		<div class="modal-footer">\
			<a href="#" class="btn" data-dismiss="modal">' + l('%Cancel') +'</a>\
    		<a href="#" class="btn btn-primary">' + l('%OK') +'</a>\
		</div>\
	</form>\
	</div>', {
	'create' : function() {
		this.view.$('div.ajax img').hide();
		this.view.$('fieldset p').hide();
	},
	'click a.btn-primary': function() {
		var email = this.model.get('email');
		if (!email || email.match(/^\s*[\w\-\+_]+(\.[\w\-\+_]+)*\@[\w\-\+_]+\.[\w\-\+_]+(\.[\w\-\+_]+)*\s*$/) == null) {
			this.view.$('div.ajax img').hide();
			this.view.$('fieldset').addClass('error');
			this.view.$("#errorForgotValidation").show();	
			return;	
		}
		this.view.$('div.ajax img').show();
		$.ajax({
		type: "GET",
		contentType: 'application/json',
		url: "/app/hm/user/forgotPassword?email=" + email,
		cache: false,
		success: function(data) {
			forgotPassword.view.$('div.ajax img').hide();
			if (!data || data['status'] == 'ERROR') {
				forgotPassword.view.$('fieldset').addClass('error');
				forgotPassword.view.$("#errorForgot").show();				
				return;
			}
			if (data['status'] == 'INCORRECTEMAIL') {
				forgotPassword.view.$('fieldset').addClass('error');
				forgotPassword.view.$("#errorForgotIncorrect").show();
				return;
			}
			$('#forgotPasswordModal').modal('hide');
			$('#forgotPasswordSuccessModal').modal('show');
		},
		error: function() {
			forgotPassword.view.$('div.ajax img').hide();
			forgotPassword.view.$('fieldset').addClass('error');
			forgotPassword.view.$("#errorForgot").show();	
		}});
	}
});
$$.document.append(forgotPassword);
$('#forgotPasswordModal').on('hidden', function () {
	forgotPassword.view.$('div.ajax img').hide();
	forgotPassword.view.$('fieldset p').hide();
	forgotPassword.view.$('fieldset').removeClass('error');
	forgotPassword.model.reset();
}).on('shown', function() { forgotPassword.view.$('input.name').focus();});

var forgotPasswordSuccess = $$(infoPopupPrototype, {title: l('%Success'), text: l('%forgotPasswordSuccessInfo')}, infoPopupPrototype.view.format,
						{'create' : function() {this.view.$().attr('id', 'forgotPasswordSuccessModal');}});
$$.document.append(forgotPasswordSuccess);


/************************************
*
* Registration Content 
*
*
*/
var registrationForm = $$({}, '<div id="registration"></div>', '& {margin-top:20px;}');
var regInput = $$({
	model: {username: '', firstname: '', lastname: '', email: '', password: ''},
	view: {
		format:
			'<div id="registrationForm">\
				<form class="form-horizontal" action="">\
					<fieldset>\
						<legend>' + l('%Registration') +'</legend>\
						<div class="email control-group">\
							<label class="control-label" for="email-input">' + l('%Email') +':</label>\
							<div class="controls">\
								<input id="email-input" type="text" class="input-xlarge" data-bind="email">\
								<span class="help-inline" id="emailInvalidHelp">' + l('%registrationEmailInvalidError') +'</span>\
								<span class="help-inline" id="emailTakenHelp">' + l('%registrationEmailTakenError') +'</span>\
							</div>\
						</div>\
						<div class="password control-group">\
							<label class="control-label" for="pwdreg-input">' + l('%Password') +':</label>\
							<div class="controls">\
								<input id="pwdreg-input" type="password" class="input-xlarge">\
								<span class="help-inline" id="passwordHelp">' + l('%registrationPasswordInvalidError') +'</span>\
							</div>\
						</div>\
						<div class="confirm control-group">\
							<label class="control-label" for="pwd-input2">' + l('%ConfirmPassword') +':</label>\
							<div class="controls">\
								<input id="pwd-input2" type="password" class="input-xlarge">\
								<span class="help-inline" id="passwordMatchHelp">' + l('%registrationPasswordMatchError') +'</span>\
							</div>\
						</div>\
						<div class="firstname control-group">\
							<label class="control-label" for="firstname-input">' + l('%FirstName') +':</label>\
							<div class="controls">\
								<input id="firstname-input" type="text" class="input-xlarge" data-bind="firstname">\
								<span class="help-inline" id="firstnameHelp">' + l('%registrationFirstNameInvalidError') +'</span>\
							</div>\
						</div>\
						<div class="lastname control-group">\
							<label class="control-label" for="lastname-input">' + l('%LastName') +'</label>\
							<div class="controls">\
								<input id="lastname-input" type="text" class="input-xlarge" data-bind="lastname">\
								<span class="help-inline" id="lastnameHelp">' + l('%registrationLastNameInvalidError') +'</span>\
							</div>\
						</div>\
						<div class="terms control-group">\
							<div class="controls">\
								<label class="checkbox">\
									<input type="checkbox" id="terms">' + l('%registrationAcceptTerms') +'\
								</label>\
								<span class="help-inline" id="termsHelp">' + l('%registrationAcceptTermsError') + '</span>\
							</div>\
						</div>\
						<div class="captcha control-group">\
							<div class="controls">\
								<img src="/app/captcha/captcha.jpeg"/><input tabindex="-1" class="btn" type="button" value="' + l('%registrationReload') + '">\
							</div>\
						</div>\
						<div class="captchaInput control-group">\
							<div class="controls">\
								<input id="captcha-input" type="text" class="input-medium">\
								<span class="help-inline" id="captchaHelp">' + l('%registrationCaptchaError') + '</span>\
								<p class="help-block">' + l('%registrationCaptchaInfo') + '</p>\
							</div>\
						</div>\
						<div class="all control-group">\
							<p id="registrationError" class="controls help-block">' + l('%registrationEmptyError') + '</p>\
						</div>\
						<div class="form-actions">\
							<a id="cancel" class="btn">' + l('%Cancel') + '</a>\
							<a id="registrBtn" class="btn btn-primary">' + l('%Register') + '</a>\
						</div>\
					</fieldset>\
				</form>\
			</div>'
	},
	controller: {
		'create': function() {
			$("#registrationError").hide();
			this.view.$("span.help-inline").hide();
		},
		'click div.captcha input.btn': function() {
			this.reloadCaptcha();
		},
		'click #registrBtn': function() {
			this.view.$('div').removeClass('error');
			this.view.$("span.help-inline").hide();
			var error = false;
			$("#registrationError").hide();
			
			if (this.model.get('firstname').length == 0 ) {
				error = true;
				this.view.$('div.firstname').addClass('error');
			}
			if (this.model.get('lastname').length == 0 ) {
				this.model.get('lastname') = true;
				this.view.$('div.lastname').addClass('error');
			}
			if (this.model.get('email').match(/^\s*[\w\-\+_]+(\.[\w\-\+_]+)*\@[\w\-\+_]+\.[\w\-\+_]+(\.[\w\-\+_]+)*\s*$/) == null) {
				error = true;
				this.view.$('div.email').addClass('error');
				this.view.$('#emailInvalidHelp').show();
			}
			var password = document.getElementById('pwdreg-input').value; //workaround because data-bind doesn't work for password input
			this.model.set({password: password});
			if (password.length === 0 ) {
				error = true;
				this.view.$('div.password').addClass('error');
			}
			var value = document.getElementById('pwd-input2').value;
			if (value.length === 0) {
				error = true;
				this.view.$('div.confirm').addClass('error');
			}
			if (password.length > 0 && value != password) {
				error = true;
				this.view.$('#passwordMatchHelp').show();
				this.view.$('div.confirm').addClass('error');
			}
			value = document.getElementById('terms').checked;
			if (!value) {
				error = true;
				this.view.$('div.terms').addClass('error');
				this.view.$('#termsHelp').show();
			}
			var captcha = document.getElementById('captcha-input').value;
			if (captcha.length == 0 ) {
				error = true;
				this.view.$('div.captcha').addClass('error');
			}
			
			if (!error) {
				this.model.set({username: this.model.get('email')});
				this.persist($$.adapter.restfulRemoteNAS, {collection:'/hm/user/register?captcha=' + captcha, cache:false});
				this.save();
			} else {
				this.view.$('div.all').addClass('error');
				$("#registrationError").show();	
				this.view.$('#username-input').focus();
			}
		},
		'click #cancel': function() {
			this.view.$('div').removeClass('error');
			this.view.$("span.help-inline").hide();
			Page.pushLogin();
			$("#registrationError").hide();
			document.getElementById('pwdreg-input').value = "";
			document.getElementById('pwd-input2').value = "";
			document.getElementById('captcha-input').value = "";
			$("#registration").hide();
			this.model.reset();
		},
		'persist:save:success': function(event, data) {
			this.model.set({password: ''});
			document.getElementById('pwdreg-input').value = "";
			document.getElementById('pwd-input2').value = "";
			document.getElementById('captcha-input').value = "";
			this.view.sync();
			var status = data['status'];
			if (status == "OK") {
				$("#registrationSuccessModal").modal('show');
				Page.pushLogin();
				Page.showLogin();
				$("#registration").hide();
				this.model.reset();
			} else {
				this.reloadCaptcha();
				if (status == "FAILED_CAPTCHAINVALID") {
					this.view.$('div.captchaInput').addClass('error');
					this.view.$('#captchaHelp').show();
					return;
				}
				if (status == "FAILED_USERNAMEINVALID") {
					this.view.$('div.username').addClass('error');
					this.view.$('#usernameHelp').show();
					return;
				}
				if (status == "FAILED_USERNAMETAKEN") {
					this.view.$('div.username').addClass('error');
					this.view.$('#usernameTakenHelp').show();
					return;
				}
				if (status == "FAILED_FIRSTNAMEINVALID") {
					this.view.$('div.firstname').addClass('error');
					this.view.$('#firstnameHelp').show();
					return;
				}
				if (status == "FAILED_LASTNAMEINVALID") {
					this.view.$('div.lastname').addClass('error');
					this.view.$('#lastnameHelp').show();
					return;
				}
				if (status == "FAILED_EMAILINVALID") {
					this.view.$('div.email').addClass('error');
					this.view.$('#emailInvalidHelp').show();
					return;
				}
				if (status == "FAILED_EMAILTAKEN") {
					this.view.$('div.email').addClass('error');
					this.view.$('#emailTakenHelp').show();
					return;
				}
				if (status == "FAILED_PASSWORDINVALID") {
					this.view.$('div.password').addClass('error');
					this.view.$('#passwordHelp').show();
					return;
				}
				errorMsg.show(l('%serverError'));
			}
		},
		'persist:error': function() {
			this.reloadCaptcha();
			errorMsg.show(l('%serverError'));
		}
	},
	// User-defined
	reloadCaptcha: function() {
		this.view.$('div.captcha img').attr('src', '/app/captcha/captcha.jpeg?reloadParam=' + new Date().getTime());
	}
}).persist($$.adapter.restfulRemoteNAS, {collection:'/hm/user/register', cache:false});
$$.document.prepend(registrationForm, $('#app'));
registrationForm.append(regInput);

var termsAndConditions = $$({},'<div id="termsAndConditionsModal" class="modal hide">\
		<div class="modal-header"><button type="button" class="close" data-dismiss="modal">&times;</button><h3>' + l('%TermsConditions') + '</h3></div>\
	  		<div class="modal-body"/>\
			<div class="modal-footer">\
	    		<a href="#" class="btn btn-primary" data-dismiss="modal">' + l('%Close') + '</a>\
			</div>\
		</div>'
);
$$.document.append(termsAndConditions);

$('#termsAndConditionsModal').on('shown', function() {
	if (!termsAndConditions.view.$("modal-body").html()) {
		var url = "/terms-and-conditions?mode=raw&lang=" + lang;
		termsAndConditions.view.$("div.modal-body").html("<iframe scrolling=\"auto\" frameBorder=\"1\""
                                        + "id=\"termsFrame\" src=\"" + url + "\" width=\"700px\" height=\"450px\"><p>"
                                        + "</iframe>");
	}
});

var registrationSuccess = $$(infoPopupPrototype, {title: l('%RegistrationSuccess'), text: l('%RegistrationSuccessInfo')},
							infoPopupPrototype.view.format,
							{ 'create' : function() {this.view.$().attr('id', 'registrationSuccessModal')}});
$$.document.append(registrationSuccess);


/************************************
 *
 * Cookies, logout
 *
 *
 */

var SessionManagement = {
	logout: function() {
		currentUsername = '';
		currentPath.length = 0;
		contentCollection = '';
		currentDeviceName = '';
		currentDeviceAddress = '';
		currentImages.length = 0;
		activeSortIndex = 0;
		activeSortDescending = true;
		this.clearCookies();
		devicesContent.view.$().hide();
		folderContent.view.$().hide();
		$("#main").hide();
		account.view.$().hide();
		Page.showNotLoggedIn();
	},
	clearCookies: function() {
		$.cookie("JSESSIONID", null);
		$.cookie("JSESSIONID", null, {path:'/', domain: ''});
		$.cookie("REMEMBERME", null);
	},
	getUserData: function() {
		$.ajax({
			type: "GET",
			contentType: 'application/json',
			url: "/app/hm/user",
			cache: false,
			success: function(data) {
				if (data && data['email']) {
					currentUsername = data['email'];
					account.model.set({email: data['email']});
					account.view.$().show();
					Page.goToCurrentState();
				} else {
					SessionManagement.logout();
				}
			},
			error: function() {
				SessionManagement.logout();
			}
		});
	},
	checkUser: function() {
		$.ajax({
			type: "GET",
			contentType: 'application/json',
			url: "/app/hm/user",
			cache: false,
			success: function(data) {
				if (!data || !data['email']) {
					SessionManagement.logout();
				}
			},
			error: function() {
				SessionManagement.logout();
			}
		});
	}
}


/************************************
*
* Check autologin 
*
*
*/
$("#registration").hide();
$("#login").hide();
$("#main").hide();
account.view.$().hide();


if($.cookie("JSESSIONID") != null) {
	SessionManagement.getUserData();
} else {
	if($.cookie("REMEMBERME") != null) {
		var rememberMeCheck = $$({
			  model: {rememberMeCookie: $.cookie("REMEMBERME")},
			  view: {format:'<div></div>'},
			  controller: {
			    'persist:save:success': function(event, data){
			      // reset model to initial state
			      this.model.reset();
			      //loading.destroy();
			      if (data['loggedIn'] == true) {
			    	  $.cookie('JSESSIONID', data['sessionId'], {path: '/', domain: ''});
			          if (data['rememberMeCookie'] != null) {
			        	  $.cookie('REMEMBERME', data['rememberMeCookie'], { expires: 365 });
			          }
			          SessionManagement.getUserData();
			      } else {
			      		SessionManagement.clearCookies();
			      		Page.showNotLoggedIn();
			      }
			    },
			    'persist:error': function(){
			      errorMsg.show(l('%serverError'));
			      Page.showNotLoggedIn();
			    }
			  }
		}).persist($$.adapter.restfulRemoteNAS, {collection:'/hm/user/check', cache:false});
		$$.document.append(rememberMeCheck, $('#app'));
		//rememberMeCheck.append(loading);
		rememberMeCheck.save();
	} else {
		Page.showNotLoggedIn();
	}
}

$(window).focus(function() {
   if ($.cookie('JSESSIONID') == null) {
   		if (!$("#registration").is(':visible')) {
			SessionManagement.logout();
		}
	} else {
		SessionManagement.checkUser();
	}
});

window.onresize=Page.resized;
Page.resized();
