<?

class Emailtemplates extends MY_Model
{
	
    function __construct()
    {
        parent::__construct();
    }
	
	function get($where = null, $offset = null, $singleRow = false, $countOnly = false) {
		$this->db->from('emailtemplate e')
			-> order_by("e.emailcode"); 
		$result = $this->getResult($where, $offset, $singleRow, $countOnly);
		return $result;
	}
	
	function prepareRow(&$row) {
		$row['body'] = $this->getTextByDB($row['body']);
		$row['body_html'] = $this->getTextByDB($row['body_html']);
	}
	
	function check($emailtemplate_id) {
		$emailtemplate = null;
		if ($emailtemplate_id) {
			$emailtemplate = $this->get(array('emailtemplate_id' => $emailtemplate_id), null, true);
			if (!$emailtemplate) {
				$this->session->set_flashdata('error', 'Selected email template not found.');
			}
		} else {
			$this->session->set_flashdata('error', 'No email template selected.');
		}
		return $emailtemplate;
	}
	
	function edit ($emailtemplate, $data) {
		$data = array(
			'subject' => $data['subject'],
			'body' => $data['body'],
			'body_html' => $data['body_html']
		);
		$this->db->update('emailtemplate', $data, array('emailtemplate_id' => $emailtemplate['emailtemplate_id']));
		$this->session->set_flashdata('message', 'Email template edited.');
	}
}
