<?

function now() {
	return date(DATETIME_FORMAT);
}


function to_date($timestamp) {
	if ($timestamp !== null && $timestamp !== '')
		return date(DATETIME_FORMAT,$timestamp);
	else
		return $timestamp;
}

function convert_datetime($dateStr, $fromFormat, $toFormat) {
	if ($dateStr) {
		$date = DateTime::createFromFormat($fromFormat, $dateStr);
		$dateStr = $date->format($toFormat);
	}
	return $dateStr;
}

function from_oracle_date($dateStr) {
	$dateStr = strtolower($dateStr);
	return convert_datetime($dateStr, ORACLE_DATE_FORMAT, DATE_FORMAT);
}

function from_oracle_datetime($dateStr) {
	$dateStr = strtolower($dateStr);
	return convert_datetime($dateStr, ORACLE_DATETIME_FORMAT, DATETIME_FORMAT);
}

function datetime_to_oracle($dateStr) {
	$dateStr = strtoupper($dateStr);
	return convert_datetime($dateStr, DATETIME_FORMAT, ORACLE_DATETIME_FORMAT);
}

function date_to_oracle($dateStr) {
	$dateStr = strtoupper($dateStr);
	return convert_datetime($dateStr, DATE_FORMAT, ORACLE_DATE_FORMAT);
}

function my_form_hidden($name, $value = '', $id = false)
{
    return '<input type="hidden" id="'.($id ? $id : $name).'" name="'.$name.'" value="'.form_prep($value).'" />';
}

function is_mac($text) {
	return preg_match('/^([0-9A-F]{2}[:-]){5}([0-9A-F]{2})$/', $text);
}

function bytes_to_mb($bytes) {
	return round($bytes/(1024*1024),2);
}

function has_prefix_from_array($text, $array) {
	foreach($array as $el) {
		if (strpos($text, $el) === 0)
			return true;
	}
	return false;
}

function msg_to_string($msg) {
	return is_object($msg) || is_array($msg) ? print_r($msg, true) : $msg;
}

function my_btn ($id, $text, $class = 'btn', $disabled = false, $onclick = false) {
	return form_button(array_merge(array('id' => $id, 'content' => $text, 'class'=>$class), 
				($disabled ? array('disabled' => 'disabled') : array()),
				($onclick ? array('onclick' => $onclick) : array())
		));
}

function anchor_btn ($link, $text, $class = 'btn', $disabled = false) {
	return anchor($link, form_button(array_merge(array('content' => $text, 'class'=>$class), 
			($disabled ? array('disabled' => 'disabled') : array())))
		);
}
function confirm_anchor_btn ($link, $text, $question, $class = 'btn', $disabled = false) {
	return anchor($link, form_button(array_merge(array('content' => $text, 'class'=>$class), 
			($disabled ? array('disabled' => 'disabled') : array()))),
			"onclick=\"return confirm('$question')\""
		);
}

function read_clob($field) {
    return $field->read($field->size());
}
