<?

class User extends MY_Controller {
		
	protected $model = 'users';
	protected $controller = 'user';
	protected $fields = array('email', 'log_conf', 'firstname', 'lastname', 'address', 'town', 'zip_code', 
			'state', 'country', 'language', 'mailing');
	protected $search_criteria = array('username', 'name', 'email', 'createdFrom', 'createdTo', 'product', 'deleted', 'non_activated');
	protected $unauthorized = array('login','logout');
	protected $requireRestAuthorization = array('edit', 'loginAs', 'logout');
	protected $requireRole = array('loginAs' => 'admin');


    function __construct()
    {
        parent::__construct();
        
    }
    
    function login()
    {
        if($this->input->post('submit'))
        {
        	$login = $this->input->post('username');
			$password = $this->input->post('password');  
	        if (!$this->form_validation->run('login')) {
	            $this->session->set_flashdata('error', 'You must type username and password to log in.');
	        } else if ($this->users->login($login, $password)) {
				redirect('');
			}
			redirect('user/login');
		}
		$data['title'] = 'Login';
		$data['content'] = $this->load->view('user/login', $data, true);
    	$this->load->view('index', $data);
    }
	
	function logout()
	{
        $this->users->logout();
		redirect('user/login');
	}
	
	function index($offset = 0) {
		$this->_index($offset);
	}
	
	function search($offset = 0) {
		$this->_search($offset);
	}
	
	function show($user_id = 0, $showDeleted = 0) {
		$this->session->set_userdata("user_show_deleted_devices", $showDeleted);
		$this->_prepareAndShow($user_id);
	}
	
	
	function activate ($user_id = 0) {
		$this->_prepareAndShow($user_id, 'activate');
	}
	
	function delete ($user_id = 0) {
		$this->_prepareAndShow($user_id, 'delete');
	}
	
	function undelete ($user_id = 0) {
		$this->_prepareAndShow($user_id, 'undelete');
	}
	
	function purge ($user_id = 0) {
		if ($user = $this->users->check($user_id)) {
			$this->users->purge($user_id);
		}
		redirect('user/index');
	}
	function edit($user_id = 0) {
		$ok = true;
		if ($this->input->post('password')) {
			$password = $this->input->post('password');
			$ok = $this->users->changePassAsAdmin($user_id, $password);
		}
		if ($ok)
			$this->_edit($user_id);
		else
			$this->_show($user_id);
	}
	
	function loginAs ($user_id) {
		$this->_ajax($user_id, 'loginAs');
	}
}