/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.worker;

import java.util.HashSet;
import java.util.Set;
import org.gearman.client.GearmanIOEventListener;
import org.gearman.client.GearmanJobResult;
import org.gearman.client.GearmanJobResultImpl;
import org.gearman.common.GearmanPacket;
import org.gearman.common.GearmanPacketImpl;
import org.gearman.common.GearmanPacketMagic;
import org.gearman.common.GearmanPacketType;
import org.gearman.util.ByteUtils;
import org.gearman.worker.GearmanFunction;

public abstract class AbstractGearmanFunction
implements GearmanFunction {
    protected final String name;
    protected Object data;
    protected byte[] jobHandle;
    protected Set<GearmanIOEventListener> listeners = new HashSet<GearmanIOEventListener>();

    public AbstractGearmanFunction() {
        this(null);
    }

    public AbstractGearmanFunction(String name) {
        this.jobHandle = new byte[0];
        this.name = name == null ? this.getClass().getCanonicalName() : name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public void setJobHandle(byte[] handle) throws IllegalArgumentException {
        if (handle == null) {
            throw new IllegalArgumentException("handle can not be null");
        }
        if (handle.length == 0) {
            throw new IllegalArgumentException("handle can not be empty");
        }
        this.jobHandle = new byte[handle.length];
        System.arraycopy(handle, 0, this.jobHandle, 0, handle.length);
    }

    @Override
    public byte[] getJobHandle() {
        byte[] rt = new byte[this.jobHandle.length];
        System.arraycopy(this.jobHandle, 0, rt, 0, this.jobHandle.length);
        return rt;
    }

    @Override
    public void registerEventListener(GearmanIOEventListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("listener can not be null");
        }
        this.listeners.add(listener);
    }

    @Override
    public void fireEvent(GearmanPacket event) throws IllegalArgumentException {
        if (event == null) {
            throw new IllegalArgumentException("event can not be null");
        }
        for (GearmanIOEventListener listener : this.listeners) {
            listener.handleGearmanIOEvent(event);
        }
    }

    public void sendData(byte[] data) {
        this.fireEvent(new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.WORK_DATA, GearmanPacketImpl.generatePacketData(this.jobHandle, data)));
    }

    public void sendWarning(byte[] warning) {
        this.fireEvent(new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.WORK_WARNING, GearmanPacketImpl.generatePacketData(this.jobHandle, warning)));
    }

    public void sendException(byte[] exception) {
        this.fireEvent(new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.WORK_EXCEPTION, GearmanPacketImpl.generatePacketData(this.jobHandle, exception)));
    }

    public void sendStatus(int denominator, int numerator) {
        this.fireEvent(new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.WORK_STATUS, GearmanPacketImpl.generatePacketData(this.jobHandle, ByteUtils.toUTF8Bytes(String.valueOf(numerator)), ByteUtils.toUTF8Bytes(String.valueOf(denominator)))));
    }

    public abstract GearmanJobResult executeFunction();

    @Override
    public GearmanJobResult call() {
        GearmanPacketImpl event = null;
        GearmanJobResult result = null;
        Exception thrown = null;
        try {
            result = this.executeFunction();
        }
        catch (Exception e) {
            thrown = e;
        }
        if (result == null) {
            String message;
            String string = message = thrown == null ? "function returned null result" : thrown.getMessage();
            if (message == null) {
                message = thrown.toString();
            }
            this.fireEvent(new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.WORK_EXCEPTION, GearmanPacketImpl.generatePacketData(this.jobHandle, message.getBytes())));
            result = new GearmanJobResultImpl(this.jobHandle, false, new byte[0], new byte[0], new byte[0], -1L, -1L);
        }
        event = result.jobSucceeded() ? new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.WORK_COMPLETE, GearmanPacketImpl.generatePacketData(this.jobHandle, result.getResults())) : new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.WORK_FAIL, this.jobHandle);
        this.fireEvent(event);
        return result;
    }
}

