/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.example;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.gearman.common.GearmanNIOJobServerConnection;
import org.gearman.worker.GearmanFunction;
import org.gearman.worker.GearmanWorkerImpl;

public class WorkerRunner {
    GearmanNIOJobServerConnection conn;
    List<Class<GearmanFunction>> functions;

    public WorkerRunner(String host, int port, List<Class<GearmanFunction>> funs) {
        this.conn = new GearmanNIOJobServerConnection(host, port);
        this.functions = new ArrayList<Class<GearmanFunction>>();
        this.functions.addAll(funs);
    }

    public void start() {
        GearmanWorkerImpl worker = new GearmanWorkerImpl();
        worker.addServer(this.conn);
        for (Class<GearmanFunction> fun : this.functions) {
            worker.registerFunction(fun);
        }
        worker.work();
    }

    public static void main(String[] args) {
        ArrayList<Class<GearmanFunction>> functions = new ArrayList<Class<GearmanFunction>>();
        if (args.length == 0) {
            WorkerRunner.usage(System.out);
            return;
        }
        String host = "127.0.0.1";
        int port = 4730;
        for (String arg : args) {
            if (arg.startsWith("-h")) {
                host = arg.substring(2);
                continue;
            }
            if (arg.startsWith("-p")) {
                port = Integer.parseInt(arg.substring(2));
                continue;
            }
            if (arg.charAt(0) == '-') {
                WorkerRunner.usage(System.out);
                continue;
            }
            try {
                Class<?> c = Class.forName(arg);
                if (!GearmanFunction.class.isAssignableFrom(c)) {
                    System.out.println(arg + " is not an instance of " + GearmanFunction.class.getCanonicalName());
                    WorkerRunner.usage(System.out);
                    return;
                }
                functions.add(c);
            }
            catch (ClassNotFoundException cfne) {
                System.out.println("Can not find function " + arg + " on class path");
                return;
            }
        }
        new WorkerRunner(host, port, functions).start();
    }

    public static void usage(PrintStream out) {
        String[] usage;
        for (String line : usage = new String[]{"usage: org.gearman.example.WorkerRunner [-h<host>] [-p<port>] functionName", "\t-h<host> - job server host", "\t-p<port> - job server port", "\n\tExample: java org.gearman.example.WorkerRunner org.gearman.example.ReverseFunction", "\tExample: java org.gearman.example.WorkerRunner -h127.0.0.1 -p4730 org.gearman.example.ReverseFunction"}) {
            out.println(line);
        }
    }
}

