/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.common;

import java.io.OutputStream;
import org.gearman.common.GearmanPacketMagic;
import org.gearman.common.GearmanPacketType;
import org.gearman.util.ByteArrayBuffer;
import org.gearman.util.ByteUtils;
import org.gearman.util.IOUtil;

public class GearmanPacketHeader {
    public static final int HEADER_LENGTH = 12;
    private GearmanPacketMagic magic;
    private GearmanPacketType type;
    private int dataLength;

    public GearmanPacketHeader(GearmanPacketMagic magic, GearmanPacketType type, int dataLength) {
        this.magic = magic;
        this.type = type;
        this.dataLength = dataLength;
    }

    public GearmanPacketHeader(byte[] bytes) {
        ByteArrayBuffer baBuff = new ByteArrayBuffer(bytes);
        this.magic = GearmanPacketMagic.fromBytes(baBuff.subArray(0, 4));
        int typeInt = ByteUtils.fromBigEndian(baBuff.subArray(4, 8));
        this.type = GearmanPacketType.get(typeInt);
        this.dataLength = ByteUtils.fromBigEndian(baBuff.subArray(8, 12));
    }

    public GearmanPacketMagic getMagic() {
        return this.magic;
    }

    public void setMagic(GearmanPacketMagic magic) {
        this.magic = magic;
    }

    public GearmanPacketType getType() {
        return this.type;
    }

    public void setType(GearmanPacketType type) {
        this.type = type;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public void write(OutputStream os) {
        IOUtil.write(os, this.magic.toBytes());
        IOUtil.write(os, this.type.toBytes());
        IOUtil.write(os, this.getDataSizeBytes());
    }

    private byte[] getDataSizeBytes() {
        return ByteUtils.toBigEndian(this.dataLength);
    }
}

