/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.client;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.gearman.client.GearmanJobStatus;
import org.gearman.common.GearmanException;
import org.gearman.common.GearmanPacket;
import org.gearman.common.GearmanPacketType;
import org.gearman.common.GearmanServerResponseHandler;
import org.gearman.util.ByteUtils;

public class GearmanJobStatusImpl
implements GearmanServerResponseHandler,
GearmanJobStatus {
    private static final String DESCRIPTION = "GearmanJobStatus";
    private boolean isRunning = false;
    private boolean isKnown = false;
    private long denominator = 0L;
    private long numerator = 0L;
    private boolean statusRequestCompleted = false;
    private static final Logger LOG = Logger.getLogger("org.gearman.session.logger");

    GearmanJobStatusImpl() {
    }

    @Override
    public long getDenominator() {
        return this.denominator;
    }

    @Override
    public long getNumerator() {
        return this.numerator;
    }

    @Override
    public boolean isKnown() {
        return this.isKnown;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void handleEvent(GearmanPacket repsonse) throws GearmanException {
        if (!repsonse.getPacketType().equals((Object)GearmanPacketType.STATUS_RES)) {
            throw new GearmanException("Dont know how to handle response of type " + repsonse);
        }
        this.isKnown = repsonse.getDataComponentValue(GearmanPacket.DataComponentName.KNOWN_STATUS)[0] != 48;
        this.isRunning = repsonse.getDataComponentValue(GearmanPacket.DataComponentName.RUNNING_STATUS)[0] != 48;
        try {
            this.numerator = Long.parseLong(ByteUtils.fromUTF8Bytes(repsonse.getDataComponentValue(GearmanPacket.DataComponentName.NUMERATOR)));
        }
        catch (NumberFormatException nfe) {
            LOG.log(Level.FINER, "numerator for response " + this + " has non-numeric value ");
        }
        try {
            this.denominator = Long.parseLong(ByteUtils.fromUTF8Bytes(repsonse.getDataComponentValue(GearmanPacket.DataComponentName.DENOMINATOR)));
        }
        catch (NumberFormatException nfe) {
            LOG.log(Level.FINER, "denominator for response " + this + " has non-numeric value ");
        }
        this.statusRequestCompleted = true;
    }

    @Override
    public boolean isDone() {
        return this.statusRequestCompleted;
    }

    public String toString() {
        return DESCRIPTION;
    }
}

