/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.client;

import org.gearman.common.GearmanException;
import org.gearman.common.GearmanPacket;
import org.gearman.common.GearmanPacketType;
import org.gearman.common.GearmanServerResponseHandler;

public class GearmanEchoResponseHandler
implements GearmanServerResponseHandler {
    private static final String DESCRIPTION = "GearmanEcho";
    byte[] data = null;
    boolean done = false;

    @Override
    public void handleEvent(GearmanPacket response) throws GearmanException {
        GearmanPacketType pt = response.getPacketType();
        if (!pt.equals((Object)GearmanPacketType.ECHO_RES)) {
            throw new GearmanException("Dont know how to handle response of type " + (Object)((Object)pt));
        }
        this.data = response.getData();
        this.done = true;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    public String toString() {
        return DESCRIPTION;
    }

    byte[] getResults() {
        byte[] ret = new byte[]{};
        if (this.done) {
            ret = new byte[this.data.length];
            System.arraycopy(this.data, 0, ret, 0, ret.length);
        }
        return ret;
    }
}

