/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.client;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gearman.client.GearmanClient;
import org.gearman.client.GearmanEchoResponseHandler;
import org.gearman.client.GearmanJob;
import org.gearman.client.GearmanJobImpl;
import org.gearman.client.GearmanJobStatus;
import org.gearman.client.GearmanJobStatusImpl;
import org.gearman.common.GearmanException;
import org.gearman.common.GearmanJobServerConnection;
import org.gearman.common.GearmanJobServerSession;
import org.gearman.common.GearmanNIOJobServerConnection;
import org.gearman.common.GearmanPacket;
import org.gearman.common.GearmanPacketImpl;
import org.gearman.common.GearmanPacketMagic;
import org.gearman.common.GearmanPacketType;
import org.gearman.common.GearmanServerResponseHandler;
import org.gearman.common.GearmanSessionEvent;
import org.gearman.common.GearmanSessionEventHandler;
import org.gearman.common.GearmanTask;
import org.gearman.util.ByteUtils;

public class GearmanClientImpl
implements GearmanClient,
GearmanSessionEventHandler {
    private static final String DESCRIPION_PREFIX = "GearmanClient";
    private static final Logger LOG = Logger.getLogger("org.gearman.client.logger");
    private static final String CLIENT_NOT_ACTIVE = "Client is not active";
    private final String DESCRIPTION;
    private Map<SelectionKey, GearmanJobServerSession> sessionsMap = null;
    private Selector ioAvailable = null;
    private state runState = state.RUNNING;
    private final Map<GearmanJobServerSession, Map<JobHandle, GearmanJobImpl>> sessionJobsMap;
    private GearmanJobImpl jobAwatingCreation;
    private final Timer timer = new Timer();

    public GearmanClientImpl() {
        this.sessionsMap = new HashMap<SelectionKey, GearmanJobServerSession>();
        this.sessionJobsMap = new HashMap<GearmanJobServerSession, Map<JobHandle, GearmanJobImpl>>();
        this.DESCRIPTION = "GearmanClient:" + Thread.currentThread().getId();
    }

    @Override
    public boolean addJobServer(GearmanJobServerConnection newconn) throws IllegalArgumentException, IllegalStateException {
        if (!(newconn instanceof GearmanNIOJobServerConnection)) {
            throw new IllegalArgumentException("Client currently only supports " + GearmanNIOJobServerConnection.class.getName() + " connections.");
        }
        GearmanNIOJobServerConnection conn = (GearmanNIOJobServerConnection)newconn;
        if (!this.runState.equals((Object)state.RUNNING)) {
            throw new RejectedExecutionException("Client has been shutdown");
        }
        GearmanJobServerSession session = new GearmanJobServerSession(conn);
        if (this.sessionsMap.values().contains(session)) {
            LOG.log(Level.FINE, "The server " + newconn + " was previously " + "added to the client. Ignoring add request.");
            return true;
        }
        try {
            if (this.ioAvailable == null) {
                this.ioAvailable = Selector.open();
            }
            session.initSession(this.ioAvailable, this);
            SelectionKey key = session.getSelectionKey();
            this.sessionsMap.put(key, session);
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, "Failed to connect to job server " + newconn + ".", ioe);
            return false;
        }
        this.sessionJobsMap.put(session, new HashMap());
        LOG.log(Level.FINE, "Added connection " + conn + " to client " + this);
        return true;
    }

    public boolean hasConnection(GearmanJobServerConnection conn) {
        for (GearmanJobServerSession sess : this.sessionsMap.values()) {
            if (!sess.getConnection().equals(conn)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<GearmanJobServerConnection> getSetOfJobServers() throws IllegalStateException {
        if (!this.runState.equals((Object)state.RUNNING)) {
            throw new IllegalStateException(CLIENT_NOT_ACTIVE);
        }
        ArrayList<GearmanJobServerConnection> retSet = new ArrayList<GearmanJobServerConnection>();
        for (GearmanJobServerSession sess : this.sessionsMap.values()) {
            retSet.add(sess.getConnection());
        }
        return retSet;
    }

    @Override
    public void removeJobServer(GearmanJobServerConnection conn) throws IllegalArgumentException, IllegalStateException {
        if (!this.runState.equals((Object)state.RUNNING)) {
            throw new IllegalStateException("JobServers can not be removed once shutdown has been commenced.");
        }
        Iterator<GearmanJobServerSession> iter = this.sessionsMap.values().iterator();
        GearmanJobServerSession session = null;
        boolean foundit = false;
        while (iter.hasNext() && !foundit) {
            session = iter.next();
            if (!session.getConnection().equals(conn)) continue;
            foundit = true;
        }
        if (!foundit) {
            throw new IllegalArgumentException("JobServer " + conn + " has not" + " been registered with this client.");
        }
        this.shutDownSession(session);
        LOG.log(Level.FINE, "Removed job server " + conn + " from client " + this);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        GearmanJobImpl job;
        if (task == null) {
            throw new IllegalStateException("Null task was submitted to gearman client");
        }
        if (!this.runState.equals((Object)state.RUNNING)) {
            throw new RejectedExecutionException("Client has been shutdown");
        }
        if (!(task instanceof GearmanServerResponseHandler)) {
            throw new RejectedExecutionException("Task must implement the " + GearmanServerResponseHandler.class + " interface to" + " submitted to this client");
        }
        GearmanJobImpl handler = job = (GearmanJobImpl)task;
        if (job.isDone()) {
            throw new RejectedExecutionException("Task can not be resubmitted ");
        }
        GearmanJobServerSession session = null;
        try {
            session = this.getSessionForTask();
        }
        catch (IOException ioe) {
            throw new RejectedExecutionException(ioe);
        }
        job.setJobServerSession(session);
        GearmanPacket submitRequest = this.getPacketFromJob(job);
        GearmanTask submittedJob = new GearmanTask(handler, submitRequest);
        session.submitTask(submittedJob);
        LOG.log(Level.FINE, "Client " + this + " has submitted job " + job + " to session " + session + ". Job has been added to the " + "active job queue");
        try {
            this.jobAwatingCreation = job;
            if (!this.driveRequestTillState(submittedJob, GearmanTask.State.RUNNING)) {
                throw new RejectedExecutionException("Timed out waiting for submission of " + job + " to complete");
            }
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, "Client " + this + " encounted an " + "IOException while drivingIO", ioe);
            throw new RejectedExecutionException("Failed to successfully submit" + job + " due to IOException", ioe);
        }
        finally {
            this.jobAwatingCreation = null;
        }
        return job;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        throw new UnsupportedOperationException("Client does not support execution of non-GearmanJob objects");
    }

    @Override
    public Future<?> submit(Runnable task) {
        throw new UnsupportedOperationException("Client does not support execution of non-GearmanJob objects");
    }

    @Override
    public void execute(Runnable command) {
        throw new UnsupportedOperationException("Client does not support execution of non-GearmanJob objects");
    }

    public List invokeAll(Collection tasks) throws InterruptedException {
        ArrayList futures = new ArrayList();
        for (Callable curTask : tasks) {
            futures.add(this.submit(curTask));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException ee) {
                LOG.log(Level.WARNING, "Failed to execute task " + future + ".", ee);
            }
        }
        return futures;
    }

    public List invokeAll(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Future invokeAny(Collection tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Future invokeAny(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GearmanJobStatus getJobStatus(GearmanJob job) throws IOException, GearmanException, IllegalStateException {
        if (!(job instanceof GearmanJobImpl)) {
            throw new IllegalArgumentException("job must be of type " + GearmanJobImpl.class);
        }
        GearmanJobImpl jobImpl = (GearmanJobImpl)job;
        return this.updateJobStatus(jobImpl.getHandle(), jobImpl.getSession());
    }

    public byte[] echo(byte[] data) throws IOException, GearmanException {
        if (!this.runState.equals((Object)state.RUNNING)) {
            throw new IllegalStateException(CLIENT_NOT_ACTIVE);
        }
        GearmanPacketImpl echoRequest = new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.ECHO_REQ, data);
        GearmanEchoResponseHandler handler = new GearmanEchoResponseHandler();
        GearmanTask t = new GearmanTask(handler, echoRequest);
        GearmanJobServerSession session = this.getSessionForTask();
        session.submitTask(t);
        LOG.log(Level.FINE, "Client " + this + " has submitted echo request " + "(payload = " + ByteUtils.toHex(data) + " to session " + session);
        if (!this.driveRequestTillState(t, GearmanTask.State.FINISHED)) {
            throw new GearmanException("Failed to execute echo request " + t + " to session " + session);
        }
        LOG.log(Level.FINE, "Client " + this + " has completed echo request " + "to session " + session);
        return handler.getResults();
    }

    public int getNumberofActiveJobs() throws IllegalStateException {
        if (this.runState.equals((Object)state.TERMINATED)) {
            throw new IllegalStateException(CLIENT_NOT_ACTIVE);
        }
        int size = 0;
        for (Map<JobHandle, GearmanJobImpl> cur : this.sessionJobsMap.values()) {
            size += cur.size();
        }
        return size;
    }

    @Override
    public void handleSessionEvent(GearmanSessionEvent event) throws IllegalArgumentException, IllegalStateException {
        GearmanPacket p = event.getPacket();
        GearmanJobServerSession s = event.getSession();
        GearmanPacketType t = p.getPacketType();
        Map<JobHandle, GearmanJobImpl> jobsMaps = this.sessionJobsMap.get(s);
        switch (t) {
            case JOB_CREATED: {
                if (this.jobAwatingCreation == null) {
                    throw new IllegalStateException("Recevied job creation message but have not job awaiting submission.");
                }
                if (this.jobAwatingCreation.isBackgroundJob()) break;
                jobsMaps.put(new JobHandle(this.jobAwatingCreation), this.jobAwatingCreation);
                break;
            }
            case WORK_DATA: 
            case WORK_STATUS: 
            case WORK_WARNING: 
            case WORK_COMPLETE: 
            case WORK_FAIL: 
            case WORK_EXCEPTION: {
                JobHandle handle = new JobHandle(p.getDataComponentValue(GearmanPacket.DataComponentName.JOB_HANDLE));
                GearmanJobImpl job = jobsMaps.get(handle);
                if (job == null) {
                    LOG.log(Level.WARNING, "Client received packet from server for unknown job ( job_handle = " + handle + " packet = " + (Object)((Object)t) + " )");
                    break;
                }
                job.handleEvent(p);
                if (!job.isDone()) break;
                jobsMaps.remove(handle);
                break;
            }
            case ERROR: {
                String errCode = ByteUtils.fromUTF8Bytes(p.getDataComponentValue(GearmanPacket.DataComponentName.ERROR_CODE));
                String errMsg = ByteUtils.fromUTF8Bytes(p.getDataComponentValue(GearmanPacket.DataComponentName.ERROR_TEXT));
                LOG.log(Level.WARNING, "Received error code " + errCode + "( " + errMsg + " )" + " from session " + s + ". Shutting session down");
                this.shutDownSession(s);
                if (!this.sessionsMap.isEmpty()) break;
                this.shutdown();
                break;
            }
            default: {
                LOG.log(Level.WARNING, "received un-expected packet from Job Server Session: " + p + ". Shutting down session");
                this.shutDownSession(s);
                if (!this.sessionsMap.isEmpty()) break;
                this.shutdown();
            }
        }
    }

    @Override
    public void shutdown() {
        if (!this.runState.equals((Object)state.RUNNING)) {
            return;
        }
        this.runState = state.SHUTTINGDOWN;
        LOG.log(Level.FINE, "Commencing controlled shutdown of client: " + this);
        try {
            this.awaitTermination(-1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            LOG.log(Level.FINE, "Client shutdown interrupted while waiting for jobs to terminate.");
        }
        this.shutdownNow();
        LOG.log(Level.FINE, "Completed ontrolled shutdown of client: " + this);
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.runState = state.SHUTTINGDOWN;
        LOG.log(Level.FINE, "Commencing immediate shutdown of client: " + this);
        this.timer.cancel();
        Iterator<GearmanJobServerSession> sessions = this.sessionsMap.values().iterator();
        while (sessions.hasNext()) {
            GearmanJobServerSession curSession = sessions.next();
            if (!curSession.isInitialized()) continue;
            try {
                curSession.closeSession();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to closes session " + curSession + " while performing immediate shutdown of client " + this + ". Encountered the following exception " + e);
            }
            sessions.remove();
        }
        this.sessionsMap.clear();
        this.sessionsMap = null;
        this.runState = state.TERMINATED;
        try {
            this.ioAvailable.close();
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, "Encountered IOException while closing selector for client ", ioe);
        }
        LOG.log(Level.FINE, "Completed shutdown of client: " + this);
        return new ArrayList<Runnable>();
    }

    @Override
    public boolean isShutdown() {
        return !this.runState.equals((Object)state.RUNNING);
    }

    @Override
    public boolean isTerminated() {
        return this.runState.equals((Object)state.TERMINATED);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long timeOutInMills;
        TimeUnit sessionUnit = TimeUnit.MILLISECONDS;
        long timeLeft = -1L;
        long l = timeOutInMills = timeout < 0L ? -1L : TimeUnit.MILLISECONDS.convert(timeout, unit) + System.currentTimeMillis();
        if (this.getNumberofActiveJobs() == 0) {
            return true;
        }
        for (GearmanJobServerSession curSession : this.sessionsMap.values()) {
            if (!curSession.isInitialized()) continue;
            if (timeout >= 0L && (timeLeft = timeOutInMills - System.currentTimeMillis()) <= 0L) {
                LOG.log(Level.WARNING, "awaitTermination exceeded timeout.");
                break;
            }
            try {
                curSession.waitForTasksToComplete(timeLeft, sessionUnit);
            }
            catch (TimeoutException te) {
                LOG.log(Level.FINE, "timed out waiting for all tasks to complete");
                break;
            }
        }
        return this.getNumberofActiveJobs() == 0;
    }

    public String toString() {
        return this.DESCRIPTION;
    }

    private void driveClientIO() throws IOException, GearmanException {
        for (GearmanJobServerSession sess : this.sessionsMap.values()) {
            int interestOps = 1;
            if (sess.sessionHasDataToWrite()) {
                interestOps |= 4;
            }
            sess.getSelectionKey().interestOps(interestOps);
        }
        this.ioAvailable.selectNow();
        Set<SelectionKey> keys = this.ioAvailable.selectedKeys();
        LOG.log(Level.FINEST, "Driving IO for client " + this + ". " + keys.size() + " session(s) currently available for IO");
        for (SelectionKey key : keys) {
            GearmanJobServerSession s = this.sessionsMap.get(key);
            s.driveSessionIO();
        }
    }

    private GearmanJobStatus updateJobStatus(byte[] jobhandle, GearmanJobServerSession session) throws IOException, IllegalStateException, GearmanException {
        if (!this.runState.equals((Object)state.RUNNING)) {
            throw new IllegalStateException(CLIENT_NOT_ACTIVE);
        }
        if (jobhandle == null || jobhandle.length == 0) {
            throw new IllegalStateException("Invalid job handle. Handle must not be null nor empty");
        }
        GearmanPacketImpl statusRequest = new GearmanPacketImpl(GearmanPacketMagic.REQ, GearmanPacketType.GET_STATUS, jobhandle);
        GearmanJobStatusImpl handler = new GearmanJobStatusImpl();
        GearmanTask t = new GearmanTask(handler, statusRequest);
        session.submitTask(t);
        if (!this.driveRequestTillState(t, GearmanTask.State.FINISHED)) {
            throw new GearmanException("Failed to execute jobstatus request " + t + " to session " + session);
        }
        return handler;
    }

    private GearmanJobServerSession getSessionForTask() throws IOException {
        if (this.sessionsMap.values().isEmpty()) {
            throw new IOException("No servers registered with client");
        }
        ArrayList<GearmanJobServerSession> sessions = new ArrayList<GearmanJobServerSession>();
        sessions.addAll(this.sessionsMap.values());
        Random rand = new Random(System.currentTimeMillis());
        int s = rand.nextInt(sessions.size());
        GearmanJobServerSession session = (GearmanJobServerSession)sessions.get(s);
        if (!session.isInitialized()) {
            session.initSession(this.ioAvailable, this);
            SelectionKey key = session.getSelectionKey();
            this.sessionsMap.put(key, session);
        }
        return session;
    }

    private boolean driveRequestTillState(GearmanTask r, GearmanTask.State state2) throws IOException, GearmanException {
        Alarm alarm = new Alarm();
        this.timer.schedule((TimerTask)alarm, 2000L);
        while (r.getState().compareTo(state2) < 0 && !alarm.hasFired()) {
            this.driveClientIO();
        }
        return r.getState().compareTo(state2) >= 0;
    }

    private GearmanPacket getPacketFromJob(GearmanJob job) {
        int destPos = 0;
        GearmanPacketMagic magic = GearmanPacketMagic.REQ;
        GearmanPacketType type = null;
        byte[] packetdata = null;
        byte[] fnname = ByteUtils.toAsciiBytes(job.getFunctionName());
        byte[] uid = job.getID();
        byte[] data = job.getData();
        if (job.getPriority().equals((Object)GearmanJob.JobPriority.HIGH)) {
            GearmanPacketType gearmanPacketType = type = job.isBackgroundJob() ? GearmanPacketType.SUBMIT_JOB_HIGH_BG : GearmanPacketType.SUBMIT_JOB_HIGH;
        }
        if (job.getPriority().equals((Object)GearmanJob.JobPriority.LOW)) {
            GearmanPacketType gearmanPacketType = type = job.isBackgroundJob() ? GearmanPacketType.SUBMIT_JOB_LOW_BG : GearmanPacketType.SUBMIT_JOB_LOW;
        }
        if (job.getPriority().equals((Object)GearmanJob.JobPriority.NORMAL)) {
            type = job.isBackgroundJob() ? GearmanPacketType.SUBMIT_JOB_BG : GearmanPacketType.SUBMIT_JOB;
        }
        packetdata = new byte[fnname.length + uid.length + data.length + 2];
        System.arraycopy(fnname, 0, packetdata, destPos, fnname.length);
        destPos += fnname.length;
        packetdata[destPos++] = 0;
        System.arraycopy(uid, 0, packetdata, destPos, uid.length);
        destPos += uid.length;
        packetdata[destPos++] = 0;
        System.arraycopy(data, 0, packetdata, destPos, data.length);
        return new GearmanPacketImpl(magic, type, packetdata);
    }

    private void shutDownSession(GearmanJobServerSession s) {
        if (s.isInitialized()) {
            SelectionKey k = s.getSelectionKey();
            if (k != null) {
                this.sessionsMap.remove(k);
                k.cancel();
            }
            s.closeSession();
        }
        this.sessionJobsMap.remove(s);
    }

    private static class JobHandle {
        private final byte[] jobHandle;

        JobHandle(GearmanJobImpl job) {
            this(job.getHandle());
        }

        JobHandle(byte[] handle) {
            this.jobHandle = new byte[handle.length];
            System.arraycopy(handle, 0, this.jobHandle, 0, handle.length);
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (!(that instanceof JobHandle)) {
                return false;
            }
            JobHandle thatHandle = (JobHandle)that;
            return Arrays.equals(this.jobHandle, thatHandle.jobHandle);
        }

        public int hashCode() {
            return Arrays.hashCode(this.jobHandle);
        }
    }

    private static class Alarm
    extends TimerTask {
        private final AtomicBoolean timesUp = new AtomicBoolean(false);

        private Alarm() {
        }

        @Override
        public void run() {
            this.timesUp.set(true);
        }

        public boolean hasFired() {
            return this.timesUp.get();
        }
    }

    private static enum state {
        RUNNING,
        SHUTTINGDOWN,
        TERMINATED;

    }
}

