/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.taglibs.authz;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.util.ExpressionEvaluationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyAuthorizeTag
extends TagSupport {
    private String ifAllGranted = "";
    private String ifAnyGranted = "";
    private String ifNotGranted = "";

    private Set<String> authoritiesToRoles(Collection<GrantedAuthority> c) {
        HashSet<String> target = new HashSet<String>();
        for (GrantedAuthority authority : c) {
            if (null == authority.getAuthority()) {
                throw new IllegalArgumentException("Cannot process GrantedAuthority objects which return null from getAuthority() - attempting to process " + authority.toString());
            }
            target.add(authority.getAuthority());
        }
        return target;
    }

    public int doStartTag() throws JspException {
        Set<GrantedAuthority> grantedCopy;
        Set<GrantedAuthority> grantedCopy2;
        if (!(null != this.ifAllGranted && !"".equals(this.ifAllGranted) || null != this.ifAnyGranted && !"".equals(this.ifAnyGranted) || null != this.ifNotGranted && !"".equals(this.ifNotGranted))) {
            return 0;
        }
        Collection<GrantedAuthority> granted = this.getPrincipalAuthorities();
        String evaledIfNotGranted = ExpressionEvaluationUtils.evaluateString((String)"ifNotGranted", (String)this.ifNotGranted, (PageContext)this.pageContext);
        if (null != evaledIfNotGranted && !"".equals(evaledIfNotGranted) && !(grantedCopy2 = this.retainAll(granted, this.parseAuthoritiesString(evaledIfNotGranted))).isEmpty()) {
            return 0;
        }
        String evaledIfAllGranted = ExpressionEvaluationUtils.evaluateString((String)"ifAllGranted", (String)this.ifAllGranted, (PageContext)this.pageContext);
        if (null != evaledIfAllGranted && !"".equals(evaledIfAllGranted) && !granted.containsAll(this.parseAuthoritiesString(evaledIfAllGranted))) {
            return 0;
        }
        String evaledIfAnyGranted = ExpressionEvaluationUtils.evaluateString((String)"ifAnyGranted", (String)this.ifAnyGranted, (PageContext)this.pageContext);
        if (null != evaledIfAnyGranted && !"".equals(evaledIfAnyGranted) && (grantedCopy = this.retainAll(granted, this.parseAuthoritiesString(evaledIfAnyGranted))).isEmpty()) {
            return 0;
        }
        return 1;
    }

    public String getIfAllGranted() {
        return this.ifAllGranted;
    }

    public String getIfAnyGranted() {
        return this.ifAnyGranted;
    }

    public String getIfNotGranted() {
        return this.ifNotGranted;
    }

    private Collection<GrantedAuthority> getPrincipalAuthorities() {
        Authentication currentUser = SecurityContextHolder.getContext().getAuthentication();
        if (null == currentUser) {
            return Collections.emptyList();
        }
        return currentUser.getAuthorities();
    }

    private Set<GrantedAuthority> parseAuthoritiesString(String authorizationsString) {
        HashSet<GrantedAuthority> requiredAuthorities = new HashSet<GrantedAuthority>();
        requiredAuthorities.addAll(AuthorityUtils.commaSeparatedStringToAuthorityList((String)authorizationsString));
        return requiredAuthorities;
    }

    private Set<GrantedAuthority> retainAll(Collection<GrantedAuthority> granted, Set<GrantedAuthority> required) {
        Set<String> grantedRoles = this.authoritiesToRoles(granted);
        Set<String> requiredRoles = this.authoritiesToRoles(required);
        grantedRoles.retainAll(requiredRoles);
        return this.rolesToAuthorities(grantedRoles, granted);
    }

    private Set<GrantedAuthority> rolesToAuthorities(Set<String> grantedRoles, Collection<GrantedAuthority> granted) {
        HashSet<GrantedAuthority> target = new HashSet<GrantedAuthority>();
        block0: for (String role : grantedRoles) {
            for (GrantedAuthority authority : granted) {
                if (!authority.getAuthority().equals(role)) continue;
                target.add(authority);
                continue block0;
            }
        }
        return target;
    }

    public void setIfAllGranted(String ifAllGranted) throws JspException {
        this.ifAllGranted = ifAllGranted;
    }

    public void setIfAnyGranted(String ifAnyGranted) throws JspException {
        this.ifAnyGranted = ifAnyGranted;
    }

    public void setIfNotGranted(String ifNotGranted) throws JspException {
        this.ifNotGranted = ifNotGranted;
    }
}

