/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.categories;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.experimental.categories.Category;
import org.junit.experimental.runners.SuiteBuilder;
import org.junit.runner.Runner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryFilter
implements SuiteBuilder.RunnerFilter.Value {
    private final Class<?> fIncluded;

    public CategoryFilter(Class<?> included) {
        this.fIncluded = included;
    }

    public static CategoryFilter include(Class<?> included) {
        return new CategoryFilter(included);
    }

    @Override
    public List<Runner> matchingRunners(List<Runner> allPossibleRunners) {
        ArrayList<Runner> result = new ArrayList<Runner>();
        for (Runner each : allPossibleRunners) {
            if (!this.shouldInclude(each)) continue;
            result.add(each);
        }
        return result;
    }

    private boolean shouldInclude(Runner r) {
        for (Annotation each : r.getDescription().getAnnotations()) {
            if (!this.isCategory(each) || !this.categoryIsIncluded((Category)each)) continue;
            return true;
        }
        return false;
    }

    private boolean isCategory(Annotation a) {
        return a.annotationType().equals(Category.class);
    }

    private boolean categoryIsIncluded(Category a) {
        return Arrays.asList(a.value()).contains(this.fIncluded);
    }
}

