/*
 * Decompiled with CFR 0.152.
 */
package codec.x509.extensions;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Type;
import codec.asn1.Decoder;
import codec.x509.X509Extension;
import java.io.IOException;

public class SubjectKeyIdentifierExtension
extends X509Extension {
    protected static final String ID_CE_SUBJECT_KEY_IDENTIFIER_ = new String("2.5.29.14");
    protected ASN1OctetString keyIdentifier = null;

    public SubjectKeyIdentifierExtension() throws Exception {
        this.setOID(new ASN1ObjectIdentifier(ID_CE_SUBJECT_KEY_IDENTIFIER_));
    }

    public SubjectKeyIdentifierExtension(byte[] ext) throws ASN1Exception, IOException {
        super(ext);
    }

    public void setKeyIdentifier(byte[] identifier) throws Exception {
        this.keyIdentifier = new ASN1OctetString(identifier);
        this.setValue(this.keyIdentifier);
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        super.decode(dec);
        ASN1Type inner = (ASN1Type)super.getValue();
        if (!(inner instanceof ASN1OctetString)) {
            throw new ASN1Exception("Inner value of wrong type: " + inner.getClass().getName());
        }
        this.keyIdentifier = (ASN1OctetString)inner;
    }

    public String toString(String offset) {
        StringBuffer buf = new StringBuffer(offset + "SubjectKeyIdentifier [" + ID_CE_SUBJECT_KEY_IDENTIFIER_ + "] {");
        if (this.isCritical()) {
            buf.append(" (CRITICAL)\n");
        } else {
            buf.append(" (NOT CRITICAL)\n");
        }
        buf.append(offset + "  keyIdentifier: " + this.keyIdentifier + "\n");
        buf.append(offset + "}\n");
        return buf.toString();
    }
}

