/*
 * Decompiled with CFR 0.152.
 */
package codec.x509.extensions;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Sequence;
import codec.asn1.Decoder;
import codec.x509.AlgorithmIdentifier;
import codec.x509.X509Extension;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class CertHashExtension
extends X509Extension {
    public static final String DEFAULT_HASH_ALG = "SHA1";
    public static final String EXTENSION_OID = "1.3.36.8.3.13";
    private ASN1Sequence syntax_;
    private AlgorithmIdentifier hashAlgorithm_;
    private ASN1OctetString certificateHash_;

    public CertHashExtension() throws ASN1Exception, CertificateEncodingException {
        this.setOID(new ASN1ObjectIdentifier(EXTENSION_OID));
        this.setCritical(false);
        this.syntax_ = new ASN1Sequence(2);
        this.hashAlgorithm_ = new AlgorithmIdentifier();
        this.certificateHash_ = new ASN1OctetString();
        this.syntax_.add(this.hashAlgorithm_);
        this.syntax_.add(this.certificateHash_);
        this.setValue(this.syntax_);
    }

    public CertHashExtension(X509Certificate cert) throws ASN1Exception, GeneralSecurityException {
        this(cert, DEFAULT_HASH_ALG);
    }

    public CertHashExtension(X509Certificate cert, String alg) throws ASN1Exception, GeneralSecurityException {
        this(cert.getEncoded(), alg);
    }

    public CertHashExtension(byte[] cert, String alg) throws ASN1Exception, GeneralSecurityException {
        if (cert == null) {
            throw new NullPointerException("cert");
        }
        AlgorithmIdentifier aid = new AlgorithmIdentifier(alg);
        MessageDigest dig = MessageDigest.getInstance(alg);
        byte[] buf = dig.digest(cert);
        this.syntax_ = new ASN1Sequence(2);
        this.hashAlgorithm_ = aid;
        this.certificateHash_ = new ASN1OctetString(buf);
        this.syntax_.add(this.hashAlgorithm_);
        this.syntax_.add(this.certificateHash_);
        this.setOID(new ASN1ObjectIdentifier(EXTENSION_OID));
        this.setCritical(false);
        this.setValue(this.syntax_);
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        super.decode(dec);
        super.decodeExtensionValue(this.syntax_);
    }

    public AlgorithmIdentifier getHashAlgorithmID() {
        return this.hashAlgorithm_;
    }

    public String getHashAlgorithmName() {
        return this.hashAlgorithm_.getAlgorithmName();
    }

    public boolean verify(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        return this.verify(cert.getEncoded());
    }

    public boolean verify(byte[] cert) throws NoSuchAlgorithmException {
        String alg = this.hashAlgorithm_.getAlgorithmName();
        if (alg == null) {
            throw new NoSuchAlgorithmException(this.hashAlgorithm_.getAlgorithmOID().toString());
        }
        MessageDigest dig = MessageDigest.getInstance(alg);
        byte[] buf = dig.digest(cert);
        return Arrays.equals(buf, this.certificateHash_.getByteArray());
    }
}

