/*
 * Decompiled with CFR 0.152.
 */
package codec.x509.extensions;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1SequenceOf;
import codec.asn1.ConstraintException;
import codec.asn1.Decoder;
import codec.x509.GeneralName;
import codec.x509.X509Extension;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;

public class AdmissionExtension
extends X509Extension {
    private GeneralName admissionAuthority = null;
    private ASN1Sequence admissions = new ASN1SequenceOf(class$codec$x509$extensions$Admissions == null ? (class$codec$x509$extensions$Admissions = AdmissionExtension.class$("codec.x509.extensions.Admissions")) : class$codec$x509$extensions$Admissions);
    public static final String EXTENSION_OID = "1.3.36.8.3.3";
    private ASN1Sequence admissionSyntax = new ASN1Sequence();
    static /* synthetic */ Class class$codec$x509$extensions$Admissions;

    public AdmissionExtension(GeneralName adAuth) {
        this.admissionAuthority = adAuth;
        this.setCritical(false);
        try {
            this.setOID(new ASN1ObjectIdentifier(EXTENSION_OID));
            this.admissionSyntax.add(this.admissionAuthority);
            this.setValue(this.admissionSyntax);
        }
        catch (ConstraintException ce) {
            ce.printStackTrace();
        }
        catch (CertificateEncodingException cee) {
            cee.printStackTrace();
        }
    }

    public AdmissionExtension(ASN1Sequence ad) {
        this.setCritical(false);
        this.admissions = ad;
        this.admissionSyntax.add(this.admissions);
        try {
            this.setOID(new ASN1ObjectIdentifier(EXTENSION_OID));
            this.setValue(this.admissionSyntax);
        }
        catch (ConstraintException ce) {
            ce.printStackTrace();
        }
        catch (CertificateEncodingException cee) {
            cee.printStackTrace();
        }
    }

    public void addAdmission(ASN1Sequence admissions_) {
        this.admissions = admissions_;
        this.admissionSyntax.add(this.admissions);
        try {
            this.setValue(this.admissionSyntax);
        }
        catch (CertificateEncodingException cee) {
            cee.printStackTrace();
        }
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        super.decode(dec);
        super.decodeExtensionValue(this.admissionAuthority);
        super.decodeExtensionValue(this.admissions);
    }

    public String toString() {
        String result = "Extension OID : 1.3.36.8.3.3";
        if (this.admissionAuthority != null) {
            result = result + "\n" + this.admissionAuthority;
        }
        result = result + "\n" + this.admissionSyntax;
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

