/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs7;

import codec.asn1.ASN1Integer;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1RegisteredType;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1SetOf;
import codec.pkcs7.ContentInfo;
import codec.pkcs7.EncryptedContentInfo;
import codec.pkcs7.RecipientInfo;
import codec.x501.BadNameException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.crypto.SecretKey;

public class EnvelopedData
extends ASN1Sequence
implements ASN1RegisteredType {
    public static final int BUFFER_SIZE = 1024;
    private static final int[] THIS_OID = new int[]{1, 2, 840, 113549, 1, 7, 3};
    protected ASN1Integer version_ = new ASN1Integer(0);
    protected ASN1SetOf recipients_ = new ASN1SetOf(class$codec$pkcs7$RecipientInfo == null ? (class$codec$pkcs7$RecipientInfo = EnvelopedData.class$("codec.pkcs7.RecipientInfo")) : class$codec$pkcs7$RecipientInfo);
    protected EncryptedContentInfo info_;
    protected ContentInfo content_;
    static /* synthetic */ Class class$codec$pkcs7$RecipientInfo;

    public EnvelopedData() {
        super(3);
        this.info_ = new EncryptedContentInfo();
        this.add(this.version_);
        this.add(this.recipients_);
        this.add(this.info_);
    }

    public EnvelopedData(SecretKey bek, String bea, AlgorithmParameters params) throws InvalidAlgorithmParameterException {
        super(3);
        this.info_ = new EncryptedContentInfo(bea, bek, params);
        this.add(this.version_);
        this.add(this.recipients_);
        this.add(this.info_);
    }

    public ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier(THIS_OID);
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.info_.getContentType();
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.info_;
    }

    public List getRecipientInfos() {
        return Collections.unmodifiableList(this.recipients_);
    }

    public boolean hasRecipient(X509Certificate cert) {
        return this.getRecipientInfo(cert) != null;
    }

    public RecipientInfo getRecipientInfo(X509Certificate cert) {
        Iterator i = ((AbstractList)this.recipients_).iterator();
        while (i.hasNext()) {
            RecipientInfo ri = (RecipientInfo)i.next();
            if (!ri.getIssuer().equals(cert.getIssuerDN()) || !ri.getSerialNumber().equals(cert.getSerialNumber())) continue;
            return ri;
        }
        return null;
    }

    public void addRecipient(X509Certificate cert) throws GeneralSecurityException, BadNameException {
        if (!this.hasRecipient(cert)) {
            this.recipients_.add(this.info_.newRecipient(cert));
        }
    }

    public void addRecipient(X509Certificate cert, int encType) throws GeneralSecurityException, BadNameException {
        if (!this.hasRecipient(cert)) {
            this.recipients_.add(this.info_.newRecipient(cert, encType));
        }
    }

    public void init(X509Certificate cert, PrivateKey kdk) throws GeneralSecurityException, NoSuchElementException {
        RecipientInfo ri = this.getRecipientInfo(cert);
        if (ri == null) {
            throw new NoSuchElementException("No such recipient exists!");
        }
        this.info_.init(kdk, ri);
    }

    public boolean isReady() {
        return this.info_.isReady();
    }

    public void setData(InputStream in) throws GeneralSecurityException, IOException {
        this.info_.setData(in);
    }

    public byte[] getData() throws GeneralSecurityException, NoSuchElementException {
        return this.info_.getData();
    }

    public SecretKey getSecretKey() {
        return this.info_.getSecretKey();
    }

    public void decryptBulkData(InputStream in, OutputStream out) throws IOException, GeneralSecurityException {
        this.info_.crypt(in, out, 2);
    }

    public void encryptBulkData(InputStream in, OutputStream out) throws IOException, GeneralSecurityException {
        this.info_.crypt(in, out, 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

