/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1AbstractType;
import codec.asn1.ASN1Exception;
import codec.asn1.ConstraintException;
import codec.asn1.Decoder;
import codec.asn1.Encoder;
import java.io.IOException;

public class ASN1OctetString
extends ASN1AbstractType {
    private static final byte[] DEFAULT_VALUE = new byte[0];
    private byte[] value_ = DEFAULT_VALUE;

    public ASN1OctetString() {
    }

    public ASN1OctetString(byte[] b) {
        this.setByteArray0(b);
    }

    public Object getValue() {
        return this.value_;
    }

    public byte[] getByteArray() {
        return (byte[])this.value_.clone();
    }

    public void setByteArray(byte[] b) throws ConstraintException {
        this.setByteArray0(b);
        this.checkConstraints();
    }

    private void setByteArray0(byte[] b) {
        this.value_ = b == null ? DEFAULT_VALUE : b;
    }

    public int byteCount() {
        return this.value_.length;
    }

    public int getTag() {
        return 4;
    }

    public void encode(Encoder enc) throws ASN1Exception, IOException {
        enc.writeOctetString(this);
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        dec.readOctetString(this);
        this.checkConstraints();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Octet String");
        int i = 0;
        while (i < this.value_.length) {
            String octet = Integer.toHexString(this.value_[i] & 0xFF);
            buf.append(' ');
            if (octet.length() == 1) {
                buf.append('0');
            }
            buf.append(octet);
            ++i;
        }
        return buf.toString();
    }

    public Object clone() {
        ASN1OctetString o;
        try {
            o = (ASN1OctetString)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Internal, clone support mismatch!");
        }
        o.value_ = (byte[])this.value_.clone();
        return o;
    }
}

