/*
 * Decompiled with CFR 0.152.
 */
package tests;

import com.vestiacom.gdserver.service.impl.HttpProxySessions;
import homemonitor.GDErrorCode;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnection;
import homemonitor.Utility;
import homemonitor.upnp.UPnPApp;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={UPnPApp.class})
public class UPnPAppTests {
    private GatewayDeviceConnection gdc;
    private UPnPApp.Callback callback;
    private String mac;
    private HttpClient client;
    private UPnPApp upnp_app;
    private HttpProxySessions httpProxySessions;

    @Before
    public void setUp() {
        this.gdc = PowerMock.createMock(GatewayDeviceConnection.class);
        this.callback = PowerMock.createMock(UPnPApp.Callback.class);
        this.httpProxySessions = PowerMock.createMock(HttpProxySessions.class);
        this.mac = "00:00:00:00:00:01";
        this.client = PowerMock.createMock(HttpClient.class);
        this.upnp_app = new UPnPApp(this.gdc, this.client, true, this.httpProxySessions);
        this.upnp_app.registerCallback(this.callback);
    }

    @After
    public void tearDown() {
        this.gdc = null;
        this.callback = null;
        this.mac = null;
        this.client = null;
        PowerMock.resetAll(new Object[0]);
    }

    @Test
    public void testSetupForwardingSessionFailed() {
        EasyMock.expect(this.gdc.createSession(EasyMock.eq(this.mac), EasyMock.eq(this.upnp_app))).andReturn(0L);
        GatewayDevice gd = new GatewayDevice(this.mac, "1.2.3.4", "1.2.3.1");
        EasyMock.expect(this.gdc.findById(EasyMock.eq(this.mac))).andReturn(gd);
        PowerMock.replayAll(new Object[0]);
        Assert.assertFalse(this.upnp_app.setupForwarding(this.mac, (short)8000));
        PowerMock.verifyAll();
    }

    @Test
    public void testSetupForwardingSendFailed() {
        EasyMock.expect(this.gdc.createSession(EasyMock.eq(this.mac), EasyMock.eq(this.upnp_app))).andReturn(1L);
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.putShort((short)16384);
        byte[] data = buf.array();
        GatewayDevice gd = new GatewayDevice(this.mac, "1.2.3.4", "1.2.3.1");
        EasyMock.expect(this.gdc.findById(EasyMock.eq(this.mac))).andReturn(gd);
        EasyMock.expect(this.gdc.send(EasyMock.eq(48), EasyMock.eq(1L), EasyMock.aryEq(data))).andReturn(GDErrorCode.WrongSessionID);
        this.gdc.destroySession(1L);
        PowerMock.replayAll(new Object[0]);
        Assert.assertFalse(this.upnp_app.setupForwarding(this.mac, (short)16384));
        PowerMock.verifyAll();
    }

    @Test
    public void testSetupForwarding() {
        EasyMock.expect(this.gdc.createSession(EasyMock.eq(this.mac), EasyMock.eq(this.upnp_app))).andReturn(1L);
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.putShort((short)16384);
        byte[] data = buf.array();
        GatewayDevice gd = new GatewayDevice(this.mac, "1.2.3.4", "1.2.3.1");
        EasyMock.expect(this.gdc.findById(EasyMock.eq(this.mac))).andReturn(gd);
        EasyMock.expect(this.gdc.send(EasyMock.eq(48), EasyMock.eq(1L), EasyMock.aryEq(data))).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertTrue(this.upnp_app.setupForwarding(this.mac, (short)16384));
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedDataNoVerification() throws URISyntaxException, ClientProtocolException, IOException {
        EasyMock.expect(this.gdc.createSession(EasyMock.eq(this.mac), EasyMock.eq(this.upnp_app))).andReturn(1L);
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.putShort((short)8000);
        byte[] data = buf.array();
        GatewayDevice gd = new GatewayDevice(this.mac, "1.2.3.4", "1.2.3.1");
        gd.localIpAddress = "1.0.0.0";
        EasyMock.expect(this.gdc.findById(EasyMock.eq(this.mac))).andReturn(gd);
        EasyMock.expect(this.gdc.send(EasyMock.eq(48), EasyMock.eq(1L), EasyMock.aryEq(data))).andReturn(GDErrorCode.NoError);
        this.callback.forwardingStatus(EasyMock.eq(this.mac), EasyMock.eq("1.0.0.0"), EasyMock.eq(0), EasyMock.eq(true));
        this.gdc.destroySession(1L);
        PowerMock.replayAll(new Object[0]);
        Assert.assertTrue(this.upnp_app.setupForwarding(this.mac, (short)8000));
        buf = ByteBuffer.allocate(6);
        data = buf.array();
        buf.putShort((short)0);
        buf.put(Utility.ipAddressToByteArray("1.0.0.0"));
        this.upnp_app.receivedData(this.mac, 49, 1L, data);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedDataErrorStatusInResponse() throws URISyntaxException, ClientProtocolException, IOException {
        EasyMock.expect(this.gdc.createSession(EasyMock.eq(this.mac), EasyMock.eq(this.upnp_app))).andReturn(1L);
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.putShort((short)8000);
        byte[] data = buf.array();
        GatewayDevice gd = new GatewayDevice(this.mac, "1.2.3.4", "1.2.3.1");
        gd.localIpAddress = "1.0.0.0";
        EasyMock.expect(this.gdc.findById(EasyMock.eq(this.mac))).andReturn(gd);
        EasyMock.expect(this.gdc.send(EasyMock.eq(48), EasyMock.eq(1L), EasyMock.aryEq(data))).andReturn(GDErrorCode.NoError);
        this.callback.forwardingStatus(this.mac, null, -1, false);
        this.gdc.destroySession(1L);
        PowerMock.replayAll(new Object[0]);
        Assert.assertTrue(this.upnp_app.setupForwarding(this.mac, (short)8000));
        buf = ByteBuffer.allocate(1);
        data = buf.array();
        buf.put((byte)1);
        this.upnp_app.receivedData(this.mac, 0, 1L, data);
        PowerMock.verifyAll();
    }
}

