/*
 * Decompiled with CFR 0.152.
 */
package tests;

import homemonitor.GDErrorCode;
import homemonitor.GatewayDeviceConnection;
import homemonitor.UDPProxy.UDPProxy;
import homemonitor.UDPProxy.UDPProxyResponseInterface;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UDPProxyTests {
    private GatewayDeviceConnection gdc;
    private UDPProxyResponseInterface udpResponse;
    private UDPProxy proxy;
    String mac = "fe:fe:fe:fe:fe:fe";
    int dstAddress = -1062731519;
    int dstPort = 2345;
    int srcAddress = -1062731519;
    int srcPort = 2345;
    byte[] testRequestDatagram;
    byte[] testRequestPayload;
    byte[] testResponseDatagram;
    byte[] testResponsePayload;
    String netmask;

    public UDPProxyTests() {
        byte[] byArray = new byte[13];
        byArray[0] = -64;
        byArray[1] = -88;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 9;
        byArray[5] = 41;
        byArray[8] = 1;
        byArray[9] = 94;
        byArray[10] = 1;
        byArray[11] = 28;
        byArray[12] = 1;
        this.testRequestDatagram = byArray;
        this.testRequestPayload = new byte[]{1, 94, 1, 28, 1};
        this.testResponseDatagram = new byte[]{-64, -88, 1, 1, 9, 41, 1, 94, 1, 28, 1};
        this.testResponsePayload = new byte[]{1, 94, 1, 28, 1};
        this.netmask = "255.255.255.0";
    }

    @Before
    public void setUp() {
        this.gdc = EasyMock.createMock(GatewayDeviceConnection.class);
        this.proxy = new UDPProxy(this.gdc);
        this.udpResponse = EasyMock.createMock(UDPProxyResponseInterface.class);
    }

    @After
    public void tearDown() {
        this.udpResponse = null;
        this.proxy = null;
        this.gdc = null;
    }

    @Test
    public void testUDPSessionWithoutBind() {
        long sessionId = 12345L;
        EasyMock.expect(this.gdc.createSession(this.mac, this.proxy)).andReturn(sessionId);
        EasyMock.expect(this.gdc.send(EasyMock.eq(64), EasyMock.eq(sessionId), EasyMock.aryEq(this.testRequestDatagram))).andReturn(GDErrorCode.NoError);
        this.udpResponse.received(EasyMock.eq(this.srcAddress), EasyMock.eq(this.srcPort), EasyMock.aryEq(this.testResponsePayload));
        EasyMock.expectLastCall().times(100);
        EasyMock.expect(this.gdc.send(EasyMock.eq(66), EasyMock.eq(sessionId), EasyMock.aryEq(new byte[0]))).andReturn(GDErrorCode.NoError);
        EasyMock.replay(this.gdc);
        EasyMock.replay(this.udpResponse);
        Assert.assertEquals(sessionId, this.proxy.createSession(this.mac, this.udpResponse));
        Assert.assertEquals((Object)GDErrorCode.NoError, (Object)this.proxy.send(sessionId, this.dstAddress, this.dstPort, this.testRequestPayload));
        int i = 0;
        while (i < 100) {
            this.proxy.receivedData(this.mac, 65, sessionId, this.testResponseDatagram);
            ++i;
        }
        Assert.assertEquals((Object)GDErrorCode.NoError, (Object)this.proxy.close(sessionId));
        Assert.assertEquals((Object)GDErrorCode.WrongSessionID, (Object)this.proxy.send(sessionId, this.dstAddress, this.dstPort, this.testRequestPayload));
        EasyMock.verify(this.gdc);
        EasyMock.verify(this.udpResponse);
    }
}

