/*
 * Decompiled with CFR 0.152.
 */
package tests;

import homemonitor.GDErrorCode;
import homemonitor.HTTPClient.HTTPClient;
import homemonitor.HTTPClient.HTTPClientResult;
import homemonitor.HTTPClient.RandomGenerator;
import homemonitor.TCPProxy.TCPProxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.powermock.api.easymock.PowerMock;

public class HTTPClientTest {
    private static Logger log = Logger.getLogger(HTTPClientTest.class);
    private TCPProxy tcpProxy;
    private HTTPClientResult result;
    private RandomGenerator randomGenerator;
    private HTTPClient client;
    String mac = "fe:fe:fe:fe:fe:fe";
    String destip = "10.10.10.10";
    byte port = (byte)123;
    byte[] connectMsg;
    long sessionId;

    public HTTPClientTest() {
        byte[] byArray = new byte[6];
        byArray[0] = -64;
        byArray[1] = -88;
        byArray[3] = 1;
        byArray[5] = 80;
        this.connectMsg = byArray;
        this.sessionId = 1234L;
    }

    @Before
    public void setUp() {
        this.tcpProxy = PowerMock.createMock(TCPProxy.class);
        this.result = PowerMock.createMock(HTTPClientResult.class);
        this.randomGenerator = PowerMock.createMock(RandomGenerator.class);
        this.client = new HTTPClient(this.tcpProxy, this.result);
        this.client.setRandomGenerator(this.randomGenerator);
    }

    @After
    public void tearDown() {
        this.result = null;
        this.client = null;
        this.tcpProxy = null;
    }

    @Test
    public void testGetUnsucessfulError() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        this.result.onError(EasyMock.aryEq(new byte[0]));
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.get(this.mac, new URL("http://192.168.0.1/")));
        this.client.error(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testPostUnsucessfulError() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        this.result.onError(EasyMock.aryEq(new byte[0]));
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.post(this.mac, new URL("http://192.168.0.1/"), null, "body".getBytes()));
        this.client.error(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUnsucessfulClose() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        this.result.onError(EasyMock.aryEq(new byte[0]));
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.get(this.mac, new URL("http://192.168.0.1/")));
        this.client.closed(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testPostUnsucessfulClose() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        this.result.onError(EasyMock.aryEq(new byte[0]));
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.post(this.mac, new URL("http://192.168.0.1/"), null, "body".getBytes()));
        this.client.closed(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUnsucessfulDisconnected() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        this.result.onError(EasyMock.aryEq(new byte[0]));
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.get(this.mac, new URL("http://192.168.0.1/")));
        this.client.deviceDisconnected(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testPostUnsucessfulDisconnected() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        this.result.onError(EasyMock.aryEq(new byte[0]));
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.post(this.mac, new URL("http://192.168.0.1/"), null, "body".getBytes()));
        this.client.deviceDisconnected(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUnsucessfulHttp404Error() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq("GET / HTTP/1.1\r\nHost: 192.168.0.1\r\nConnection: close\r\n\r\n".getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onHttpError(EasyMock.eq(404), EasyMock.aryEq(new byte[0]));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.get(this.mac, new URL("http://192.168.0.1/")));
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 404 Page not found\r\n\r\n".getBytes());
        PowerMock.verifyAll();
    }

    @Test
    public void testPostUnsucessfulHttp404Error() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        StringBuilder request = new StringBuilder();
        request.append("POST / HTTP/1.1").append("\r\n");
        request.append("Host: 192.168.0.1").append("\r\n");
        request.append("Content-Length: 4").append("\r\n");
        request.append("Connection: close").append("\r\n");
        request.append("\r\n");
        request.append("body");
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq(request.toString().getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onHttpError(EasyMock.eq(404), EasyMock.aryEq(new byte[0]));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.post(this.mac, new URL("http://192.168.0.1/"), null, "body".getBytes()));
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 404 Page not found\r\n\r\n".getBytes());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetSuccessfulShortResponseNoAuth() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq("GET / HTTP/1.1\r\nHost: 192.168.0.1\r\nConnection: close\r\n\r\n".getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onGotHeaders((HashMap)EasyMock.anyObject());
        this.result.onRequestComplete(EasyMock.eq(200), EasyMock.aryEq("Hello world!".getBytes()));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.get(this.mac, new URL("http://192.168.0.1/")));
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 200 OK\r\nContent-Length: 12\r\n\r\nHello world!".getBytes());
        this.client.closed(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testPostSuccessfulShortResponseNoAuth() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        StringBuilder request = new StringBuilder();
        request.append("POST /cgi-bin/system.cgi HTTP/1.1").append("\r\n");
        request.append("Accept-Language: pl,en-us;q=0.7,en;q=0.3").append("\r\n");
        request.append("Host: 192.168.0.1").append("\r\n");
        request.append("Content-Length: 10").append("\r\n");
        request.append("Accept-Encoding: gzip, deflate").append("\r\n");
        request.append("Connection: close").append("\r\n");
        request.append("\r\n");
        request.append("action=get");
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq(request.toString().getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onGotHeaders((HashMap)EasyMock.anyObject());
        this.result.onRequestComplete(EasyMock.eq(200), EasyMock.aryEq("Hello world!".getBytes()));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        additionalHeaders.put("Accept-Encoding", "gzip, deflate");
        additionalHeaders.put("Accept-Language", "pl,en-us;q=0.7,en;q=0.3");
        Assert.assertEquals(true, this.client.post(this.mac, new URL("http://192.168.0.1/cgi-bin/system.cgi"), additionalHeaders, "action=get".getBytes()));
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 200 OK\r\nContent-Length: 12\r\n\r\nHello world!".getBytes());
        this.client.closed(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetSuccessfulShortResponse2PartsNoAuth() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq("GET / HTTP/1.1\r\nHost: 192.168.0.1\r\nConnection: close\r\n\r\n".getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onGotHeaders((HashMap)EasyMock.anyObject());
        this.result.onRequestComplete(EasyMock.eq(200), EasyMock.aryEq("Hello world!".getBytes()));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.get(this.mac, new URL("http://192.168.0.1/")));
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 200 OK\r\nContent-".getBytes());
        this.client.received(this.sessionId, "Length: 12\r\n\r\nHello world!".getBytes());
        this.client.closed(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testPostSuccessfulShortResponse2PartsNoAuth() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        StringBuilder request = new StringBuilder();
        request.append("POST /cgi-bin/system.cgi HTTP/1.1").append("\r\n");
        request.append("Host: 192.168.0.1").append("\r\n");
        request.append("Content-Length: 10").append("\r\n");
        request.append("Connection: close").append("\r\n");
        request.append("\r\n");
        request.append("action=get");
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq(request.toString().getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onGotHeaders((HashMap)EasyMock.anyObject());
        this.result.onRequestComplete(EasyMock.eq(200), EasyMock.aryEq("Hello world!".getBytes()));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.post(this.mac, new URL("http://192.168.0.1/cgi-bin/system.cgi"), null, "action=get".getBytes()));
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 200 OK\r\nContent-".getBytes());
        this.client.received(this.sessionId, "Length: 12\r\n\r\nHello world!".getBytes());
        this.client.closed(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetSuccessfulShortResponse3PartsNoAuth() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq("GET / HTTP/1.1\r\nHost: 192.168.0.1\r\nConnection: close\r\n\r\n".getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onGotHeaders((HashMap)EasyMock.anyObject());
        this.result.onRequestComplete(EasyMock.eq(200), EasyMock.aryEq("Hello world!".getBytes()));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.get(this.mac, new URL("http://192.168.0.1/")));
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 200 OK\r\nContent-".getBytes());
        this.client.received(this.sessionId, "Length: 12\r".getBytes());
        this.client.received(this.sessionId, "\n\r\nHello world!".getBytes());
        this.client.closed(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testPostSuccessfulShortResponse3PartsNoAuth() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        StringBuilder request = new StringBuilder();
        request.append("POST /cgi-bin/system.cgi HTTP/1.1").append("\r\n");
        request.append("Host: 192.168.0.1").append("\r\n");
        request.append("Content-Length: 10").append("\r\n");
        request.append("Connection: close").append("\r\n");
        request.append("\r\n");
        request.append("action=get");
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq(request.toString().getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onGotHeaders((HashMap)EasyMock.anyObject());
        this.result.onRequestComplete(EasyMock.eq(200), EasyMock.aryEq("Hello world!".getBytes()));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.post(this.mac, new URL("http://192.168.0.1/cgi-bin/system.cgi"), null, "action=get".getBytes()));
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 200 OK\r\nContent-".getBytes());
        this.client.received(this.sessionId, "Length: 12\r".getBytes());
        this.client.received(this.sessionId, "\n\r\nHello world!".getBytes());
        this.client.closed(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetSuccessfulWithContentLengthNoAuth() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq("GET / HTTP/1.1\r\nHost: 192.168.0.1\r\nConnection: close\r\n\r\n".getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onGotHeaders((HashMap)EasyMock.anyObject());
        this.result.onRequestComplete(EasyMock.eq(200), EasyMock.aryEq("12345678".getBytes()));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.get(this.mac, new URL("http://192.168.0.1/")));
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 200 OK\r\nContent-".getBytes());
        this.client.received(this.sessionId, "Length: 8\r".getBytes());
        this.client.received(this.sessionId, "\n\r\n12345678".getBytes());
        PowerMock.verifyAll();
    }

    @Test
    public void testPostSuccessfulWithContentLengthNoAuth() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        StringBuilder request = new StringBuilder();
        request.append("POST /cgi-bin/system.cgi HTTP/1.1").append("\r\n");
        request.append("Host: 192.168.0.1").append("\r\n");
        request.append("Content-Length: 10").append("\r\n");
        request.append("Connection: close").append("\r\n");
        request.append("\r\n");
        request.append("action=get");
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq(request.toString().getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onGotHeaders((HashMap)EasyMock.anyObject());
        this.result.onRequestComplete(EasyMock.eq(200), EasyMock.aryEq("12345678".getBytes()));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.post(this.mac, new URL("http://192.168.0.1/cgi-bin/system.cgi"), null, "action=get".getBytes()));
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 200 OK\r\nContent-".getBytes());
        this.client.received(this.sessionId, "Length: 8\r".getBytes());
        this.client.received(this.sessionId, "\n\r\n12345678".getBytes());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetSuccessfulForUrlWithQueryNoAuth() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq("GET /app.cgi?param1=2&param2=3 HTTP/1.1\r\nHost: 192.168.0.1\r\nConnection: close\r\n\r\n".getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onGotHeaders((HashMap)EasyMock.anyObject());
        this.result.onRequestComplete(EasyMock.eq(200), EasyMock.aryEq("Hello world!".getBytes()));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.get(this.mac, new URL("http://192.168.0.1/app.cgi?param1=2&param2=3")));
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 200 OK\r\nContent-Length: 12\r\n\r\nHello world!".getBytes());
        this.client.closed(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetSuccessfulShortResponseBasicAuth() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq("GET / HTTP/1.1\r\nAuthorization: Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==\r\nHost: 192.168.0.1\r\nConnection: close\r\n\r\n".getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onGotHeaders((HashMap)EasyMock.anyObject());
        this.result.onRequestComplete(EasyMock.eq(200), EasyMock.aryEq("Hello world!".getBytes()));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.get(this.mac, new URL("http://Aladdin:open sesame@192.168.0.1/")));
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 200 OK\r\nContent-Length: 12\r\n\r\nHello world!".getBytes());
        this.client.closed(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testPostSuccessfulShortResponseBasicAuth() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        StringBuilder request = new StringBuilder();
        request.append("POST /cgi-bin/system.cgi HTTP/1.1").append("\r\n");
        request.append("Authorization: Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==").append("\r\n");
        request.append("Host: 192.168.0.1").append("\r\n");
        request.append("Content-Length: 10").append("\r\n");
        request.append("Connection: close").append("\r\n");
        request.append("\r\n");
        request.append("action=get");
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq(request.toString().getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onGotHeaders((HashMap)EasyMock.anyObject());
        this.result.onRequestComplete(EasyMock.eq(200), EasyMock.aryEq("Hello world!".getBytes()));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.post(this.mac, new URL("http://Aladdin:open sesame@192.168.0.1/cgi-bin/system.cgi"), null, "action=get".getBytes()));
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 200 OK\r\nContent-Length: 12\r\n\r\nHello world!".getBytes());
        this.client.closed(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetSuccessfulShortResponseDigestAuth() throws MalformedURLException {
        EasyMock.expect(this.randomGenerator.generate()).andReturn("0a4f113b");
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq("GET /dir/index.html HTTP/1.1\r\nAuthorization: Basic TXVmYXNhOkNpcmNsZSBPZiBMaWZl\r\nHost: 192.168.0.1\r\nConnection: close\r\n\r\n".getBytes()))).andReturn(GDErrorCode.NoError);
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq("GET /dir/index.html HTTP/1.1\r\nAuthorization: Digest username=\"Mufasa\",realm=\"testrealm@host.com\",nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",uri=\"/dir/index.html\",qop=auth,nc=00000001,cnonce=\"0a4f113b\",response=\"6629fae49393a05397450978507c4ef1\",opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"\r\nHost: 192.168.0.1\r\nConnection: close\r\n\r\n".getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onGotHeaders((HashMap)EasyMock.anyObject());
        this.result.onRequestComplete(EasyMock.eq(200), EasyMock.aryEq("Hello world!".getBytes()));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.get(this.mac, new URL("http://Mufasa:Circle Of Life@192.168.0.1/dir/index.html")));
        this.client.accepted(this.sessionId);
        String authenticateHeader = "WWW-Authenticate: Digest realm=\"testrealm@host.com\",qop=\"auth,auth-int\",nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"\r\n";
        String response = this.constructUnauthorizedResponse(authenticateHeader);
        this.client.received(this.sessionId, response.getBytes());
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 200 OK\r\nContent-Length: 12\r\n\r\nHello world!".getBytes());
        this.client.closed(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testPostSuccessfulShortResponseDigestAuth() throws MalformedURLException {
        EasyMock.expect(this.randomGenerator.generate()).andReturn("0a4f113b");
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        StringBuilder noAuthRequest = new StringBuilder();
        noAuthRequest.append("POST /dir/index.html HTTP/1.1").append("\r\n");
        noAuthRequest.append("Authorization: Basic TXVmYXNhOkNpcmNsZSBPZiBMaWZl").append("\r\n");
        noAuthRequest.append("Host: 192.168.0.1").append("\r\n");
        noAuthRequest.append("Content-Length: 10").append("\r\n");
        noAuthRequest.append("Connection: close").append("\r\n");
        noAuthRequest.append("\r\n");
        noAuthRequest.append("action=get");
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq(noAuthRequest.toString().getBytes()))).andReturn(GDErrorCode.NoError);
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        StringBuilder authRequest = new StringBuilder();
        authRequest.append("POST /dir/index.html HTTP/1.1").append("\r\n");
        authRequest.append("Authorization: Digest username=\"Mufasa\",realm=\"testrealm@host.com\",nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",uri=\"/dir/index.html\",qop=auth,nc=00000001,cnonce=\"0a4f113b\",response=\"6629fae49393a05397450978507c4ef1\",opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"").append("\r\n");
        authRequest.append("Host: 192.168.0.1").append("\r\n");
        authRequest.append("Content-Length: 10").append("\r\n");
        authRequest.append("Connection: close").append("\r\n");
        authRequest.append("\r\n");
        authRequest.append("action=get");
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq(authRequest.toString().getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onGotHeaders((HashMap)EasyMock.anyObject());
        this.result.onRequestComplete(EasyMock.eq(200), EasyMock.aryEq("Hello world!".getBytes()));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.post(this.mac, new URL("http://Mufasa:Circle Of Life@192.168.0.1/dir/index.html"), null, "action=get".getBytes()));
        this.client.accepted(this.sessionId);
        String authenticateHeader = "WWW-Authenticate: Digest realm=\"testrealm@host.com\",qop=\"auth,auth-int\",nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"\r\n";
        String response = this.constructUnauthorizedResponse(authenticateHeader);
        this.client.received(this.sessionId, response.getBytes());
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 200 OK\r\nContent-Length: 12\r\n\r\nHello world!".getBytes());
        this.client.closed(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetSuccessfulShortResponseDigestAuthWithParts() throws MalformedURLException {
        EasyMock.expect(this.randomGenerator.generate()).andReturn("0a4f113b");
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq("GET /dir/index.html HTTP/1.1\r\nAuthorization: Basic TXVmYXNhOkNpcmNsZSBPZiBMaWZl\r\nHost: 192.168.0.1\r\nConnection: close\r\n\r\n".getBytes()))).andReturn(GDErrorCode.NoError);
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq("GET /dir/index.html HTTP/1.1\r\nAuthorization: Digest username=\"Mufasa\",realm=\"testrealm@host.com\",nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",uri=\"/dir/index.html\",qop=auth,nc=00000001,cnonce=\"0a4f113b\",response=\"6629fae49393a05397450978507c4ef1\",opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"\r\nHost: 192.168.0.1\r\nConnection: close\r\n\r\n".getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onGotHeaders((HashMap)EasyMock.anyObject());
        this.result.onRequestComplete(EasyMock.eq(200), EasyMock.aryEq("Hello world!".getBytes()));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.get(this.mac, new URL("http://Mufasa:Circle Of Life@192.168.0.1/dir/index.html")));
        this.client.accepted(this.sessionId);
        String part1 = "HTTP/1.0 401 Unauth";
        String part2 = "orized\r\nServer: HTTPd/0.9\r\nDate: Sun, 10 Apr 2005 20:26:47 GMT\r\nWWW-Authenticate: Digest realm=\"test";
        String part3 = "realm@host.com\",qop=\"auth,auth-int\",nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"\r\nContent-Type: text/html\r\nContent-Length: 310\r\n\r\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\r\n\"http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd\">\r\n<HTML>\r\n  <HEAD>\r\n    <TITLE>Erro";
        String part4 = "r</TITLE>\r\n    <META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=ISO-8859-1\">\r\n  </HEAD>\r\n  <BODY><H1>401 Unauthorized.</H1></BODY>\r\n</HTML>\r\n";
        this.client.received(this.sessionId, part1.getBytes());
        this.client.received(this.sessionId, part2.getBytes());
        this.client.received(this.sessionId, part3.getBytes());
        this.client.received(this.sessionId, part4.getBytes());
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 200 OK\r\nContent-L".getBytes());
        this.client.received(this.sessionId, "ength: 12\r\n\r\nHello world!".getBytes());
        this.client.closed(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testPostSuccessfulShortResponseDigestAuthWithParts() throws MalformedURLException {
        EasyMock.expect(this.randomGenerator.generate()).andReturn("0a4f113b");
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        StringBuilder noAuthRequest = new StringBuilder();
        noAuthRequest.append("POST /dir/index.html HTTP/1.1").append("\r\n");
        noAuthRequest.append("Authorization: Basic TXVmYXNhOkNpcmNsZSBPZiBMaWZl").append("\r\n");
        noAuthRequest.append("Host: 192.168.0.1").append("\r\n");
        noAuthRequest.append("Content-Length: 10").append("\r\n");
        noAuthRequest.append("Connection: close").append("\r\n");
        noAuthRequest.append("\r\n");
        noAuthRequest.append("action=get");
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq(noAuthRequest.toString().getBytes()))).andReturn(GDErrorCode.NoError);
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        StringBuilder authRequest = new StringBuilder();
        authRequest.append("POST /dir/index.html HTTP/1.1").append("\r\n");
        authRequest.append("Authorization: Digest username=\"Mufasa\",realm=\"testrealm@host.com\",nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",uri=\"/dir/index.html\",qop=auth,nc=00000001,cnonce=\"0a4f113b\",response=\"6629fae49393a05397450978507c4ef1\",opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"").append("\r\n");
        authRequest.append("Host: 192.168.0.1").append("\r\n");
        authRequest.append("Content-Length: 10").append("\r\n");
        authRequest.append("Connection: close").append("\r\n");
        authRequest.append("\r\n");
        authRequest.append("action=get");
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq(authRequest.toString().getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onGotHeaders((HashMap)EasyMock.anyObject());
        this.result.onRequestComplete(EasyMock.eq(200), EasyMock.aryEq("Hello world!".getBytes()));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.post(this.mac, new URL("http://Mufasa:Circle Of Life@192.168.0.1/dir/index.html"), null, "action=get".getBytes()));
        this.client.accepted(this.sessionId);
        String part1 = "HTTP/1.0 401 Unauth";
        String part2 = "orized\r\nServer: HTTPd/0.9\r\nDate: Sun, 10 Apr 2005 20:26:47 GMT\r\nWWW-Authenticate: Digest realm=\"test";
        String part3 = "realm@host.com\",qop=\"auth,auth-int\",nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"\r\nContent-Type: text/html\r\nContent-Length: 310\r\n\r\n<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\r\n\"http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd\">\r\n<HTML>\r\n  <HEAD>\r\n    <TITLE>Erro";
        String part4 = "r</TITLE>\r\n    <META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=ISO-8859-1\">\r\n  </HEAD>\r\n  <BODY><H1>401 Unauthorized.</H1></BODY>\r\n</HTML>\r\n";
        this.client.received(this.sessionId, part1.getBytes());
        this.client.received(this.sessionId, part2.getBytes());
        this.client.received(this.sessionId, part3.getBytes());
        this.client.received(this.sessionId, part4.getBytes());
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 200 OK\r\nContent-L".getBytes());
        this.client.received(this.sessionId, "ength: 12\r\n\r\nHello world!".getBytes());
        this.client.closed(this.sessionId);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUnsuccessfulAuth() throws MalformedURLException {
        log.debug("start testUnsuccessfulAuth");
        EasyMock.expect(this.randomGenerator.generate()).andReturn("0a4f113b");
        String authenticateHeader = "WWW-Authenticate: Digest realm=\"testrealm@host.com\",qop=\"auth,auth-int\",nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"\r\n";
        String response = this.constructUnauthorizedResponse(authenticateHeader);
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq("GET /dir/index.html HTTP/1.1\r\nAuthorization: Basic TXVmYXNhOkNpcmNsZSBPZiBMaWZl\r\nHost: 192.168.0.1\r\nConnection: close\r\n\r\n".getBytes()))).andReturn(GDErrorCode.NoError);
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq("GET /dir/index.html HTTP/1.1\r\nAuthorization: Digest username=\"Mufasa\",realm=\"testrealm@host.com\",nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",uri=\"/dir/index.html\",qop=auth,nc=00000001,cnonce=\"0a4f113b\",response=\"6629fae49393a05397450978507c4ef1\",opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"\r\nHost: 192.168.0.1\r\nConnection: close\r\n\r\n".getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onNoAccessError();
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.get(this.mac, new URL("http://Mufasa:Circle Of Life@192.168.0.1/dir/index.html")));
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, response.getBytes());
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, response.getBytes());
        PowerMock.verifyAll();
    }

    @Test
    public void testPostUnsuccessfulAuth() throws MalformedURLException {
        log.debug("start testUnsuccessfulAuth");
        EasyMock.expect(this.randomGenerator.generate()).andReturn("0a4f113b");
        String authenticateHeader = "WWW-Authenticate: Digest realm=\"testrealm@host.com\",qop=\"auth,auth-int\",nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"\r\n";
        String response = this.constructUnauthorizedResponse(authenticateHeader);
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        StringBuilder noAuthRequest = new StringBuilder();
        noAuthRequest.append("POST /dir/index.html HTTP/1.1").append("\r\n");
        noAuthRequest.append("Authorization: Basic TXVmYXNhOkNpcmNsZSBPZiBMaWZl").append("\r\n");
        noAuthRequest.append("Host: 192.168.0.1").append("\r\n");
        noAuthRequest.append("Content-Length: 10").append("\r\n");
        noAuthRequest.append("Connection: close").append("\r\n");
        noAuthRequest.append("\r\n");
        noAuthRequest.append("action=get");
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq(noAuthRequest.toString().getBytes()))).andReturn(GDErrorCode.NoError);
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        StringBuilder authRequest = new StringBuilder();
        authRequest.append("POST /dir/index.html HTTP/1.1").append("\r\n");
        authRequest.append("Authorization: Digest username=\"Mufasa\",realm=\"testrealm@host.com\",nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",uri=\"/dir/index.html\",qop=auth,nc=00000001,cnonce=\"0a4f113b\",response=\"6629fae49393a05397450978507c4ef1\",opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"").append("\r\n");
        authRequest.append("Host: 192.168.0.1").append("\r\n");
        authRequest.append("Content-Length: 10").append("\r\n");
        authRequest.append("Connection: close").append("\r\n");
        authRequest.append("\r\n");
        authRequest.append("action=get");
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq(authRequest.toString().getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onNoAccessError();
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.post(this.mac, new URL("http://Mufasa:Circle Of Life@192.168.0.1/dir/index.html"), null, "action=get".getBytes()));
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, response.getBytes());
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, response.getBytes());
        PowerMock.verifyAll();
    }

    private String constructUnauthorizedResponse(String authenticateHeader) {
        String response = "HTTP/1.0 401 Unauthorized\r\nServer: HTTPd/0.9\r\nDate: Sun, 10 Apr 2005 20:26:47 GMT\r\n" + authenticateHeader + "Content-Type: text/html\r\n" + "Content-Length: 310\r\n" + "\r\n" + "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\r\n" + "\"http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd\">\r\n" + "<HTML>\r\n" + "  <HEAD>\r\n" + "    <TITLE>Error</TITLE>\r\n" + "    <META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=ISO-8859-1\">\r\n" + "  </HEAD>\r\n" + "  <BODY><H1>401 Unauthorized.</H1></BODY>\r\n" + "</HTML>\r\n";
        return response;
    }

    @Test
    public void testSuccessfulResponseWithNonASCIICharaters() throws MalformedURLException {
        EasyMock.expect(this.tcpProxy.connect(EasyMock.eq(this.mac), EasyMock.eq("192.168.0.1"), EasyMock.eq(80), EasyMock.eq(this.client))).andReturn(this.sessionId);
        EasyMock.expect(this.tcpProxy.send(EasyMock.eq(this.sessionId), EasyMock.aryEq("GET / HTTP/1.1\r\nHost: 192.168.0.1\r\nConnection: close\r\n\r\n".getBytes()))).andReturn(GDErrorCode.NoError);
        this.result.onGotHeaders((HashMap)EasyMock.anyObject());
        this.result.onRequestComplete(EasyMock.eq(200), EasyMock.aryEq("system_info_language_i2='Espa\u00c3\u00b1ol'\nsystem_info_language_i3='Fran\u00c3\u00a7ais'\nsystem_info_language_i8='\u00e7\u00b9\u0081\u00e9\u00ab\u201d\u00e4\u00b8\u00ad\u00e6\u2013\u2021'\n".getBytes()));
        EasyMock.expect(this.tcpProxy.disconnect(this.sessionId)).andReturn(GDErrorCode.NoError);
        PowerMock.replayAll(new Object[0]);
        Assert.assertEquals(true, this.client.get(this.mac, new URL("http://192.168.0.1/")));
        this.client.accepted(this.sessionId);
        this.client.received(this.sessionId, "HTTP/1.1 200 OK\r\nContent-Length: 12\r\n\r\nsystem_info_language_i2='Espa\u00c3\u00b1ol'\nsystem_info_language_i3='Fran\u00c3\u00a7ais'\nsystem_info_language_i8='\u00e7\u00b9\u0081\u00e9\u00ab\u201d\u00e4\u00b8\u00ad\u00e6\u2013\u2021'\n".getBytes());
        this.client.closed(this.sessionId);
        PowerMock.verifyAll();
    }
}

