/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.UDPProxy;

import homemonitor.Application;
import homemonitor.GDErrorCode;
import homemonitor.GatewayDeviceConnectionInterface;
import homemonitor.UDPProxy.UDPProxyInterface;
import homemonitor.UDPProxy.UDPProxyResponseInterface;
import homemonitor.Utility;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class UDPProxy
extends Application
implements UDPProxyInterface {
    private static Logger log = Logger.getLogger(UDPProxy.class);
    private GatewayDeviceConnectionInterface gatewayDeviceConnection;
    private HashMap<Long, UDPProxyResponseInterface> responseHandlerMap = new HashMap();
    private HashMap<Long, Boolean> keepaliveMap = new HashMap();
    private Timer keepaliveCheckTimer = new Timer();
    static final int UDPKeepAlive = 67;
    static final int UDPKeepAliveResp = 68;
    static final int UDPBind = 69;

    public UDPProxy(GatewayDeviceConnectionInterface gatewayDeviceConnection) {
        this.gatewayDeviceConnection = gatewayDeviceConnection;
        this.keepaliveCheckTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                UDPProxy.this.removeDeadDevices();
            }
        }, 30000L, 30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sessionDisconnected(String deviceId, Long sessionId) {
        HashMap<Long, Object> hashMap = this.responseHandlerMap;
        synchronized (hashMap) {
            UDPProxyResponseInterface resp = this.responseHandlerMap.remove(sessionId);
            if (resp != null) {
                resp.deviceDisconnected(sessionId);
            }
        }
        hashMap = this.keepaliveMap;
        synchronized (hashMap) {
            this.keepaliveMap.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedData(String deviceId, int tag, long sessionId, byte[] data) {
        UDPProxyResponseInterface response;
        HashMap<Long, UDPProxyResponseInterface> hashMap = this.responseHandlerMap;
        synchronized (hashMap) {
            response = this.responseHandlerMap.get(sessionId);
        }
        if (tag == 0) {
            if (data[0] != 0) {
                log.warn("UDPProxy: got Status Error from GD.");
            }
            return;
        }
        if (response == null) {
            log.warn("UDPProxy: received response when session " + sessionId + " closed already");
            return;
        }
        if (tag == 67) {
            this.gatewayDeviceConnection.send(68, sessionId, null);
            this.keepaliveMap.put(sessionId, true);
            return;
        }
        if (data.length < 6) {
            log.warn("UDPProxy: received too short (" + data.length + "<6) response for session " + sessionId);
            return;
        }
        int srcAddress = Utility.byteArrayToInt(data, 0, 4);
        int srcPort = Utility.byteArrayToInt(data, 4, 2);
        int offset = 6;
        byte[] payload = new byte[data.length - 6];
        int i = 0;
        while (i < data.length - 6) {
            payload[i] = data[offset++];
            ++i;
        }
        response.received(srcAddress, srcPort, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long createSession(String deviceId, UDPProxyResponseInterface responseHandler) {
        long session = this.gatewayDeviceConnection.createSession(deviceId, this);
        if (session != 0L) {
            HashMap<Long, Object> hashMap = this.responseHandlerMap;
            synchronized (hashMap) {
                this.responseHandlerMap.put(session, responseHandler);
            }
            hashMap = this.keepaliveMap;
            synchronized (hashMap) {
                this.keepaliveMap.put(session, true);
            }
        }
        this.sessionAdd(deviceId, session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(long sessionId, int port) {
        HashMap<Long, UDPProxyResponseInterface> hashMap = this.responseHandlerMap;
        synchronized (hashMap) {
            if (!this.responseHandlerMap.containsKey(sessionId) || sessionId == 0L) {
                log.warn("Unable to send, no device connected for sessionId: " + sessionId);
                return;
            }
        }
        byte[] datagram = new byte[2];
        int offset = 0;
        byte[] portArray = Utility.intToByteArray(port);
        int i = 2;
        while (i < 4) {
            datagram[offset++] = portArray[i];
            ++i;
        }
        this.gatewayDeviceConnection.send(69, sessionId, datagram);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GDErrorCode send(long sessionId, long address, int dstPort, byte[] payload) {
        HashMap<Long, UDPProxyResponseInterface> hashMap = this.responseHandlerMap;
        synchronized (hashMap) {
            if (!this.responseHandlerMap.containsKey(sessionId) || sessionId == 0L) {
                log.warn("Unable to send, no device connected for sessionId: " + sessionId);
                return GDErrorCode.WrongSessionID;
            }
        }
        byte[] datagram = new byte[payload.length + 8];
        int offset = 0;
        byte[] addressArray = Utility.intToByteArray((int)address);
        int i = 0;
        while (i < 4) {
            datagram[offset++] = addressArray[i];
            ++i;
        }
        byte[] dstPortArray = Utility.intToByteArray(dstPort);
        int i2 = 2;
        while (i2 < 4) {
            datagram[offset++] = dstPortArray[i2];
            ++i2;
        }
        byte[] srcPortArray = Utility.intToByteArray(0);
        int i3 = 2;
        while (i3 < 4) {
            datagram[offset++] = srcPortArray[i3];
            ++i3;
        }
        i3 = 0;
        while (i3 < payload.length) {
            datagram[offset++] = payload[i3];
            ++i3;
        }
        GDErrorCode error = this.gatewayDeviceConnection.send(64, sessionId, datagram);
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GDErrorCode close(long sessionId) {
        HashMap<Long, Object> hashMap = this.responseHandlerMap;
        synchronized (hashMap) {
            if (!this.responseHandlerMap.containsKey(sessionId) || sessionId == 0L) {
                log.warn("Unable to close, no device connected for sessionId: " + sessionId);
                return GDErrorCode.WrongSessionID;
            }
            this.responseHandlerMap.remove(sessionId);
        }
        hashMap = this.keepaliveMap;
        synchronized (hashMap) {
            this.keepaliveMap.remove(sessionId);
        }
        GDErrorCode error = this.gatewayDeviceConnection.send(66, sessionId, new byte[0]);
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void removeDeadDevices() {
        it = null;
        var2_2 = this.keepaliveMap;
        synchronized (var2_2) {
            it = this.keepaliveMap.entrySet().iterator();
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
            if (true) ** GOTO lbl22
        }
        do {
            if ((entry = it.next()).getValue().booleanValue()) {
                var3_3 = this.keepaliveMap;
                synchronized (var3_3) {
                    this.keepaliveMap.put(entry.getKey(), false);
                }
            } else {
                this.close(entry.getKey());
            }
lbl22:
            // 3 sources

        } while (it.hasNext());
    }
}

