/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.UDPProxy;

import com.vestiacom.gdserver.rest.model.DiscoveredLanDevice;
import homemonitor.UDPProxy.LANDeviceDiscoveryNotification;
import homemonitor.UDPProxy.UDPProxyInterface;
import homemonitor.UDPProxy.VivotekCameraDiscovery;
import homemonitor.Utility;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.log4j.Logger;

public class NipcaCameraDiscovery
extends VivotekCameraDiscovery {
    private static Logger log = Logger.getLogger(NipcaCameraDiscovery.class);

    public NipcaCameraDiscovery(UDPProxyInterface udpProxy, LANDeviceDiscoveryNotification notification) {
        super(udpProxy, notification);
    }

    public NipcaCameraDiscovery(UDPProxyInterface udpProxy, LANDeviceDiscoveryNotification notification, boolean noTimers) {
        super(udpProxy, notification, noTimers);
    }

    @Override
    public void sendBroadcast() {
        int[] nArray = new int[22];
        nArray[0] = 253;
        nArray[1] = 253;
        nArray[4] = 161;
        nArray[6] = 255;
        nArray[7] = 255;
        nArray[8] = 255;
        nArray[9] = 255;
        nArray[10] = 255;
        nArray[11] = 255;
        nArray[18] = 1;
        int[] broadcastMessageValues = nArray;
        byte[] broadcastMessage = new byte[broadcastMessageValues.length];
        int i = 0;
        while (i < broadcastMessageValues.length) {
            broadcastMessage[i] = (byte)broadcastMessageValues[i];
            ++i;
        }
        log.debug("sending broadcast: " + broadcastMessageValues);
        this.udpProxy.send(this.sessionId, -1L, 62976, broadcastMessage);
    }

    @Override
    public void received(int srcAddress, int srcPort, byte[] data) {
        boolean idOffset = false;
        int opcodeOffset = 4;
        int pverOffset = 18;
        int lenOffset = 20;
        ByteBuffer dataBuffer = ByteBuffer.wrap(data);
        dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (data.length != 334 || dataBuffer.getShort(20) != 312) {
            log.debug("dropping packet: bad length");
            return;
        }
        if (dataBuffer.getShort(0) != -274) {
            log.debug("dropping packet: bad id");
            return;
        }
        if (dataBuffer.getShort(4) != 161) {
            log.debug("dropping packet: bad opcode");
            return;
        }
        if (dataBuffer.getShort(18) != 1) {
            log.debug("dropping packet: bad pversion");
            return;
        }
        String mac = null;
        String name = null;
        String ipAddress = null;
        int port = 0;
        int macOffset = 220;
        int nameOffset = 226;
        int ipOffset = 290;
        int portOffset = 294;
        int macSize = 6;
        int ipSize = 4;
        mac = Utility.byteArrayToHexString(data, 220, 6, ":");
        name = Utility.byteArrayASCIIToString(data, 226);
        ipAddress = Utility.byteArrayToString(data, 290, 4, ".");
        port = data[294] + 256 * data[295];
        log.debug("got correct LANDAP response: mac: " + mac + " name: " + name + " ip: " + ipAddress + " port: " + port);
        if (name != null && mac != null) {
            DiscoveredLanDevice dev = new DiscoveredLanDevice(mac, ipAddress, name);
            dev.setPort(port);
            if (!this.foundDevices.containsKey(mac)) {
                this.foundDevices.put(mac, dev);
                dev.setDeviceDriver("CameraNipcaGeneric");
                if (this.notification != null) {
                    this.notification.foundNewLANDevice(dev);
                }
            }
        }
    }
}

