/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.HTTPClient;

import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import homemonitor.HTTPClient.HTTPClient;
import homemonitor.HTTPClient.HTTPClientResult;
import homemonitor.HTTPClient.RandomGenerator;
import homemonitor.TCPProxy.TCPProxyInterface;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class HTTPClientService
implements HTTPClientResult {
    private static Logger log = Logger.getLogger(HTTPClientService.class);
    private HTTPClient httpClient;
    private CountDownLatch latch;
    private HTTPClientServiceResult response;
    private long timeout = 10L;

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public HTTPClientService(TCPProxyInterface tcpProxy) {
        log.trace("HTTPClientService tcpProxy: " + tcpProxy);
        this.httpClient = new HTTPClient(tcpProxy, this);
        this.response = new HTTPClientServiceResult();
    }

    public HTTPClientServiceResult get(String deviceId, URL url) {
        this.latch = new CountDownLatch(1);
        this.httpClient.setRandomGenerator(new RandomGenerator());
        if (!this.httpClient.get(deviceId, url)) {
            this.response.setResult(HTTPClientServiceResult.Result.NOANSWER);
            return this.response;
        }
        try {
            this.latch.await(this.timeout, TimeUnit.SECONDS);
            if (this.latch.getCount() > 0L) {
                log.debug("HTTPClientService has timed out while waiting for response from device with id = " + deviceId + " (url=" + url + ")");
                this.response.setResult(HTTPClientServiceResult.Result.NOANSWER);
                this.response.setStatusCode(this.httpClient.getStatusCode());
                this.httpClient.cancel();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.response;
    }

    public HTTPClientServiceResult post(String deviceId, URL url) {
        return this.post(deviceId, url, null, url.getQuery().getBytes());
    }

    public HTTPClientServiceResult post(String deviceId, URL url, Map<String, String> additionalRequestHeaders, byte[] body) {
        this.latch = new CountDownLatch(1);
        this.httpClient.setRandomGenerator(new RandomGenerator());
        if (!this.httpClient.post(deviceId, url, additionalRequestHeaders, body)) {
            this.response.setResult(HTTPClientServiceResult.Result.NOANSWER);
            return this.response;
        }
        try {
            this.latch.await(this.timeout, TimeUnit.SECONDS);
            if (this.latch.getCount() > 0L) {
                log.debug("HTTPClientService has timed out while waiting for response from device with id = " + deviceId + " (url=" + url + ")");
                this.response.setResult(HTTPClientServiceResult.Result.NOANSWER);
                this.response.setStatusCode(this.httpClient.getStatusCode());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.response;
    }

    @Override
    public void onNoAccessError() {
        log.warn("HTTPClientService got no access error");
        this.response.setResult(HTTPClientServiceResult.Result.NOACCESS);
        this.latch.countDown();
    }

    @Override
    public void onHttpError(int statusCode, byte[] content) {
        log.warn("HTTPClientService got http error: " + statusCode);
        this.response.setResult(HTTPClientServiceResult.Result.ERROR);
        this.response.setStatusCode(statusCode);
        this.response.setBody(content);
        this.latch.countDown();
    }

    @Override
    public void onError(byte[] content) {
        log.debug("HTTPClientService got other error");
        this.response.setResult(HTTPClientServiceResult.Result.ERROR);
        this.response.setBody(content);
        this.latch.countDown();
    }

    @Override
    public void onGotHeaders(HashMap<String, String> headers) {
    }

    @Override
    public void onRequestComplete(int statusCode, byte[] content) {
        this.response.setStatusCode(statusCode);
        this.response.setBody(content);
        this.latch.countDown();
    }
}

