/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.GDUpdate;

import homemonitor.GDUpdate.UpdateServerCmdInterface;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class UpdateServer {
    private static Logger log = Logger.getLogger(UpdateServer.class);
    private DatagramChannel server;
    private Selector selector;
    UpdateServerCmdInterface receiver;
    final int Port;
    final int BufferSize = 2048;
    final String IPAddress;
    boolean running;
    private Thread networkThread = new Thread(){

        @Override
        public void run() {
            super.setName("GDServerBackendCommThread");
            UpdateServer.this.running = true;
            try {
                while (UpdateServer.this.running) {
                    UpdateServer.this.listen();
                }
                UpdateServer.this.server.socket().close();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    };

    public void beanDestroyed() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.selector.wakeup();
        this.networkThread.interrupt();
        try {
            this.networkThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void listen() throws Exception {
        if (this.selector.select() == 0) {
            return;
        }
        Set<SelectionKey> keys = this.selector.selectedKeys();
        Iterator<SelectionKey> i = keys.iterator();
        while (i.hasNext()) {
            ByteBuffer response;
            ByteBuffer buffer;
            DatagramChannel client;
            InetSocketAddress clientAddress;
            SelectionKey key = i.next();
            i.remove();
            if (!key.isReadable() || !(key.channel() instanceof DatagramChannel) || (clientAddress = (InetSocketAddress)(client = (DatagramChannel)key.channel()).receive(buffer = ByteBuffer.allocate(2048))) == null || this.receiver == null || (response = this.receiver.process(clientAddress.getAddress().getHostAddress(), buffer)) == null) continue;
            client.send(response, clientAddress);
        }
    }

    public UpdateServer(String ip, int port, UpdateServerCmdInterface receiver) {
        log.debug("UpdateServer: ip: " + ip + ", port: " + port + ", receiver: " + receiver);
        this.receiver = receiver;
        this.IPAddress = ip;
        this.Port = port;
        if (port == 0) {
            log.debug("UpdateServer: disabled, not starting");
            return;
        }
        try {
            this.server = DatagramChannel.open();
            this.server.socket().setReuseAddress(true);
            this.server.configureBlocking(false);
            this.server.socket().setReuseAddress(true);
            this.server.socket().bind(new InetSocketAddress(this.IPAddress, this.Port));
            this.selector = Selector.open();
            this.server.register(this.selector, 1);
            this.networkThread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

