/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.util;

public class Version
implements Comparable<Version> {
    private int major;
    private int minor;
    private int micro;

    public Version(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public Version(String value) throws IllegalArgumentException {
        String[] parts = value.split("\\.");
        if (parts.length != 3) {
            throw new IllegalArgumentException(value);
        }
        this.major = Integer.valueOf(parts[0]);
        this.minor = Integer.valueOf(parts[1]);
        this.micro = Integer.valueOf(parts[2]);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        return this.toString().equals(other.toString());
    }

    public String toString() {
        return String.valueOf(this.major) + "." + this.minor + "." + this.micro;
    }

    @Override
    public int compareTo(Version other) {
        int diff = this.major - other.major;
        if (diff != 0) {
            return diff;
        }
        diff = this.minor - other.minor;
        if (diff != 0) {
            return diff;
        }
        return this.micro - other.micro;
    }
}

