/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import com.vestiacom.gdserver.service.SystemSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SystemSupportImpl
implements SystemSupport {
    private static Logger log = Logger.getLogger(SystemSupportImpl.class);

    @Override
    public ProcessBuilder getProcessBuilder(List<String> command) {
        return new ProcessBuilder(command);
    }

    @Override
    public File getFile(String filename) {
        return new File(filename);
    }

    @Override
    public boolean deleteFile(String filename) {
        File file = new File(filename);
        if (file.exists()) {
            log.debug("deleting file: " + filename);
            return file.delete();
        }
        log.debug("tried to delete file: " + filename + ", but file doesn't exit");
        return false;
    }

    @Override
    public Date getCurrentDate() {
        return new Date();
    }

    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public boolean saveFile(String filename, byte[] file) {
        log.debug("start saveFile(filename=" + filename + " ,file=" + file + ")");
        if (filename == null || filename.isEmpty()) {
            log.warn("Atempt to save file with empty name.");
            return false;
        }
        if (file == null) {
            log.warn("Attempt to save null file.");
            return false;
        }
        try {
            log.info("Saving file with name '" + filename + "' with size '" + file.length + "'.");
            FileOutputStream os = new FileOutputStream(filename);
            ((OutputStream)os).write(file);
            ((OutputStream)os).close();
            return true;
        }
        catch (IOException e) {
            log.warn("Failed to save file with name '" + filename + "' and size '" + file.length + "': " + e.getMessage() + ".");
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public byte[] readFile(String filename) {
        if (filename == null || filename.isEmpty()) {
            log.warn("Filename is empty");
            return null;
        }
        File file = new File(filename);
        if (!this.isFileReadable(file)) {
            log.warn("Can not read file '" + file.getPath() + "'.");
            return null;
        }
        try {
            FileInputStream inputStream = new FileInputStream(file);
            byte[] buffer = new byte[(int)file.length()];
            inputStream.read(buffer);
            inputStream.close();
            return buffer;
        }
        catch (IOException e) {
            log.error("Failed to read file '" + file.getPath() + "': " + e.getMessage());
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private boolean isFileReadable(File file) {
        if (file == null) {
            return false;
        }
        return file.exists() && file.isFile() && file.canRead();
    }

    @Override
    public boolean renameFile(String oldName, String newName) {
        File oldFile = new File(oldName);
        if (!oldFile.exists()) {
            log.warn("file doesn't exist: " + oldName);
            return false;
        }
        return oldFile.renameTo(new File(newName));
    }
}

