/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service;

import com.vestiacom.gdserver.rest.model.DiscoveredLanDevice;
import homemonitor.UDPProxy.LANDeviceDiscoveryNotification;
import homemonitor.UDPProxy.UDPProxyInterface;
import homemonitor.UDPProxy.VivotekCameraDiscovery;
import java.util.concurrent.CountDownLatch;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class VivotekCameraIpAddressDiscoveryService
implements LANDeviceDiscoveryNotification {
    private UDPProxyInterface udpProxy;
    private CountDownLatch latch;
    private String macAddress;
    private String ipAddress;

    @Autowired
    public VivotekCameraIpAddressDiscoveryService(UDPProxyInterface udpProxy) {
        this.udpProxy = udpProxy;
    }

    public String getCameraIpAddress(String deviceId, String cameraMacAddress) {
        this.macAddress = cameraMacAddress;
        VivotekCameraDiscovery discoverer = new VivotekCameraDiscovery(this.udpProxy, this);
        this.latch = new CountDownLatch(1);
        discoverer.discover(deviceId);
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.ipAddress;
    }

    @Override
    public void foundNewLANDevice(DiscoveredLanDevice dev) {
        if (dev.getMac().equals(this.macAddress)) {
            this.ipAddress = dev.getIpAddress();
            this.latch.countDown();
        }
    }

    @Override
    public void discoveryFinished() {
        this.latch.countDown();
    }

    @Override
    public void discoveryError() {
        this.latch.countDown();
    }
}

