/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.rest;

import com.google.gson.Gson;
import com.vestiacom.gdserver.rest.response.Response;
import com.vestiacom.gdserver.util.Utils;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnection;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component
public class RestFilter
extends GenericFilterBean {
    private static Logger log = Logger.getLogger(RestFilter.class);
    private GatewayDeviceConnection deviceConnection;
    private String restUrl;

    @Autowired
    @Required
    public void setDeviceConnection(GatewayDeviceConnection deviceConnection) {
        this.deviceConnection = deviceConnection;
    }

    @Autowired
    @Required
    @Value(value="${GDConnection.restUrl}")
    public void setServerUrl(String restUrl) {
        this.restUrl = restUrl;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.isExcluded(httpRequest.getRequestURI())) {
            log.trace("Detected excluded request...");
            chain.doFilter(request, response);
            return;
        }
        String deviceId = this.getDeviceId(httpRequest.getRequestURI());
        if (deviceId == null) {
            log.warn("Not found deviceId for url=" + httpRequest.getRequestURI());
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.sendError(404);
            return;
        }
        GatewayDevice device = this.deviceConnection.findById(deviceId);
        if (device == null) {
            log.trace("Device with deviceId=" + deviceId + " is not connected to this node.");
            String serverUrl = this.deviceConnection.getServerUrl(deviceId);
            Response restResponse = null;
            if (serverUrl == null || serverUrl.equals(this.restUrl)) {
                log.trace("Device with deviceId=" + deviceId + " is not connected to cluster.");
                restResponse = new Response(Response.Status.CLUSTER_NOT_CONNECTED);
            } else {
                log.trace("Device with deviceId=" + deviceId + " is (or was last time) connected to another node: " + serverUrl);
                restResponse = new Response(serverUrl);
            }
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            Gson gson = new Gson();
            writer.println(gson.toJson(restResponse));
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isExcluded(String requestUri) {
        return requestUri.endsWith("/serverUrl") || requestUri.endsWith("/registered");
    }

    private String getDeviceId(String url) {
        log.trace("start getDeviceId(url=" + url + ")");
        if (Utils.isBlank(url)) {
            log.trace("Blank url");
            return null;
        }
        String startPattern = "/device/";
        if (!url.contains(startPattern)) {
            log.trace("Missing /device/ element in url");
            return null;
        }
        String deviceId = url.substring(url.indexOf(startPattern) + startPattern.length());
        int endPatternIndex = deviceId.indexOf("/");
        if (endPatternIndex > -1) {
            deviceId = deviceId.substring(0, endPatternIndex);
        }
        return deviceId;
    }
}

