/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.rest;

import com.vestiacom.gdserver.GDServer;
import com.vestiacom.gdserver.connector.AppServerConnector;
import com.vestiacom.gdserver.db.dao.DaoFactory;
import com.vestiacom.gdserver.db.dao.SessionDao;
import com.vestiacom.gdserver.rest.RESTService;
import com.vestiacom.gdserver.rest.model.DiscoverDeviceResponse;
import com.vestiacom.gdserver.rest.model.DomainName;
import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.model.LoggerConfigurationStatus;
import com.vestiacom.gdserver.rest.model.Make;
import com.vestiacom.gdserver.rest.model.SetUpUpnpForwardingResult;
import com.vestiacom.gdserver.rest.response.AddDomainNameResponse;
import com.vestiacom.gdserver.rest.response.CommandResult;
import com.vestiacom.gdserver.rest.response.ConfigureLoggerResponse;
import com.vestiacom.gdserver.rest.response.CreateTcpProxyResponse;
import com.vestiacom.gdserver.rest.response.DiscoverCameraIpAddressResponse;
import com.vestiacom.gdserver.rest.response.ExecuteCommandResponse;
import com.vestiacom.gdserver.rest.response.ExecuteHttpCommandResponse;
import com.vestiacom.gdserver.rest.response.ForceUpgradeResponse;
import com.vestiacom.gdserver.rest.response.GatewayDevice;
import com.vestiacom.gdserver.rest.response.GetDeviceResponse;
import com.vestiacom.gdserver.rest.response.GetDeviceServerUrlResponse;
import com.vestiacom.gdserver.rest.response.GetDomainNameResponse;
import com.vestiacom.gdserver.rest.response.GetVersionResponse;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import com.vestiacom.gdserver.rest.response.RemoveDomainNameResponse;
import com.vestiacom.gdserver.rest.response.Response;
import com.vestiacom.gdserver.rest.response.SearchCandidatesResponse;
import com.vestiacom.gdserver.rest.response.SetRegisteredResponse;
import com.vestiacom.gdserver.rest.response.SetUpUpnpForwardingResponse;
import com.vestiacom.gdserver.service.CameraDiscoveryService;
import com.vestiacom.gdserver.service.DomainNameService;
import com.vestiacom.gdserver.service.ServiceFactory;
import com.vestiacom.gdserver.service.TestService;
import com.vestiacom.gdserver.service.VivotekCameraIpAddressDiscoveryService;
import com.vestiacom.gdserver.service.impl.DomainNameValue;
import com.vestiacom.gdserver.service.impl.UpnpPortForwardingServiceImpl;
import com.vestiacom.gdserver.util.Utils;
import homemonitor.GatewayDeviceConnection;
import homemonitor.HTTPClient.HTTPClientService;
import homemonitor.ICETransport.Candidates;
import homemonitor.ICETransport.IceTransportService;
import homemonitor.TCPProxy.TCPProxy;
import homemonitor.TCPProxy.TCPProxyApp;
import homemonitor.execcmd.CmdResult;
import homemonitor.execcmd.ExecCmdService;
import homemonitor.logs.LoggerConfiguratorService;
import homemonitor.tcpclient.TCPClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={RESTService.class, Utils.class, GetDeviceResponse.class, GetDeviceServerUrlResponse.class, ForceUpgradeResponse.class, ExecuteCommandResponse.class, CommandResult.class, SearchCandidatesResponse.class, URL.class, ExecuteHttpCommandResponse.class, Base64.class, ConfigureLoggerResponse.class, DiscoverCameraIpAddressResponse.class, DiscoverDeviceResponse.class, Make.class, SetUpUpnpForwardingResponse.class, SetRegisteredResponse.class, AddDomainNameResponse.class, GetDomainNameResponse.class, DomainName.class, RemoveDomainNameResponse.class, GetVersionResponse.class, GDServer.class})
public class RESTServiceTest {
    private RESTService restService;
    private TestService testService;
    private GatewayDeviceConnection gatewayDeviceConnection;
    private TCPProxy tcpProxy;
    private TCPClient tcpClient;
    private ServiceFactory serviceFactory;
    private DaoFactory daoFactory;
    private SessionDao sessionDao;
    private DomainNameService domainNameService;
    private AppServerConnector appServerConnector;

    @Before
    public void setUp() {
        this.restService = new RESTService();
        this.testService = PowerMock.createMock(TestService.class);
        this.restService.setTestService(this.testService);
        this.gatewayDeviceConnection = PowerMock.createMock(GatewayDeviceConnection.class);
        this.restService.setGatewayDeviceConnection(this.gatewayDeviceConnection);
        this.tcpProxy = PowerMock.createMock(TCPProxy.class);
        this.restService.setTcpProxy(this.tcpProxy);
        this.tcpClient = PowerMock.createMock(TCPClient.class);
        this.restService.setTcpClient(this.tcpClient);
        this.serviceFactory = PowerMock.createMock(ServiceFactory.class);
        this.restService.setServiceFactory(this.serviceFactory);
        this.daoFactory = PowerMock.createMock(DaoFactory.class);
        this.restService.setDaoFactory(this.daoFactory);
        this.sessionDao = PowerMock.createMock(SessionDao.class);
        this.restService.setSessionDao(this.sessionDao);
        this.domainNameService = PowerMock.createMock(DomainNameService.class);
        this.restService.setDomainNameService(this.domainNameService);
        this.appServerConnector = PowerMock.createMock(AppServerConnector.class);
        this.restService.setAppServerConnector(this.appServerConnector);
        PowerMock.mockStatic(Utils.class);
        PowerMock.mockStatic(Base64.class);
        PowerMock.mockStatic(Make.class);
    }

    @Test
    public void testInitialize() {
        EasyMock.expect(this.daoFactory.getSessionDao()).andReturn(this.sessionDao);
        PowerMock.replayAll(new Object[0]);
        this.restService.initialize();
        PowerMock.verifyAll();
    }

    @Test
    public void testTestHttpClinet() {
        EasyMock.expect(this.testService.testhttpClient()).andReturn("testResponse");
        PowerMock.replayAll(new Object[0]);
        this.restService.testhttpClient();
        PowerMock.verifyAll();
    }

    @Test
    public void testProxy() {
        String mac = "testMac";
        String url = "testUrl";
        EasyMock.expect(this.testService.proxy(mac, url)).andReturn("testResponse");
        PowerMock.replayAll(new Object[0]);
        this.restService.proxy(mac, url);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        homemonitor.GatewayDevice device = PowerMock.createMock(homemonitor.GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(deviceId)).andReturn(device);
        GatewayDevice model = PowerMock.createMock(GatewayDevice.class);
        PowerMock.expectNew(GatewayDevice.class, new Object[0]).andReturn(model);
        String mac = "testMac";
        String publicIpAddress = "testPublicIpAddress";
        String localIpAddress = "testLocalIpAddress";
        int versionMajor = 1;
        int versionMinor = 2;
        int buildNo = 123;
        int deviceType = 3;
        long lastAlive = 12345L;
        Date connectedDate = new Date();
        boolean encryptedControlConnection = true;
        boolean gateway = false;
        boolean embedded = true;
        boolean nas = false;
        boolean stargate = false;
        EasyMock.expect(device.getMac()).andReturn(mac);
        model.setMac(mac);
        EasyMock.expect(device.getPublicIpAddress()).andReturn(publicIpAddress);
        model.setPublicIpAddress(publicIpAddress);
        EasyMock.expect(device.getLocalIpAddress()).andReturn(localIpAddress);
        model.setLocalIpAddress(localIpAddress);
        EasyMock.expect(device.getVersionMajor()).andReturn(versionMajor);
        model.setVersionMajor(versionMajor);
        EasyMock.expect(device.getVersionMinor()).andReturn(versionMinor);
        model.setVersionMinor(versionMinor);
        EasyMock.expect(device.getBuildNo()).andReturn(buildNo);
        model.setBuildNo(buildNo);
        EasyMock.expect(device.getDeviceType()).andReturn(deviceType);
        model.setDeviceType(deviceType);
        EasyMock.expect(device.getLastAlive()).andReturn(lastAlive);
        model.setLastAlive(lastAlive);
        EasyMock.expect(device.getConnectedDate()).andReturn(connectedDate);
        model.setConnectedDate(connectedDate);
        EasyMock.expect(device.isEncryptedControlConnection()).andReturn(encryptedControlConnection);
        model.setEncryptedControlConnection(encryptedControlConnection);
        EasyMock.expect(device.isGateway()).andReturn(gateway);
        model.setGateway(gateway);
        EasyMock.expect(device.isEmbedded()).andReturn(embedded);
        model.setEmbedded(embedded);
        EasyMock.expect(device.isNAS()).andReturn(nas);
        model.setNas(nas);
        EasyMock.expect(device.isStargate()).andReturn(stargate);
        model.setStargate(stargate);
        GetDeviceResponse response = PowerMock.createMock(GetDeviceResponse.class);
        PowerMock.expectNew(GetDeviceResponse.class, model).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        GetDeviceResponse actual = this.restService.getDevice(deviceId);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceAnotherNodeConnected() throws Exception {
        String deviceId = "testDeviceId";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(this.gatewayDeviceConnection.findById(deviceId)).andReturn(null);
        String deviceServerUrl = "testdeviceServerUrl";
        EasyMock.expect(this.gatewayDeviceConnection.getServerUrl(deviceId)).andReturn(deviceServerUrl);
        GetDeviceResponse response = PowerMock.createMock(GetDeviceResponse.class);
        PowerMock.expectNew(GetDeviceResponse.class, deviceServerUrl).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        GetDeviceResponse actual = this.restService.getDevice(deviceId);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceClusterNotConnected() throws Exception {
        String deviceId = "testDeviceId";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(this.gatewayDeviceConnection.findById(deviceId)).andReturn(null);
        EasyMock.expect(this.gatewayDeviceConnection.getServerUrl(deviceId)).andReturn(null);
        GetDeviceResponse response = PowerMock.createMock(GetDeviceResponse.class);
        PowerMock.expectNew(GetDeviceResponse.class, new Object[]{Response.Status.CLUSTER_NOT_CONNECTED}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        GetDeviceResponse actual = this.restService.getDevice(deviceId);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceNoDeviceId() throws Exception {
        String deviceId = null;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(true);
        GetDeviceResponse response = PowerMock.createMock(GetDeviceResponse.class);
        PowerMock.expectNew(GetDeviceResponse.class, new Object[]{GetDeviceResponse.ErrorCode.NO_DEVICE_ID}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        GetDeviceResponse actual = this.restService.getDevice(deviceId);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceServerUrlSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        String deviceServerUrl = "testDeviceServerUrl";
        EasyMock.expect(this.gatewayDeviceConnection.getServerUrl(deviceId)).andReturn(deviceServerUrl);
        GetDeviceServerUrlResponse response = PowerMock.createMock(GetDeviceServerUrlResponse.class);
        PowerMock.expectNew(GetDeviceServerUrlResponse.class, deviceServerUrl).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        GetDeviceServerUrlResponse actual = this.restService.getDeviceServerUrl(deviceId);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceServerUrlClusterNotConnected() throws Exception {
        String deviceId = "testDeviceId";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(this.gatewayDeviceConnection.getServerUrl(deviceId)).andReturn(null);
        GetDeviceServerUrlResponse response = PowerMock.createMock(GetDeviceServerUrlResponse.class);
        PowerMock.expectNew(GetDeviceServerUrlResponse.class, new Object[]{Response.Status.CLUSTER_NOT_CONNECTED}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        GetDeviceServerUrlResponse actual = this.restService.getDeviceServerUrl(deviceId);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceServerUrlNoDviceId() throws Exception {
        String deviceId = null;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(true);
        GetDeviceServerUrlResponse response = PowerMock.createMock(GetDeviceServerUrlResponse.class);
        PowerMock.expectNew(GetDeviceServerUrlResponse.class, new Object[]{GetDeviceServerUrlResponse.ErrorCode.NO_DEVICE_ID}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        GetDeviceServerUrlResponse actual = this.restService.getDeviceServerUrl(deviceId);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgradeSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        homemonitor.GatewayDevice device = PowerMock.createMock(homemonitor.GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(deviceId)).andReturn(device);
        this.gatewayDeviceConnection.forceUpgrade(deviceId);
        ForceUpgradeResponse response = PowerMock.createMock(ForceUpgradeResponse.class);
        PowerMock.expectNew(ForceUpgradeResponse.class, new Object[]{Response.Status.SUCCESS}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ForceUpgradeResponse actual = this.restService.forceUpgrade(deviceId);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgradeDeviceNotConnected() throws Exception {
        String deviceId = "testDeviceId";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(this.gatewayDeviceConnection.findById(deviceId)).andReturn(null);
        ForceUpgradeResponse response = PowerMock.createMock(ForceUpgradeResponse.class);
        PowerMock.expectNew(ForceUpgradeResponse.class, new Object[]{ForceUpgradeResponse.ErrorCode.DEVICE_NOT_CONNECTED}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ForceUpgradeResponse actual = this.restService.forceUpgrade(deviceId);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgradeNoDeviceId() throws Exception {
        String deviceId = null;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(true);
        ForceUpgradeResponse response = PowerMock.createMock(ForceUpgradeResponse.class);
        PowerMock.expectNew(ForceUpgradeResponse.class, new Object[]{ForceUpgradeResponse.ErrorCode.NO_DEVICE_ID}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ForceUpgradeResponse actual = this.restService.forceUpgrade(deviceId);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecuteCmdSucccessfully() throws Exception {
        String deviceId = "testDeviceId";
        String command = "testCommand";
        Long timeout = 10000L;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(command)).andReturn(false);
        ExecCmdService cmdService = PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect(this.serviceFactory.getExecCmdService(timeout)).andReturn(cmdService);
        CmdResult cmdResult = PowerMock.createMock(CmdResult.class);
        EasyMock.expect(cmdService.executeCommand(deviceId, command)).andReturn(cmdResult);
        CommandResult commandResult = PowerMock.createMock(CommandResult.class);
        EasyMock.expect(cmdResult.getOutput()).andReturn("testOutput");
        EasyMock.expect(cmdResult.getStatusCode()).andReturn(1);
        PowerMock.expectNew(CommandResult.class, "testOutput", 1).andReturn(commandResult);
        ExecuteCommandResponse response = PowerMock.createMock(ExecuteCommandResponse.class);
        PowerMock.expectNew(ExecuteCommandResponse.class, new Object[]{Response.Status.SUCCESS, commandResult}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ExecuteCommandResponse actual = this.restService.executeCmd(deviceId, command, timeout);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecuteCmdFailure() throws Exception {
        String deviceId = "testDeviceId";
        String command = "testCommand";
        Long timeout = 10000L;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(command)).andReturn(false);
        ExecCmdService cmdService = PowerMock.createMock(ExecCmdService.class);
        EasyMock.expect(this.serviceFactory.getExecCmdService(timeout)).andReturn(cmdService);
        EasyMock.expect(cmdService.executeCommand(deviceId, command)).andReturn(null);
        ExecuteCommandResponse response = PowerMock.createMock(ExecuteCommandResponse.class);
        PowerMock.expectNew(ExecuteCommandResponse.class, new Object[]{Response.Status.FAILURE}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ExecuteCommandResponse actual = this.restService.executeCmd(deviceId, command, timeout);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecuteCmdBlankCommand() throws Exception {
        String deviceId = "testDeviceId";
        String command = "";
        Long timeout = 10000L;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(command)).andReturn(true);
        ExecuteCommandResponse response = PowerMock.createMock(ExecuteCommandResponse.class);
        PowerMock.expectNew(ExecuteCommandResponse.class, new Object[]{ExecuteCommandResponse.ErrorCode.NO_COMMAND}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ExecuteCommandResponse actual = this.restService.executeCmd(deviceId, command, timeout);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecuteCmdBlankDeviceId() throws Exception {
        String deviceId = "";
        String command = "testCommand";
        Long timeout = 10000L;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(true);
        ExecuteCommandResponse response = PowerMock.createMock(ExecuteCommandResponse.class);
        PowerMock.expectNew(ExecuteCommandResponse.class, new Object[]{ExecuteCommandResponse.ErrorCode.NO_DEVICE_ID}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ExecuteCommandResponse actual = this.restService.executeCmd(deviceId, command, timeout);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = "testStunAddr";
        Integer stunPort = 1;
        String turnAddr = "testTurnAddr";
        Integer turnPort = 2;
        String turnUser = "testUser";
        String turnPass = "testPass";
        String candidates = "testCandidates";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(stunAddr)).andReturn(false);
        EasyMock.expect(Utils.isBlank(candidates)).andReturn(false);
        IceTransportService iceTransportService = PowerMock.createMock(IceTransportService.class);
        EasyMock.expect(this.serviceFactory.getIceTransportService()).andReturn(iceTransportService);
        Candidates foundCandidates = PowerMock.createMock(Candidates.class);
        EasyMock.expect(iceTransportService.execute(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates)).andReturn(foundCandidates);
        String cand = "!@#$%^";
        Integer startPort = 1;
        Integer endPort = 9;
        EasyMock.expect(foundCandidates.getCandidates()).andReturn(cand);
        EasyMock.expect(foundCandidates.getPortRangeStart()).andReturn(startPort);
        EasyMock.expect(foundCandidates.getPortRangeEnd()).andReturn(endPort);
        SearchCandidatesResponse response = PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, cand, startPort, endPort).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesFailure() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = "testStunAddr";
        Integer stunPort = 1;
        String turnAddr = "testTurnAddr";
        Integer turnPort = 2;
        String turnUser = "testUser";
        String turnPass = "testPass";
        String candidates = "testCandidates";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(stunAddr)).andReturn(false);
        EasyMock.expect(Utils.isBlank(candidates)).andReturn(false);
        IceTransportService iceTransportService = PowerMock.createMock(IceTransportService.class);
        EasyMock.expect(this.serviceFactory.getIceTransportService()).andReturn(iceTransportService);
        EasyMock.expect(iceTransportService.execute(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates)).andReturn(null);
        SearchCandidatesResponse response = PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, new Object[]{SearchCandidatesResponse.ErrorCode.ERROR}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesBlankCanidates() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = "testStunAddr";
        Integer stunPort = 1;
        String turnAddr = "testTurnAddr";
        Integer turnPort = 2;
        String turnUser = "testUser";
        String turnPass = "testPass";
        String candidates = "";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(stunAddr)).andReturn(false);
        EasyMock.expect(Utils.isBlank(candidates)).andReturn(true);
        SearchCandidatesResponse response = PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, new Object[]{SearchCandidatesResponse.ErrorCode.NO_CONDIDATES}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesNullTurnPass() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = "testStunAddr";
        Integer stunPort = 1;
        String turnAddr = "testTurnAddr";
        Integer turnPort = 2;
        String turnUser = "testUser";
        String turnPass = null;
        String candidates = "testCandidates";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(stunAddr)).andReturn(false);
        SearchCandidatesResponse response = PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, new Object[]{SearchCandidatesResponse.ErrorCode.NO_TURN_PASS}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesNullTurnUser() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = "testStunAddr";
        Integer stunPort = 1;
        String turnAddr = "testTurnAddr";
        Integer turnPort = 2;
        String turnUser = null;
        String turnPass = "testTurnPass";
        String candidates = "testCandidates";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(stunAddr)).andReturn(false);
        SearchCandidatesResponse response = PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, new Object[]{SearchCandidatesResponse.ErrorCode.NO_TURN_USER}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesNullTurnPort() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = "testStunAddr";
        Integer stunPort = 1;
        String turnAddr = "testTurnAddr";
        Integer turnPort = null;
        String turnUser = "testTurnUser";
        String turnPass = "testTurnPass";
        String candidates = "testCandidates";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(stunAddr)).andReturn(false);
        SearchCandidatesResponse response = PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, new Object[]{SearchCandidatesResponse.ErrorCode.NO_TURN_PORT}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesNullTurnAddr() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = "testStunAddr";
        Integer stunPort = 1;
        String turnAddr = null;
        Integer turnPort = 2;
        String turnUser = "testTurnUser";
        String turnPass = "testTurnPass";
        String candidates = "testCandidates";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(stunAddr)).andReturn(false);
        SearchCandidatesResponse response = PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, new Object[]{SearchCandidatesResponse.ErrorCode.NO_TURN_ADDR}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesNullStunPort() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = "testStunAddr";
        Integer stunPort = null;
        String turnAddr = "testTurnAddr";
        Integer turnPort = 2;
        String turnUser = "testTurnUser";
        String turnPass = "testTurnPass";
        String candidates = "testCandidates";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(stunAddr)).andReturn(false);
        SearchCandidatesResponse response = PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, new Object[]{SearchCandidatesResponse.ErrorCode.NO_STUN_PORT}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesBlankStunAddr() throws Exception {
        String deviceId = "testDeviceId";
        String stunAddr = " ";
        Integer stunPort = 1;
        String turnAddr = "testTurnAddr";
        Integer turnPort = 2;
        String turnUser = "testTurnUser";
        String turnPass = "testTurnPass";
        String candidates = "testCandidates";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(stunAddr)).andReturn(true);
        SearchCandidatesResponse response = PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, new Object[]{SearchCandidatesResponse.ErrorCode.NO_STUN_ADDR}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesBlankDeviceId() throws Exception {
        String deviceId = "";
        String stunAddr = "testStunAddr";
        Integer stunPort = 1;
        String turnAddr = "testTurnAddr";
        Integer turnPort = 2;
        String turnUser = "testTurnUser";
        String turnPass = "testTurnPass";
        String candidates = "testCandidates";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(true);
        SearchCandidatesResponse response = PowerMock.createMock(SearchCandidatesResponse.class);
        PowerMock.expectNew(SearchCandidatesResponse.class, new Object[]{SearchCandidatesResponse.ErrorCode.NO_DEVICE_ID}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        SearchCandidatesResponse actual = this.restService.searchCandidates(deviceId, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecuteGetHttpCommandViaTcpProxySuccessfully() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = PowerMock.createMock(HttpCommand.class);
        HttpCommand.SendMethod sendMethod = HttpCommand.SendMethod.GET;
        HttpCommand.ConnectionType connectionType = HttpCommand.ConnectionType.TCP_PROXY;
        String url = "testUrl";
        Integer timeout = 10;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(command.getMethod()).andReturn(sendMethod).times(2);
        EasyMock.expect(command.getConnectionType()).andReturn(connectionType);
        EasyMock.expect(command.getUrl()).andReturn(url);
        EasyMock.expect(Utils.isBlank(url)).andReturn(false);
        EasyMock.expect(command.getUrl()).andReturn(url);
        URL urlj = PowerMock.createMock(URL.class);
        PowerMock.expectNew(URL.class, url).andReturn(urlj);
        EasyMock.expect(command.getConnectionType()).andReturn(connectionType);
        HTTPClientService httpClientService = PowerMock.createMock(HTTPClientService.class);
        PowerMock.expectNew(HTTPClientService.class, this.tcpProxy).andReturn(httpClientService);
        EasyMock.expect(command.getTimeout()).andReturn(timeout).times(2);
        httpClientService.setTimeout(timeout.intValue());
        EasyMock.expect(command.getMethod()).andReturn(sendMethod);
        HTTPClientServiceResult result = PowerMock.createMock(HTTPClientServiceResult.class);
        EasyMock.expect(httpClientService.get(deviceId, urlj)).andReturn(result);
        ExecuteHttpCommandResponse response = PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, result).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxySuccessfully() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = PowerMock.createMock(HttpCommand.class);
        HttpCommand.SendMethod sendMethod = HttpCommand.SendMethod.POST;
        HttpCommand.ConnectionType connectionType = HttpCommand.ConnectionType.TCP_PROXY;
        String url = "testUrl";
        Integer timeout = 10;
        String body = "testBody";
        Map headers = PowerMock.createMock(Map.class);
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(command.getMethod()).andReturn(sendMethod).times(2);
        EasyMock.expect(command.getConnectionType()).andReturn(connectionType);
        EasyMock.expect(command.getUrl()).andReturn(url);
        EasyMock.expect(Utils.isBlank(url)).andReturn(false);
        EasyMock.expect(command.getBody()).andReturn(body);
        EasyMock.expect(Utils.isBlank(body)).andReturn(false);
        EasyMock.expect(command.getUrl()).andReturn(url);
        URL urlj = PowerMock.createMock(URL.class);
        PowerMock.expectNew(URL.class, url).andReturn(urlj);
        EasyMock.expect(command.getConnectionType()).andReturn(connectionType);
        HTTPClientService httpClientService = PowerMock.createMock(HTTPClientService.class);
        PowerMock.expectNew(HTTPClientService.class, this.tcpProxy).andReturn(httpClientService);
        EasyMock.expect(command.getTimeout()).andReturn(timeout).times(2);
        httpClientService.setTimeout(timeout.intValue());
        EasyMock.expect(command.getMethod()).andReturn(sendMethod);
        HTTPClientServiceResult result = PowerMock.createMock(HTTPClientServiceResult.class);
        EasyMock.expect(command.getBody()).andReturn(body).times(2);
        byte[] rawBody = new byte[10];
        EasyMock.expect(Base64.decodeBase64(body)).andReturn(rawBody);
        EasyMock.expect(command.getHeaders()).andReturn(headers);
        EasyMock.expect(httpClientService.post(deviceId, urlj, headers, rawBody)).andReturn(result);
        ExecuteHttpCommandResponse response = PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, result).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecuteGetHttpCommandViaTcpClientSuccessfully() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = PowerMock.createMock(HttpCommand.class);
        HttpCommand.SendMethod sendMethod = HttpCommand.SendMethod.GET;
        HttpCommand.ConnectionType connectionType = HttpCommand.ConnectionType.TCP_CLIENT;
        String url = "testUrl";
        Integer timeout = 10;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(command.getMethod()).andReturn(sendMethod).times(2);
        EasyMock.expect(command.getConnectionType()).andReturn(connectionType);
        EasyMock.expect(command.getUrl()).andReturn(url);
        EasyMock.expect(Utils.isBlank(url)).andReturn(false);
        EasyMock.expect(command.getUrl()).andReturn(url);
        URL urlj = PowerMock.createMock(URL.class);
        PowerMock.expectNew(URL.class, url).andReturn(urlj);
        EasyMock.expect(command.getConnectionType()).andReturn(connectionType);
        HTTPClientService httpClientService = PowerMock.createMock(HTTPClientService.class);
        PowerMock.expectNew(HTTPClientService.class, this.tcpClient).andReturn(httpClientService);
        EasyMock.expect(command.getTimeout()).andReturn(timeout).times(2);
        httpClientService.setTimeout(timeout.intValue());
        EasyMock.expect(command.getMethod()).andReturn(sendMethod);
        HTTPClientServiceResult result = PowerMock.createMock(HTTPClientServiceResult.class);
        EasyMock.expect(httpClientService.get(deviceId, urlj)).andReturn(result);
        ExecuteHttpCommandResponse response = PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, result).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxyFailure() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = PowerMock.createMock(HttpCommand.class);
        HttpCommand.SendMethod sendMethod = HttpCommand.SendMethod.POST;
        HttpCommand.ConnectionType connectionType = HttpCommand.ConnectionType.TCP_PROXY;
        String url = "testUrl";
        Integer timeout = 10;
        String body = "testBody";
        Map headers = PowerMock.createMock(Map.class);
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(command.getMethod()).andReturn(sendMethod).times(2);
        EasyMock.expect(command.getConnectionType()).andReturn(connectionType);
        EasyMock.expect(command.getUrl()).andReturn(url);
        EasyMock.expect(Utils.isBlank(url)).andReturn(false);
        EasyMock.expect(command.getBody()).andReturn(body);
        EasyMock.expect(Utils.isBlank(body)).andReturn(false);
        EasyMock.expect(command.getUrl()).andReturn(url);
        URL urlj = PowerMock.createMock(URL.class);
        PowerMock.expectNew(URL.class, url).andReturn(urlj);
        EasyMock.expect(command.getConnectionType()).andReturn(connectionType);
        HTTPClientService httpClientService = PowerMock.createMock(HTTPClientService.class);
        PowerMock.expectNew(HTTPClientService.class, this.tcpProxy).andReturn(httpClientService);
        EasyMock.expect(command.getTimeout()).andReturn(timeout).times(2);
        httpClientService.setTimeout(timeout.intValue());
        EasyMock.expect(command.getMethod()).andReturn(sendMethod);
        EasyMock.expect(command.getBody()).andReturn(body).times(2);
        byte[] rawBody = new byte[10];
        EasyMock.expect(Base64.decodeBase64(body)).andReturn(rawBody);
        EasyMock.expect(command.getHeaders()).andReturn(headers);
        EasyMock.expect(httpClientService.post(deviceId, urlj, headers, rawBody)).andReturn(null);
        ExecuteHttpCommandResponse response = PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, new Object[]{ExecuteHttpCommandResponse.ErrorCode.ERROR}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxyMalformedUrl() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = PowerMock.createMock(HttpCommand.class);
        HttpCommand.SendMethod sendMethod = HttpCommand.SendMethod.POST;
        HttpCommand.ConnectionType connectionType = HttpCommand.ConnectionType.TCP_PROXY;
        String url = "testUrl";
        String body = "testBody";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(command.getMethod()).andReturn(sendMethod).times(2);
        EasyMock.expect(command.getConnectionType()).andReturn(connectionType);
        EasyMock.expect(command.getUrl()).andReturn(url);
        EasyMock.expect(Utils.isBlank(url)).andReturn(false);
        EasyMock.expect(command.getBody()).andReturn(body);
        EasyMock.expect(Utils.isBlank(body)).andReturn(false);
        EasyMock.expect(command.getUrl()).andReturn(url);
        PowerMock.expectNew(URL.class, url).andThrow(new MalformedURLException());
        ExecuteHttpCommandResponse response = PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, new Object[]{ExecuteHttpCommandResponse.ErrorCode.MALFORMED_URL}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxyNoBody() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = PowerMock.createMock(HttpCommand.class);
        HttpCommand.SendMethod sendMethod = HttpCommand.SendMethod.POST;
        HttpCommand.ConnectionType connectionType = HttpCommand.ConnectionType.TCP_PROXY;
        String url = "testUrl";
        String body = "";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(command.getMethod()).andReturn(sendMethod).times(2);
        EasyMock.expect(command.getConnectionType()).andReturn(connectionType);
        EasyMock.expect(command.getUrl()).andReturn(url);
        EasyMock.expect(Utils.isBlank(url)).andReturn(false);
        EasyMock.expect(command.getBody()).andReturn(body);
        EasyMock.expect(Utils.isBlank(body)).andReturn(true);
        ExecuteHttpCommandResponse response = PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, new Object[]{ExecuteHttpCommandResponse.ErrorCode.NO_BODY}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxyNoUrl() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = PowerMock.createMock(HttpCommand.class);
        HttpCommand.SendMethod sendMethod = HttpCommand.SendMethod.POST;
        HttpCommand.ConnectionType connectionType = HttpCommand.ConnectionType.TCP_PROXY;
        String url = "testUrl";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(command.getMethod()).andReturn(sendMethod);
        EasyMock.expect(command.getConnectionType()).andReturn(connectionType);
        EasyMock.expect(command.getUrl()).andReturn(url);
        EasyMock.expect(Utils.isBlank(url)).andReturn(true);
        ExecuteHttpCommandResponse response = PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, new Object[]{ExecuteHttpCommandResponse.ErrorCode.NO_URL}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxyNoConnectionType() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = PowerMock.createMock(HttpCommand.class);
        HttpCommand.SendMethod sendMethod = HttpCommand.SendMethod.POST;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(command.getMethod()).andReturn(sendMethod);
        EasyMock.expect(command.getConnectionType()).andReturn(null);
        ExecuteHttpCommandResponse response = PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, new Object[]{ExecuteHttpCommandResponse.ErrorCode.NO_CONNECTION_TYPE}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxyNoMethod() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        HttpCommand command = PowerMock.createMock(HttpCommand.class);
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(command.getMethod()).andReturn(null);
        ExecuteHttpCommandResponse response = PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, new Object[]{ExecuteHttpCommandResponse.ErrorCode.NO_METHOD}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, command);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxyNoCommand() throws Exception {
        String deviceId = "00:00:00:00:00:00";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        ExecuteHttpCommandResponse response = PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, new Object[]{ExecuteHttpCommandResponse.ErrorCode.NO_COMMAND}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, null);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testExecutePostHttpCommandViaTcpProxyNoDeviceId() throws Exception {
        String deviceId = "";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(true);
        ExecuteHttpCommandResponse response = PowerMock.createMock(ExecuteHttpCommandResponse.class);
        PowerMock.expectNew(ExecuteHttpCommandResponse.class, new Object[]{ExecuteHttpCommandResponse.ErrorCode.NO_DEVICE_ID}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ExecuteHttpCommandResponse actual = this.restService.executeHttpCommand(deviceId, null);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testCreateTcpProxySuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        Integer localPort = 1;
        String dstAddress = "testDstAddress";
        Integer dstPort = 2;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(dstAddress)).andReturn(false);
        TCPProxyApp tcpProxyApp = PowerMock.createMock(TCPProxyApp.class);
        PowerMock.expectNew(TCPProxyApp.class, localPort, deviceId, dstAddress, dstPort, this.tcpProxy, null).andReturn(tcpProxyApp);
        tcpProxyApp.start();
        EasyMock.expect(tcpProxyApp.getLocalPort()).andReturn(localPort);
        CreateTcpProxyResponse response = PowerMock.createMock(CreateTcpProxyResponse.class);
        PowerMock.expectNew(CreateTcpProxyResponse.class, localPort).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        CreateTcpProxyResponse actual = this.restService.createTcpProxy(deviceId, localPort, dstAddress, dstPort);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testCreateTcpProxyNoDstPort() throws Exception {
        String deviceId = "testDeviceId";
        Integer localPort = 1;
        String dstAddress = "testDstAddress";
        Integer dstPort = null;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(dstAddress)).andReturn(false);
        CreateTcpProxyResponse response = PowerMock.createMock(CreateTcpProxyResponse.class);
        PowerMock.expectNew(CreateTcpProxyResponse.class, new Object[]{CreateTcpProxyResponse.ErrorCode.NO_DST_PORT}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        CreateTcpProxyResponse actual = this.restService.createTcpProxy(deviceId, localPort, dstAddress, dstPort);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testCreateTcpProxyNoDstAddress() throws Exception {
        String deviceId = "testDeviceId";
        Integer localPort = 1;
        String dstAddress = "";
        Integer dstPort = 2;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(dstAddress)).andReturn(true);
        CreateTcpProxyResponse response = PowerMock.createMock(CreateTcpProxyResponse.class);
        PowerMock.expectNew(CreateTcpProxyResponse.class, new Object[]{CreateTcpProxyResponse.ErrorCode.NO_DST_ADDRESS}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        CreateTcpProxyResponse actual = this.restService.createTcpProxy(deviceId, localPort, dstAddress, dstPort);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testCreateTcpProxyNoLocalPort() throws Exception {
        String deviceId = "testDeviceId";
        Integer localPort = null;
        String dstAddress = "testDstAddress";
        Integer dstPort = null;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        CreateTcpProxyResponse response = PowerMock.createMock(CreateTcpProxyResponse.class);
        PowerMock.expectNew(CreateTcpProxyResponse.class, new Object[]{CreateTcpProxyResponse.ErrorCode.NO_LOCAL_PORT}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        CreateTcpProxyResponse actual = this.restService.createTcpProxy(deviceId, localPort, dstAddress, dstPort);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testCreateTcpProxyNoDeviceId() throws Exception {
        String deviceId = "";
        Integer localPort = null;
        String dstAddress = "testDstAddress";
        Integer dstPort = null;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(true);
        CreateTcpProxyResponse response = PowerMock.createMock(CreateTcpProxyResponse.class);
        PowerMock.expectNew(CreateTcpProxyResponse.class, new Object[]{CreateTcpProxyResponse.ErrorCode.NO_DEVICE_ID}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        CreateTcpProxyResponse actual = this.restService.createTcpProxy(deviceId, localPort, dstAddress, dstPort);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testConfigureLoggerSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        String data = "testData";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(data)).andReturn(false);
        LoggerConfiguratorService service = PowerMock.createMock(LoggerConfiguratorService.class);
        EasyMock.expect(this.serviceFactory.getLoggerConfiguratorService()).andReturn(service);
        LoggerConfigurationStatus status = LoggerConfigurationStatus.SUCCESS;
        EasyMock.expect(service.configureLogs(deviceId, data)).andReturn(status);
        ConfigureLoggerResponse response = PowerMock.createMock(ConfigureLoggerResponse.class);
        PowerMock.expectNew(ConfigureLoggerResponse.class, new Object[]{status}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ConfigureLoggerResponse actual = this.restService.configureLogger(deviceId, data);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testConfigureLoggerNoConfiguration() throws Exception {
        String deviceId = "testDeviceId";
        String data = "";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(data)).andReturn(true);
        ConfigureLoggerResponse response = PowerMock.createMock(ConfigureLoggerResponse.class);
        PowerMock.expectNew(ConfigureLoggerResponse.class, new Object[]{ConfigureLoggerResponse.ErrorCode.NO_LOGGER_CONFIGURATION}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ConfigureLoggerResponse actual = this.restService.configureLogger(deviceId, data);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testConfigureLoggerNoDeviceId() throws Exception {
        String deviceId = "";
        String data = "testData";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(true);
        ConfigureLoggerResponse response = PowerMock.createMock(ConfigureLoggerResponse.class);
        PowerMock.expectNew(ConfigureLoggerResponse.class, new Object[]{ConfigureLoggerResponse.ErrorCode.NO_DEVICE_ID}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        ConfigureLoggerResponse actual = this.restService.configureLogger(deviceId, data);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testDiscoverCameraIpAddressSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        String mac = "testMac";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(mac)).andReturn(false);
        VivotekCameraIpAddressDiscoveryService service = PowerMock.createMock(VivotekCameraIpAddressDiscoveryService.class);
        EasyMock.expect(this.serviceFactory.getVivotekCameraIpAddressDiscoveryService()).andReturn(service);
        String discoverdIp = "testDiscoveredIp";
        EasyMock.expect(service.getCameraIpAddress(deviceId, mac)).andReturn(discoverdIp);
        DiscoverCameraIpAddressResponse response = PowerMock.createMock(DiscoverCameraIpAddressResponse.class);
        PowerMock.expectNew(DiscoverCameraIpAddressResponse.class, discoverdIp).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        DiscoverCameraIpAddressResponse actual = this.restService.discoverCameraIpAddress(deviceId, mac);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testDiscoverCameraIpNoMac() throws Exception {
        String deviceId = "testDeviceId";
        String mac = "";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(mac)).andReturn(true);
        DiscoverCameraIpAddressResponse response = PowerMock.createMock(DiscoverCameraIpAddressResponse.class);
        PowerMock.expectNew(DiscoverCameraIpAddressResponse.class, new Object[]{DiscoverCameraIpAddressResponse.ErrorCode.NO_MAC}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        DiscoverCameraIpAddressResponse actual = this.restService.discoverCameraIpAddress(deviceId, mac);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testDiscoverCameraIpNoDeviceIp() throws Exception {
        String deviceId = "";
        String mac = "testMac";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(true);
        DiscoverCameraIpAddressResponse response = PowerMock.createMock(DiscoverCameraIpAddressResponse.class);
        PowerMock.expectNew(DiscoverCameraIpAddressResponse.class, new Object[]{DiscoverCameraIpAddressResponse.ErrorCode.NO_DEVICE_ID}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        DiscoverCameraIpAddressResponse actual = this.restService.discoverCameraIpAddress(deviceId, mac);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testDiscoverDeviceSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        String makeText = "vivotek";
        Make make = Make.VIVOTEK;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(makeText)).andReturn(false);
        EasyMock.expect(Make.parse(makeText)).andReturn(make);
        CameraDiscoveryService service = PowerMock.createMock(CameraDiscoveryService.class);
        EasyMock.expect(this.serviceFactory.getCameraDiscoveryService(make)).andReturn(service);
        List devices = PowerMock.createMock(List.class);
        EasyMock.expect(service.discover(deviceId)).andReturn(devices);
        DiscoverDeviceResponse response = PowerMock.createMock(DiscoverDeviceResponse.class);
        PowerMock.expectNew(DiscoverDeviceResponse.class, devices).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        DiscoverDeviceResponse actual = this.restService.discoverDevice(deviceId, makeText);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testDiscoverDeviceFailure() throws Exception {
        String deviceId = "testDeviceId";
        String makeText = "vivotek";
        Make make = Make.VIVOTEK;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(makeText)).andReturn(false);
        EasyMock.expect(Make.parse(makeText)).andReturn(make);
        EasyMock.expect(this.serviceFactory.getCameraDiscoveryService(make)).andReturn(null);
        DiscoverDeviceResponse response = PowerMock.createMock(DiscoverDeviceResponse.class);
        PowerMock.expectNew(DiscoverDeviceResponse.class, new Object[]{DiscoverDeviceResponse.ErrorCode.ERROR}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        DiscoverDeviceResponse actual = this.restService.discoverDevice(deviceId, makeText);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testDiscoverDeviceInvalidMake() throws Exception {
        String deviceId = "testDeviceId";
        String makeText = "vivotek";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(makeText)).andReturn(false);
        EasyMock.expect(Make.parse(makeText)).andReturn(null);
        DiscoverDeviceResponse response = PowerMock.createMock(DiscoverDeviceResponse.class);
        PowerMock.expectNew(DiscoverDeviceResponse.class, new Object[]{DiscoverDeviceResponse.ErrorCode.INVALID_MAKE}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        DiscoverDeviceResponse actual = this.restService.discoverDevice(deviceId, makeText);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testDiscoverDeviceNoMake() throws Exception {
        String deviceId = "testDeviceId";
        String makeText = "";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        EasyMock.expect(Utils.isBlank(makeText)).andReturn(true);
        DiscoverDeviceResponse response = PowerMock.createMock(DiscoverDeviceResponse.class);
        PowerMock.expectNew(DiscoverDeviceResponse.class, new Object[]{DiscoverDeviceResponse.ErrorCode.NO_MAKE}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        DiscoverDeviceResponse actual = this.restService.discoverDevice(deviceId, makeText);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testDiscoverDeviceNoDeviceId() throws Exception {
        String deviceId = "";
        String makeText = "vivotek";
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(true);
        DiscoverDeviceResponse response = PowerMock.createMock(DiscoverDeviceResponse.class);
        PowerMock.expectNew(DiscoverDeviceResponse.class, new Object[]{DiscoverDeviceResponse.ErrorCode.NO_DEVICE_ID}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        DiscoverDeviceResponse actual = this.restService.discoverDevice(deviceId, makeText);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpUpnpForwardingSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        Integer upnpPort = 0;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        UpnpPortForwardingServiceImpl service = PowerMock.createMock(UpnpPortForwardingServiceImpl.class);
        EasyMock.expect(this.serviceFactory.getUpnpPortForwardingServiceImpl()).andReturn(service);
        SetUpUpnpForwardingResult result = PowerMock.createMock(SetUpUpnpForwardingResult.class);
        EasyMock.expect(service.setUpForwarding(deviceId, upnpPort)).andReturn(result);
        SetUpUpnpForwardingResponse response = PowerMock.createMock(SetUpUpnpForwardingResponse.class);
        PowerMock.expectNew(SetUpUpnpForwardingResponse.class, result).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        SetUpUpnpForwardingResponse actual = this.restService.setUpUpnpForwarding(deviceId, upnpPort);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpUpnpForwardingNoDeviceId() throws Exception {
        String deviceId = "";
        Integer upnpPort = 0;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(true);
        SetUpUpnpForwardingResponse response = PowerMock.createMock(SetUpUpnpForwardingResponse.class);
        PowerMock.expectNew(SetUpUpnpForwardingResponse.class, new Object[]{SetUpUpnpForwardingResponse.ErrorCode.NO_DEVICE_ID}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        SetUpUpnpForwardingResponse actual = this.restService.setUpUpnpForwarding(deviceId, upnpPort);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetRegisteredSuccessfully() throws Exception {
        String deviceId = "testDeviceId";
        Boolean registered = true;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        this.sessionDao.registered(deviceId, registered);
        SetRegisteredResponse response = PowerMock.createMock(SetRegisteredResponse.class);
        PowerMock.expectNew(SetRegisteredResponse.class, new Object[0]).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        SetRegisteredResponse actual = this.restService.setRegistered(deviceId, registered);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetRegisteredNoRegiteredStatus() throws Exception {
        String deviceId = "testDeviceId";
        Boolean registered = null;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(false);
        SetRegisteredResponse response = PowerMock.createMock(SetRegisteredResponse.class);
        PowerMock.expectNew(SetRegisteredResponse.class, new Object[]{SetRegisteredResponse.ErrorCode.NO_REGISTERED_STATUS}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        SetRegisteredResponse actual = this.restService.setRegistered(deviceId, registered);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetRegisteredNoDeviceId() throws Exception {
        String deviceId = "";
        Boolean registered = true;
        EasyMock.expect(Utils.isBlank(deviceId)).andReturn(true);
        SetRegisteredResponse response = PowerMock.createMock(SetRegisteredResponse.class);
        PowerMock.expectNew(SetRegisteredResponse.class, new Object[]{SetRegisteredResponse.ErrorCode.NO_DEVICE_ID}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        SetRegisteredResponse actual = this.restService.setRegistered(deviceId, registered);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testAddDomainNameSuccessfully() throws Exception {
        DomainName data = PowerMock.createMock(DomainName.class);
        String name = "testName";
        String mac = "testMac";
        DomainName.AddressType addressType = DomainName.AddressType.PUBLIC;
        EasyMock.expect(data.getName()).andReturn(name).times(2);
        EasyMock.expect(Utils.isBlank(name)).andReturn(false);
        EasyMock.expect(data.getMac()).andReturn(mac).times(2);
        EasyMock.expect(Utils.isBlank(mac)).andReturn(false);
        EasyMock.expect(data.getType()).andReturn(addressType).times(2);
        this.domainNameService.add(name, mac, addressType);
        AddDomainNameResponse response = PowerMock.createMock(AddDomainNameResponse.class);
        PowerMock.expectNew(AddDomainNameResponse.class, new Object[]{Response.Status.SUCCESS}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        AddDomainNameResponse actual = this.restService.addDomainName(data);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testAddDomainNameNoType() throws Exception {
        DomainName data = PowerMock.createMock(DomainName.class);
        String name = "testName";
        String mac = "testMac";
        Object addressType = null;
        EasyMock.expect(data.getName()).andReturn(name);
        EasyMock.expect(Utils.isBlank(name)).andReturn(false);
        EasyMock.expect(data.getMac()).andReturn(mac);
        EasyMock.expect(Utils.isBlank(mac)).andReturn(false);
        EasyMock.expect(data.getType()).andReturn((DomainName.AddressType)((Object)addressType));
        AddDomainNameResponse response = PowerMock.createMock(AddDomainNameResponse.class);
        PowerMock.expectNew(AddDomainNameResponse.class, new Object[]{AddDomainNameResponse.ErrorCode.NO_TYPE}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        AddDomainNameResponse actual = this.restService.addDomainName(data);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testAddDomainNameNoMac() throws Exception {
        DomainName data = PowerMock.createMock(DomainName.class);
        String name = "testName";
        String mac = "";
        EasyMock.expect(data.getName()).andReturn(name);
        EasyMock.expect(Utils.isBlank(name)).andReturn(false);
        EasyMock.expect(data.getMac()).andReturn(mac);
        EasyMock.expect(Utils.isBlank(mac)).andReturn(true);
        AddDomainNameResponse response = PowerMock.createMock(AddDomainNameResponse.class);
        PowerMock.expectNew(AddDomainNameResponse.class, new Object[]{AddDomainNameResponse.ErrorCode.NO_MAC}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        AddDomainNameResponse actual = this.restService.addDomainName(data);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testAddDomainNameNoName() throws Exception {
        DomainName data = PowerMock.createMock(DomainName.class);
        String name = "";
        EasyMock.expect(data.getName()).andReturn(name);
        EasyMock.expect(Utils.isBlank(name)).andReturn(true);
        AddDomainNameResponse response = PowerMock.createMock(AddDomainNameResponse.class);
        PowerMock.expectNew(AddDomainNameResponse.class, new Object[]{AddDomainNameResponse.ErrorCode.NO_NAME}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        AddDomainNameResponse actual = this.restService.addDomainName(data);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDomainNameSuccessfully() throws Exception {
        String name = "testName";
        String mac = "testMac";
        DomainName.AddressType type = DomainName.AddressType.LOCAL;
        EasyMock.expect(Utils.isBlank(name)).andReturn(false);
        DomainNameValue value = PowerMock.createMock(DomainNameValue.class);
        EasyMock.expect(this.domainNameService.get(name)).andReturn(value);
        GetDomainNameResponse response = PowerMock.createMock(GetDomainNameResponse.class);
        DomainName domainName = PowerMock.createMock(DomainName.class);
        EasyMock.expect(value.getMac()).andReturn(mac);
        EasyMock.expect(value.getType()).andReturn(type);
        PowerMock.expectNew(DomainName.class, new Object[]{name, mac, type}).andReturn(domainName);
        PowerMock.expectNew(GetDomainNameResponse.class, new Object[]{Response.Status.SUCCESS, domainName}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        GetDomainNameResponse actual = this.restService.getDomainName(name);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDomainNameNotFound() throws Exception {
        String name = "testName";
        EasyMock.expect(Utils.isBlank(name)).andReturn(false);
        EasyMock.expect(this.domainNameService.get(name)).andReturn(null);
        GetDomainNameResponse response = PowerMock.createMock(GetDomainNameResponse.class);
        PowerMock.expectNew(GetDomainNameResponse.class, new Object[]{Response.Status.SUCCESS, null}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        GetDomainNameResponse actual = this.restService.getDomainName(name);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDomainNameNoName() throws Exception {
        String name = "";
        EasyMock.expect(Utils.isBlank(name)).andReturn(true);
        GetDomainNameResponse response = PowerMock.createMock(GetDomainNameResponse.class);
        PowerMock.expectNew(GetDomainNameResponse.class, new Object[]{GetDomainNameResponse.ErrorCode.NO_NAME}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        GetDomainNameResponse actual = this.restService.getDomainName(name);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveDomainNameSuccessfully() throws Exception {
        String name = "testName";
        EasyMock.expect(Utils.isBlank(name)).andReturn(false);
        this.domainNameService.remove(name);
        RemoveDomainNameResponse response = PowerMock.createMock(RemoveDomainNameResponse.class);
        PowerMock.expectNew(RemoveDomainNameResponse.class, new Object[]{Response.Status.SUCCESS}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        RemoveDomainNameResponse actual = this.restService.removeDomainName(name);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveDomainNameNoName() throws Exception {
        String name = "";
        EasyMock.expect(Utils.isBlank(name)).andReturn(true);
        RemoveDomainNameResponse response = PowerMock.createMock(RemoveDomainNameResponse.class);
        PowerMock.expectNew(RemoveDomainNameResponse.class, new Object[]{RemoveDomainNameResponse.ErrorCode.NO_NAME}).andReturn(response);
        PowerMock.replayAll(new Object[0]);
        RemoveDomainNameResponse actual = this.restService.removeDomainName(name);
        Assert.assertEquals(response, actual);
        PowerMock.verifyAll();
    }
}

