/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.db.entity;

import homemonitor.Utility;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;

public class SessionEntity
implements Serializable {
    private static final long serialVersionUID = 7601077234246104549L;
    private byte[] publicIp;
    private byte[] localIp;
    private byte[] serverUrl;
    private Boolean registered;
    private Boolean connected = true;

    public SessionEntity() {
    }

    public SessionEntity(String publicIp, String localIp, String serverUrl, Boolean registered) throws URISyntaxException {
        this();
        this.setPublicIp(publicIp);
        this.setLocalIp(localIp);
        this.setServerUrl(serverUrl);
        this.setRegistered(registered);
    }

    public String getPublicIp() {
        return Utility.byteArrayToString(this.publicIp, ".");
    }

    public void setPublicIp(String publicIp) {
        this.publicIp = Utility.ipAddressToByteArray(publicIp);
    }

    public String getLocalIp() {
        return Utility.byteArrayToString(this.localIp, ".");
    }

    public void setLocalIp(String localIp) {
        this.localIp = Utility.ipAddressToByteArray(localIp);
    }

    public String getServerUrl() {
        if (!this.connected.booleanValue()) {
            return null;
        }
        String ip = Utility.byteArrayToString(this.serverUrl, 0, 4, ".");
        int port = Utility.byteArrayToInt(this.serverUrl, 4, 2);
        boolean isHttps = Utility.byteArrayToInt(this.serverUrl, 6, 1) == 1;
        return String.format("%s://%s:%d", isHttps ? "https" : "http", ip, port);
    }

    public void setServerUrl(String serverUrl) {
        try {
            URI serverUri = new URI(serverUrl);
            String serverIp = serverUri.getHost();
            int serverPort = serverUri.getPort();
            byte isHttps = serverUri.getScheme().equals("https") ? (byte)1 : 0;
            this.serverUrl = new byte[7];
            ByteBuffer buffer = ByteBuffer.wrap(this.serverUrl);
            buffer.put(Utility.ipAddressToByteArray(serverIp));
            buffer.putShort((short)serverPort);
            buffer.put(isHttps);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public boolean isRegistered() {
        return this.registered == null ? false : this.registered;
    }

    public Boolean getRegistered() {
        return this.registered;
    }

    public void setRegistered(Boolean registered) {
        this.registered = registered;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.localIp == null ? 0 : this.localIp.hashCode());
        result = 31 * result + (this.publicIp == null ? 0 : this.publicIp.hashCode());
        result = 31 * result + (this.registered == null ? 0 : this.registered.hashCode());
        result = 31 * result + (this.serverUrl == null ? 0 : this.serverUrl.hashCode());
        result = 31 * result + (this.connected == null ? 0 : this.connected.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionEntity other = (SessionEntity)obj;
        if (this.localIp == null ? other.localIp != null : !this.localIp.equals(other.localIp)) {
            return false;
        }
        if (this.publicIp == null ? other.publicIp != null : !this.publicIp.equals(other.publicIp)) {
            return false;
        }
        if (this.registered == null ? other.registered != null : !this.registered.equals(other.registered)) {
            return false;
        }
        if (this.serverUrl == null ? other.serverUrl != null : !this.serverUrl.equals(other.serverUrl)) {
            return false;
        }
        return !(this.connected == null ? other.connected != null : !this.connected.equals(other.connected));
    }

    public String dump() {
        return "SessionEntity [publicIp=" + this.publicIp + ", localIp=" + this.localIp + ", serverUrl=" + this.serverUrl + ", registered=" + this.registered + ", connected=" + this.connected + "]";
    }

    public String toString() {
        return this.dump();
    }
}

