/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.ec;

import de.flexiprovider.api.KeyAgreement;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidKeySpecException;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.KeyFactory;
import de.flexiprovider.api.keys.KeyPair;
import de.flexiprovider.api.keys.KeyPairGenerator;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.common.ies.IES;
import de.flexiprovider.common.math.ellipticcurves.Point;
import de.flexiprovider.ec.ECSVDPDHC;
import de.flexiprovider.ec.keys.ECKeyFactory;
import de.flexiprovider.ec.keys.ECKeyPairGenerator;
import de.flexiprovider.ec.keys.ECPrivateKey;
import de.flexiprovider.ec.keys.ECPublicKey;
import de.flexiprovider.ec.keys.ECPublicKeySpec;
import de.flexiprovider.ec.parameters.CurveParams;

public class ECIES
extends IES {
    public String getName() {
        return "ECIES";
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (key instanceof ECPrivateKey) {
            return ((ECPrivateKey)key).getParams().getQ().bitLength();
        }
        if (key instanceof ECPublicKey) {
            return ((ECPublicKey)key).getParams().getQ().bitLength();
        }
        throw new InvalidKeyException("unsupported type");
    }

    protected PublicKey checkPubKey(Key key) throws InvalidKeyException {
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        ECPublicKey ecPubKey = (ECPublicKey)key;
        this.keyParams = ecPubKey.getParams();
        return ecPubKey;
    }

    protected PrivateKey checkPrivKey(Key key) throws InvalidKeyException {
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        ECPrivateKey ecPrivKey = (ECPrivateKey)key;
        this.keyParams = ecPrivKey.getParams();
        return ecPrivKey;
    }

    protected KeyAgreement getKeyAgreement() {
        return new ECSVDPDHC();
    }

    protected KeyPair generateEphKeyPair() {
        ECKeyPairGenerator kpg = new ECKeyPairGenerator();
        try {
            ((KeyPairGenerator)kpg).initialize(this.keyParams, this.random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
        return ((KeyPairGenerator)kpg).genKeyPair();
    }

    protected byte[] encodeEphPubKey(PublicKey ephPubKey) {
        Point q;
        try {
            q = ((ECPublicKey)ephPubKey).getW();
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("internal error");
        }
        return q.EC2OSP(1);
    }

    protected int getEncEphPubKeySize() {
        Point g = ((CurveParams)this.keyParams).getG();
        return g.EC2OSP(1).length;
    }

    protected PublicKey decodeEphPubKey(byte[] encEphPubKey) {
        try {
            ECPublicKeySpec ecPubKeySpec = new ECPublicKeySpec(encEphPubKey, (CurveParams)this.keyParams);
            ECKeyFactory kf = new ECKeyFactory();
            return ((KeyFactory)kf).generatePublic(ecPubKeySpec);
        }
        catch (InvalidParameterSpecException e) {
            throw new RuntimeException("InvalidParameterSpecException: " + e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("InvalidKeySpecException: " + e.getMessage());
        }
    }
}

