/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.mode;

import de.flexiprovider.api.Mode;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.mode.ModeParameterSpec;

public class CTR
extends Mode {
    private byte[] counter;
    private byte[] feedbackBlock;

    protected final void initEncrypt(SecretKey key, ModeParameterSpec modeParams, AlgorithmParameterSpec cipherParams) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initCipherEncrypt(key, cipherParams);
        this.initCommon(modeParams);
    }

    protected final void initDecrypt(SecretKey key, ModeParameterSpec modeParams, AlgorithmParameterSpec cipherParams) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initCipherDecrypt(key, cipherParams);
        this.initCommon(modeParams);
    }

    private void initCommon(ModeParameterSpec modeParams) {
        this.blockSize = this.getCipherBlockSize();
        this.iv = new byte[this.blockSize];
        if (modeParams != null) {
            byte[] iv = modeParams.getIV();
            if (iv.length < this.blockSize) {
                System.arraycopy(iv, 0, this.iv, 0, iv.length);
            } else if (iv.length > this.blockSize) {
                System.arraycopy(iv, 0, this.iv, 0, this.blockSize);
            } else {
                this.iv = iv;
            }
        }
        this.feedbackBlock = new byte[this.blockSize];
        this.counter = new byte[this.blockSize];
        this.reset();
    }

    protected final void nextChunkEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
        this.singleBlockEncrypt(this.counter, 0, this.feedbackBlock, 0);
        int inCarry = 1;
        int i = this.blockSize - 1;
        while (i >= 0) {
            output[outOff + i] = (byte)(this.feedbackBlock[i] ^ input[inOff + i]);
            int x = (this.counter[i] & 0xFF) + inCarry;
            this.counter[i] = (byte)x;
            inCarry = x > 255 ? 1 : 0;
            --i;
        }
    }

    protected final void nextChunkDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
        this.nextChunkEncrypt(input, inOff, output, outOff);
    }

    protected final void reset() {
        System.arraycopy(this.iv, 0, this.counter, 0, this.blockSize);
    }
}

