/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math.ellipticcurves;

import de.flexiprovider.api.Registry;
import de.flexiprovider.common.exceptions.DifferentCurvesException;
import de.flexiprovider.common.exceptions.DifferentFieldsException;
import de.flexiprovider.common.exceptions.InvalidFormatException;
import de.flexiprovider.common.exceptions.InvalidPointException;
import de.flexiprovider.common.exceptions.NoQuadraticResidueException;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.math.IntegerFunctions;
import de.flexiprovider.common.math.ellipticcurves.EllipticCurveGFP;
import de.flexiprovider.common.math.ellipticcurves.Point;
import de.flexiprovider.common.math.finitefields.GFElement;
import de.flexiprovider.common.math.finitefields.GFPElement;
import de.flexiprovider.common.util.FlexiBigIntUtils;
import java.util.Random;

public class PointGFP
extends Point {
    private GFPElement mA;
    private GFPElement mB;
    private GFPElement mX;
    private GFPElement mY;
    private GFPElement mZ;
    private GFPElement mZ2;
    private GFPElement mZ3;
    private GFPElement mAZ4;

    public PointGFP(EllipticCurveGFP E) {
        this.mE = E;
        this.mP = E.getQ();
        this.mA = (GFPElement)E.getA();
        this.mB = (GFPElement)E.getB();
        this.assignZero();
    }

    public PointGFP(EllipticCurveGFP E, Random rand) {
        GFPElement minusOne;
        this.mE = E;
        this.mP = E.getQ();
        this.mA = (GFPElement)E.getA();
        this.mB = (GFPElement)E.getB();
        this.mY = minusOne = new GFPElement(FlexiBigInt.ONE.negate(), E.getQ());
        GFElement y2 = null;
        GFElement x = null;
        while (this.mY.equals(minusOne)) {
            FlexiBigInt value = new FlexiBigInt(this.mP.bitLength(), Registry.getSecureRandom());
            this.mX = new GFPElement(value, this.mP);
            y2 = this.mA.multiply(this.mX);
            x = this.mX.multiply(this.mX);
            x.multiplyThisBy(this.mX);
            y2.addToThis(x.add(this.mB));
            try {
                value = IntegerFunctions.ressol(y2.toFlexiBigInt(), this.mP);
                this.mY = new GFPElement(value, this.mP);
            }
            catch (NoQuadraticResidueException NQRExc) {
                this.mY = minusOne;
            }
        }
        this.mZ = GFPElement.ONE(this.mP);
        this.mZ2 = GFPElement.ONE(this.mP);
        this.mZ3 = GFPElement.ONE(this.mP);
        this.mAZ4 = this.mA;
    }

    public PointGFP(GFPElement x, GFPElement y, EllipticCurveGFP E) throws InvalidPointException, DifferentFieldsException {
        this.mE = E;
        this.mP = E.getQ();
        this.mA = (GFPElement)E.getA();
        this.mB = (GFPElement)E.getB();
        this.mX = (GFPElement)x.clone();
        this.mY = (GFPElement)y.clone();
        this.mZ = GFPElement.ONE(this.mP);
        this.mZ2 = null;
        this.mZ3 = null;
        this.mAZ4 = null;
    }

    public PointGFP(GFPElement x, GFPElement y, GFPElement z, EllipticCurveGFP E) throws InvalidPointException, DifferentFieldsException {
        this.mE = E;
        this.mP = E.getQ();
        this.mA = (GFPElement)E.getA();
        this.mB = (GFPElement)E.getB();
        this.mX = x;
        this.mY = y;
        this.mZ = z;
        this.mZ2 = null;
        this.mZ3 = null;
        this.mAZ4 = null;
    }

    public PointGFP(byte[] encoded, EllipticCurveGFP E) throws InvalidPointException, InvalidFormatException {
        GFPElement y;
        GFPElement x;
        this.mE = E;
        this.mP = E.getQ();
        this.mA = (GFPElement)E.getA();
        this.mB = (GFPElement)E.getB();
        if (encoded.length == 1 && encoded[0] == 0) {
            this.assignZero();
            return;
        }
        byte pc = encoded[0];
        switch (pc) {
            case 2: 
            case 3: {
                byte[] bX = new byte[encoded.length - 1];
                System.arraycopy(encoded, 1, bX, 0, bX.length);
                x = new GFPElement(new FlexiBigInt(1, bX), this.mP);
                boolean yMod2 = (pc & 1) == 1;
                y = this.decompress(yMod2, x);
                break;
            }
            case 4: {
                int l = encoded.length - 1 >> 1;
                byte[] bX = new byte[l];
                byte[] bY = new byte[l];
                System.arraycopy(encoded, 1, bX, 0, l);
                System.arraycopy(encoded, 1 + l, bY, 0, l);
                x = new GFPElement(new FlexiBigInt(1, bX), this.mP);
                y = new GFPElement(new FlexiBigInt(1, bY), this.mP);
                break;
            }
            case 6: 
            case 7: {
                boolean yMod2;
                int l = encoded.length - 1 >> 1;
                byte[] bX = new byte[l];
                byte[] bY = new byte[l];
                System.arraycopy(encoded, 1, bX, 0, l);
                System.arraycopy(encoded, 1 + l, bY, 0, l);
                x = new GFPElement(new FlexiBigInt(1, bX), this.mP);
                y = new GFPElement(new FlexiBigInt(1, bY), this.mP);
                boolean bl = yMod2 = (pc & 1) == 1;
                if (this.decompress(yMod2, x).equals(y)) break;
                throw new InvalidPointException();
            }
            default: {
                throw new InvalidFormatException(pc);
            }
        }
        GFPElement z = GFPElement.ONE(this.mP);
        this.assign(x, y, z);
    }

    public PointGFP(PointGFP other) {
        this.mE = other.mE;
        this.mP = other.mP;
        this.mA = other.mA;
        this.mB = other.mB;
        this.assign(other);
    }

    private void assignZero() {
        this.mX = GFPElement.ONE(this.mP);
        this.mY = GFPElement.ONE(this.mP);
        this.mZ = GFPElement.ZERO(this.mP);
        this.mZ2 = null;
        this.mZ3 = null;
        this.mAZ4 = null;
    }

    private void assign(GFPElement x, GFPElement y, GFPElement z) {
        this.mX = x;
        this.mY = y;
        this.mZ = z;
        this.mZ2 = null;
        this.mZ3 = null;
        this.mAZ4 = null;
    }

    private void assign(PointGFP other) {
        this.mX = (GFPElement)other.mX.clone();
        this.mY = (GFPElement)other.mY.clone();
        this.mZ = (GFPElement)other.mZ.clone();
        this.mZ2 = null;
        this.mZ3 = null;
        this.mAZ4 = null;
    }

    public Object clone() {
        return new PointGFP(this);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof PointGFP)) {
            return false;
        }
        PointGFP otherPoint = (PointGFP)other;
        if (!this.mE.equals(otherPoint.mE)) {
            return false;
        }
        if (this.isZero() && otherPoint.isZero()) {
            return true;
        }
        GFElement oX = (GFElement)otherPoint.mX.clone();
        GFElement oY = (GFElement)otherPoint.mY.clone();
        GFElement oZ = (GFElement)otherPoint.mZ.clone();
        if (this.mZ.isOne() && oZ.isOne() && (!oX.equals(this.mX) || !oY.equals(this.mY))) {
            return false;
        }
        if (!this.mZ.isOne()) {
            GFElement z = (GFElement)this.mZ.clone();
            GFElement z2 = z.multiply(z);
            GFElement z3 = z2.multiply(z);
            oX.multiplyThisBy(z2);
            oY.multiplyThisBy(z3);
        }
        GFElement x = (GFElement)this.mX.clone();
        GFElement y = (GFElement)this.mY.clone();
        if (!oZ.isOne()) {
            GFElement oZ2 = oZ.multiply(oZ);
            GFElement oZ3 = oZ2.multiply(oZ);
            x.multiplyThisBy(oZ2);
            y.multiplyThisBy(oZ3);
        }
        return oX.equals(x) && oY.equals(y);
    }

    public int hashCode() {
        return this.getXAffin().hashCode() + this.getYAffin().hashCode();
    }

    public String toString() {
        if (this.isZero()) {
            return "(0, 0)";
        }
        return "(" + this.getXAffin().toString() + ",\n " + this.getYAffin().toString() + ")";
    }

    public GFElement getX() {
        return this.mX;
    }

    public GFElement getY() {
        return this.mY;
    }

    public GFElement getZ() {
        return this.mZ;
    }

    public GFElement getXAffin() {
        if (this.isZero()) {
            return GFPElement.ZERO(this.mP);
        }
        if (this.mZ2 == null) {
            this.mZ2 = (GFPElement)this.mZ.multiply(this.mZ);
        }
        return this.mX.multiply(this.mZ2.invert());
    }

    public GFElement getYAffin() {
        if (this.isZero()) {
            return GFPElement.ZERO(this.mP);
        }
        if (this.mZ3 == null) {
            this.mZ3 = (GFPElement)this.mZ.multiply(this.mZ).multiply(this.mZ);
        }
        return this.mY.multiply(this.mZ3.invert());
    }

    public Point getAffin() {
        if (!this.mZ.isOne() && !this.mZ.isZero()) {
            GFElement z = this.mZ.invert();
            GFElement z2 = z.multiply(z);
            z.multiplyThisBy(z2);
            GFElement x = this.mX.multiply(z2);
            GFElement y = this.mY.multiply(z);
            return new PointGFP((GFPElement)x, (GFPElement)y, (EllipticCurveGFP)this.mE);
        }
        return this;
    }

    public boolean onCurve() {
        if (this.isZero()) {
            return true;
        }
        GFElement y2 = this.mY.multiply(this.mY);
        GFElement x3 = this.mX.multiply(this.mX).multiply(this.mX);
        if (this.mZ.isOne()) {
            GFElement ax = this.mA.multiply(this.mX);
            return y2.equals(x3.add(ax).add(this.mB));
        }
        if (this.mZ2 == null) {
            this.mZ2 = (GFPElement)this.mZ.multiply(this.mZ);
        }
        if (this.mZ3 == null) {
            this.mZ3 = (GFPElement)this.mZ2.multiply(this.mZ);
        }
        if (this.mAZ4 == null) {
            this.mAZ4 = (GFPElement)this.mZ3.multiply(this.mZ).multiply(this.mA);
        }
        GFElement aXZ4 = this.mAZ4.multiply(this.mX);
        GFElement bZ6 = this.mB.multiply(this.mZ3).multiply(this.mZ3);
        return y2.equals(x3.add(aXZ4).add(bZ6));
    }

    public boolean isZero() {
        return this.mX.isOne() && this.mY.isOne() && this.mZ.isZero();
    }

    public Point add(Point other) {
        PointGFP result = new PointGFP(this);
        result.addToThis(other);
        return result;
    }

    public void addToThis(Point other) {
        if (!(other instanceof PointGFP)) {
            throw new DifferentCurvesException();
        }
        PointGFP otherPoint = (PointGFP)other;
        if (this.isZero()) {
            this.assign(otherPoint);
            return;
        }
        if (other.isZero()) {
            return;
        }
        GFPElement oX = otherPoint.mX;
        GFPElement oY = otherPoint.mY;
        GFPElement oZ = otherPoint.mZ;
        GFElement oZ2 = otherPoint.mZ2;
        GFElement oZ3 = otherPoint.mZ3;
        GFElement U1 = null;
        GFElement U2 = null;
        GFElement S1 = null;
        GFElement S2 = null;
        if (oZ.isOne()) {
            U1 = this.mX;
            S1 = this.mY;
        } else {
            if (oZ2 == null || oZ3 == null) {
                oZ2 = oZ.multiply(oZ);
                oZ3 = oZ2.multiply(oZ);
            }
            U1 = this.mX.multiply(oZ2);
            S1 = this.mY.multiply(oZ3);
        }
        if (this.mZ.isOne()) {
            U2 = oX;
            S2 = oY;
        } else {
            if (this.mZ2 == null || this.mZ3 == null) {
                this.mZ2 = (GFPElement)this.mZ.multiply(this.mZ);
                this.mZ3 = (GFPElement)this.mZ2.multiply(this.mZ);
            }
            U2 = oX.multiply(this.mZ2);
            S2 = oY.multiply(this.mZ3);
        }
        GFElement H = U2.subtract(U1);
        GFElement r = S2.subtract(S1);
        if (H.isZero()) {
            if (r.isZero()) {
                this.multiplyThisBy2();
                return;
            }
            this.assignZero();
            return;
        }
        U2 = H.multiply(H);
        S2 = U2.multiply(H);
        U2.multiplyThisBy(U1);
        GFElement x = r.multiply(r).subtract(S2).subtract(U2.add(U2));
        GFElement z = S1.multiply(S2);
        GFElement y = r.multiply(U2.subtract(x)).subtract(z);
        if (this.mZ.isOne()) {
            z = !oZ.isOne() ? oZ.multiply(H) : H;
        } else if (!oZ.isOne()) {
            U1 = this.mZ.multiply(oZ);
            z = U1.multiply(H);
        } else {
            z = this.mZ.multiply(H);
        }
        this.assign((GFPElement)x, (GFPElement)y, (GFPElement)z);
    }

    public Point addAffine(Point other) {
        PointGFP p = (PointGFP)this.getAffin();
        PointGFP o = (PointGFP)other.getAffin();
        if (this.isZero()) {
            return new PointGFP(o);
        }
        if (other.isZero()) {
            return new PointGFP(p);
        }
        GFPElement oX = o.mX;
        GFPElement oY = o.mY;
        GFPElement pX = p.mX;
        GFPElement pY = p.mY;
        FlexiBigInt boX = oX.toFlexiBigInt();
        FlexiBigInt boY = oY.toFlexiBigInt();
        FlexiBigInt bpX = pX.toFlexiBigInt();
        FlexiBigInt bpY = pY.toFlexiBigInt();
        if (pX == oX && pY == oY) {
            return p.multiplyBy2Affine();
        }
        FlexiBigInt lambda = boX.subtract(bpX).modInverse(this.mP);
        lambda = lambda.multiply(boY.subtract(bpY)).mod(this.mP);
        FlexiBigInt x = lambda.multiply(lambda).mod(this.mP);
        x = x.subtract(bpX).subtract(boX);
        x = x.mod(this.mP);
        FlexiBigInt y = bpX.subtract(x);
        y = y.multiply(lambda);
        y = y.subtract(bpY).mod(this.mP);
        GFPElement gfpx = new GFPElement(x, this.mP);
        GFPElement gfpy = new GFPElement(y, this.mP);
        try {
            return new PointGFP(gfpx, gfpy, (EllipticCurveGFP)this.mE);
        }
        catch (InvalidPointException IPExc) {
            throw new RuntimeException("InvalidPointException: " + IPExc.getMessage());
        }
    }

    public Point subtract(Point other) {
        PointGFP result = new PointGFP(this);
        result.subtractFromThis(other);
        return result;
    }

    public void subtractFromThis(Point other) {
        if (!(other instanceof PointGFP)) {
            throw new DifferentCurvesException();
        }
        PointGFP minusOther = (PointGFP)other.negate();
        if (this.isZero()) {
            this.assign(minusOther.mX, minusOther.mY, minusOther.mZ);
        } else {
            this.addToThis(minusOther);
        }
    }

    public Point negate() {
        PointGFP result = new PointGFP(this);
        result.negateThis();
        return result;
    }

    public void negateThis() {
        if (!this.isZero()) {
            FlexiBigInt y = this.mP.add(this.mY.toFlexiBigInt().negate());
            this.mY = new GFPElement(y, this.mP);
        }
    }

    public Point multiplyBy2() {
        PointGFP result = new PointGFP(this);
        result.multiplyThisBy2();
        return result;
    }

    public void multiplyThisBy2() {
        if (this.isZero()) {
            this.assignZero();
            return;
        }
        if (this.mY.isZero()) {
            this.assignZero();
            return;
        }
        GFElement z = this.mY.multiply(this.mY);
        GFElement S = this.mX.multiply(z);
        GFElement x = S.add(S);
        S = x.add(x);
        if (this.mAZ4 == null) {
            if (this.mZ.isOne()) {
                this.mAZ4 = (GFPElement)this.mA.clone();
            } else {
                if (this.mZ2 == null) {
                    this.mZ2 = (GFPElement)this.mZ.multiply(this.mZ);
                }
                x = this.mZ2.multiply(this.mZ2);
                this.mAZ4 = (GFPElement)this.mA.multiply(x);
            }
        }
        GFElement y = this.mX.multiply(this.mX);
        GFElement M = y.add(y).add(y).add(this.mAZ4);
        x = M.multiply(M).subtract(S.add(S));
        y = z.multiply(z);
        GFElement U = y.add(y);
        z = U.add(U);
        U = z.add(z);
        y = M.multiply(S.subtract(x)).subtract(U);
        z = !this.mZ.isOne() ? this.mY.multiply(this.mZ) : this.mY;
        z = z.add(z);
        this.assign((GFPElement)x, (GFPElement)y, (GFPElement)z);
    }

    public Point multiplyBy2Affine() {
        if (this.isZero()) {
            return new PointGFP((EllipticCurveGFP)this.mE);
        }
        if (this.mY.equals(FlexiBigInt.ZERO)) {
            return new PointGFP((EllipticCurveGFP)this.mE);
        }
        PointGFP p = (PointGFP)this.getAffin();
        FlexiBigInt pX = p.mX.toFlexiBigInt();
        FlexiBigInt pY = p.mY.toFlexiBigInt();
        FlexiBigInt tmp = pY.add(pY).modInverse(this.mP);
        FlexiBigInt lambda = pX.multiply(pX).mod(this.mP);
        lambda = lambda.multiply(new FlexiBigInt(Integer.toString(3))).mod(this.mP);
        lambda = lambda.add(this.mA.toFlexiBigInt());
        lambda = lambda.multiply(tmp).mod(this.mP);
        FlexiBigInt x = lambda.multiply(lambda).mod(this.mP);
        x = x.subtract(pX.add(pX)).mod(this.mP);
        FlexiBigInt y = pX.subtract(x);
        y = lambda.multiply(y);
        y = y.subtract(pY).mod(this.mP);
        GFPElement gfpx = new GFPElement(x, this.mP);
        GFPElement gfpy = new GFPElement(y, this.mP);
        return new PointGFP(gfpx, gfpy, (EllipticCurveGFP)p.mE);
    }

    byte[] encodeUncompressed() {
        if (this.isZero()) {
            return new byte[1];
        }
        int l = this.mP.bitLength();
        int dummy = l & 7;
        if (dummy != 0) {
            l += 8 - dummy;
        }
        byte[] encoded = new byte[((l >>>= 3) << 1) + 1];
        encoded[0] = 4;
        FlexiBigInt x = this.getXAffin().toFlexiBigInt();
        FlexiBigInt y = this.getYAffin().toFlexiBigInt();
        byte[] bX = FlexiBigIntUtils.toMinimalByteArray(x);
        byte[] bY = FlexiBigIntUtils.toMinimalByteArray(y);
        System.arraycopy(bX, 0, encoded, 1 + l - bX.length, bX.length);
        System.arraycopy(bY, 0, encoded, 1 + (l << 1) - bY.length, bY.length);
        return encoded;
    }

    byte[] encodeCompressed() {
        if (this.isZero()) {
            return new byte[1];
        }
        int l = this.mP.bitLength();
        int dummy = l & 7;
        if (dummy != 0) {
            l += 8 - dummy;
        }
        byte[] encoded = new byte[(l >>>= 3) + 1];
        encoded[0] = 2;
        FlexiBigInt x = this.getXAffin().toFlexiBigInt();
        byte[] bX = FlexiBigIntUtils.toMinimalByteArray(x);
        System.arraycopy(bX, 0, encoded, 1 + l - bX.length, bX.length);
        FlexiBigInt y = this.getYAffin().toFlexiBigInt();
        if (y.testBit(0)) {
            encoded[0] = (byte)(encoded[0] | 1);
        }
        return encoded;
    }

    byte[] encodeHybrid() {
        if (this.isZero()) {
            return new byte[1];
        }
        int l = this.mP.bitLength();
        int dummy = l & 7;
        if (dummy != 0) {
            l += 8 - dummy;
        }
        byte[] encoded = new byte[((l >>>= 3) << 1) + 1];
        encoded[0] = 6;
        FlexiBigInt x = this.getXAffin().toFlexiBigInt();
        FlexiBigInt y = this.getYAffin().toFlexiBigInt();
        byte[] bX = FlexiBigIntUtils.toMinimalByteArray(x);
        byte[] bY = FlexiBigIntUtils.toMinimalByteArray(y);
        System.arraycopy(bX, 0, encoded, 1 + l - bX.length, bX.length);
        System.arraycopy(bY, 0, encoded, 1 + (l << 1) - bY.length, bY.length);
        if (y.testBit(0)) {
            encoded[0] = (byte)(encoded[0] | 1);
        }
        return encoded;
    }

    private GFPElement decompress(boolean yMod2, GFElement x) throws InvalidPointException {
        FlexiBigInt z;
        FlexiBigInt xVal = x.toFlexiBigInt();
        FlexiBigInt x3 = xVal.multiply(xVal).multiply(xVal);
        FlexiBigInt g = this.mA.toFlexiBigInt().multiply(xVal);
        g = g.add(x3);
        g = g.add(this.mB.toFlexiBigInt());
        g = g.mod(this.mP);
        try {
            z = IntegerFunctions.ressol(g, this.mP);
        }
        catch (NoQuadraticResidueException NQRExc) {
            throw new InvalidPointException("NoQuadraticResidueException: " + NQRExc.getMessage());
        }
        boolean zMod2 = z.testBit(0);
        if (zMod2 && !yMod2 || !zMod2 && yMod2) {
            z = this.mP.subtract(z);
        }
        return new GFPElement(z, this.mP);
    }
}

